/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexCursorCollectionValue;
import com.orientechnologies.orient.core.index.OIndexCursorSingleValue;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OQueryOperatorContainsValue
extends OQueryOperatorEqualityNotNulls {
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OQueryOperatorContainsValue() {
        super("CONTAINSVALUE", 5, false);
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (!(iRight instanceof OSQLFilterCondition) && !(iLeft instanceof OSQLFilterCondition)) {
            return OIndexReuseType.INDEX_METHOD;
        }
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        OIndexCursor cursor;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            if (!(indexDefinition instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)indexDefinition).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.VALUE) {
                return null;
            }
            Object key = ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0));
            if (key == null) {
                return null;
            }
            Object indexResult = index.get(key);
            cursor = indexResult == null || indexResult instanceof OIdentifiable ? new OIndexCursorSingleValue((OIdentifiable)indexResult, key) : new OIndexCursorCollectionValue((Collection)indexResult, key);
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            if (!(compositeIndexDefinition.getMultiValueDefinition() instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)compositeIndexDefinition.getMultiValueDefinition()).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.VALUE) {
                return null;
            }
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams);
            if (keyOne == null) {
                return null;
            }
            if (internalIndex.hasRangeQuerySupport()) {
                OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams);
                cursor = index.iterateEntriesBetween(keyOne, true, keyTwo, true, ascSortOrder);
            } else if (indexDefinition.getParamCount() == keyParams.size()) {
                Object indexResult = index.get(keyOne);
                cursor = indexResult == null || indexResult instanceof OIdentifiable ? new OIndexCursorSingleValue((OIdentifiable)indexResult, keyOne) : new OIndexCursorCollectionValue((Collection)indexResult, keyOne);
            } else {
                return null;
            }
        }
        this.updateProfiler(iContext, index, keyParams, indexDefinition);
        return cursor;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        Iterator<Object> iterator;
        Map<String, Object> map;
        OProperty property;
        Object record;
        String fieldName;
        OSQLFilterCondition condition = iCondition.getLeft() instanceof OSQLFilterCondition ? (OSQLFilterCondition)iCondition.getLeft() : (iCondition.getRight() instanceof OSQLFilterCondition ? (OSQLFilterCondition)iCondition.getRight() : null);
        OType type = null;
        if (iCondition.getLeft() instanceof OSQLFilterItemField && ((OSQLFilterItemField)iCondition.getLeft()).isFieldChain() && ((OSQLFilterItemField)iCondition.getLeft()).getFieldChain().getItemCount() == 1 && (fieldName = ((OSQLFilterItemField)iCondition.getLeft()).getFieldChain().getItemName(0)) != null && (record = iRecord.getRecord()) instanceof ODocument && (property = ((ODocument)record).getSchemaClass().getProperty(fieldName)) != null && property.getType().isMultiValue()) {
            type = property.getLinkedType();
        }
        Object right = iRight;
        if (type != null) {
            right = OType.convert(iRight, type.getDefaultJavaType());
        }
        if (iLeft instanceof Map) {
            map = (Map<String, Object>)iLeft;
            if (condition != null) {
                for (Object object : map.values()) {
                    Object object2 = this.loadIfNeed(object);
                    if (!((Boolean)condition.evaluate((ODocument)object2, null, iContext)).booleanValue()) continue;
                    return true;
                }
                return false;
            } else {
                Map<String, Object> convertedRight;
                void var11_13;
                iterator = map.values().iterator();
                do {
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    Object object = iterator.next();
                    convertedRight = iRight;
                    if (object instanceof ODocument && iRight instanceof Map) {
                        Map<String, Object> map2 = ((ODocument)object).toMap();
                    }
                    if (!(var11_13 instanceof Map) || !(iRight instanceof ODocument)) continue;
                    convertedRight = ((ODocument)((Object)iRight)).toMap();
                } while (!OQueryOperatorEquals.equals(var11_13, convertedRight));
                return true;
            }
        }
        if (!(iRight instanceof Map)) return false;
        map = iRight;
        if (condition == null || !(iterator = map.values().iterator()).hasNext()) return false;
        Object object3 = iterator.next();
        object3 = this.loadIfNeed(object3);
        if (!((Boolean)condition.evaluate((ODocument)object3, null, iContext)).booleanValue()) return map.containsValue(iLeft);
        return true;
    }

    private Object loadIfNeed(Object o) {
        ORecord record = (ORecord)o;
        if (record.getRecord().getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                o = record.load();
            }
            catch (ORecordNotFoundException e) {
                throw OException.wrapException(new ODatabaseException("Error during loading record with id : " + record.getIdentity()), e);
            }
        }
        return o;
    }
}

