/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OOrderBy;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OQueryCursor
implements Iterator<OIdentifiable> {
    private int limit;
    private int skip;
    private OWhereClause filter;
    private Iterator<OIdentifiable> iterator;
    private OOrderBy orderBy;
    private OCommandContext ctx;
    private OIdentifiable next = null;
    private long countFetched = 0L;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OQueryCursor() {
    }

    public OQueryCursor(Iterator<OIdentifiable> oIdentifiableIterator, OWhereClause filter, OOrderBy orderBy, int skip, int limit, OCommandContext ctx) {
        this.iterator = oIdentifiableIterator;
        this.filter = filter;
        this.skip = skip;
        this.limit = limit;
        this.orderBy = orderBy;
        this.ctx = ctx;
        this.loadNext();
    }

    private void loadNext() {
        if (this.iterator == null) {
            this.next = null;
            return;
        }
        if (this.limit > 0 && this.countFetched >= (long)this.limit) {
            this.next = null;
            return;
        }
        if (this.countFetched == 0L && this.skip > 0) {
            for (int i = 0; i < this.skip; ++i) {
                this.next = this.getNextFromIterator();
                if (this.next != null) continue;
                return;
            }
        }
        this.next = this.getNextFromIterator();
        ++this.countFetched;
    }

    private OIdentifiable getNextFromIterator() {
        OIdentifiable result;
        do {
            if (this.iterator == null || !this.iterator.hasNext()) {
                return null;
            }
            result = this.iterator.next();
        } while (this.filter != null && !this.filter.matchesFilters(result, this.ctx));
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public OIdentifiable next() {
        OIdentifiable result = this.next;
        if (result == null) {
            throw new NoSuchElementException();
        }
        this.loadNext();
        return result;
    }
}

