/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OLetClause;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OTimeout;
import com.orientechnologies.orient.core.sql.parser.OUpdateOperations;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OUpdateStatement
extends OStatement {
    public OFromClause target;
    protected List<OUpdateOperations> operations = new ArrayList<OUpdateOperations>();
    protected boolean upsert = false;
    protected boolean returnBefore = false;
    protected boolean returnAfter = false;
    protected boolean returnCount = false;
    protected OProjection returnProjection;
    public OLetClause let;
    public OWhereClause whereClause;
    public OStorage.LOCKING_STRATEGY lockRecord = null;
    public OLimit limit;
    public OTimeout timeout;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OUpdateStatement(int id) {
        super(id);
    }

    public OUpdateStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append(this.getStatementType());
        if (this.target != null) {
            this.target.toString(params, builder);
        }
        for (OUpdateOperations ops : this.operations) {
            builder.append(" ");
            ops.toString(params, builder);
        }
        if (this.upsert) {
            builder.append(" UPSERT");
        }
        if (this.returnBefore || this.returnAfter || this.returnCount) {
            builder.append(" RETURN");
            if (this.returnBefore) {
                builder.append(" BEFORE");
            } else if (this.returnAfter) {
                builder.append(" AFTER");
            } else {
                builder.append(" COUNT");
            }
            if (this.returnProjection != null) {
                builder.append(" ");
                this.returnProjection.toString(params, builder);
            }
        }
        if (this.let != null) {
            builder.append(" ");
            this.let.toString(params, builder);
        }
        if (this.whereClause != null) {
            builder.append(" WHERE ");
            this.whereClause.toString(params, builder);
        }
        if (this.lockRecord != null) {
            builder.append(" LOCK ");
            switch (this.lockRecord) {
                case DEFAULT: {
                    builder.append("DEFAULT");
                    break;
                }
                case EXCLUSIVE_LOCK: {
                    builder.append("RECORD");
                    break;
                }
                case SHARED_LOCK: {
                    builder.append("SHARED");
                    break;
                }
                case NONE: {
                    builder.append("NONE");
                }
            }
        }
        if (this.limit != null) {
            this.limit.toString(params, builder);
        }
        if (this.timeout != null) {
            this.timeout.toString(params, builder);
        }
    }

    protected String getStatementType() {
        return "UPDATE ";
    }
}

