/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.query;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.command.OCommandRequestAsynch;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLQuery;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class OSQLNonBlockingQuery<T>
extends OSQLQuery<T>
implements OCommandRequestAsynch {
    private static final long serialVersionUID = 1L;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OSQLNonBlockingQuery() {
    }

    public OSQLNonBlockingQuery(String iText, OCommandResultListener iResultListener) {
        this(iText, -1, iResultListener);
    }

    public OSQLNonBlockingQuery(String iText, int iLimit, String iFetchPlan, Map<Object, Object> iArgs, OCommandResultListener iResultListener) {
        this(iText, iLimit, iResultListener);
        this.fetchPlan = iFetchPlan;
        this.parameters = iArgs;
    }

    public OSQLNonBlockingQuery(String iText, int iLimit, OCommandResultListener iResultListener) {
        super(iText);
        this.limit = iLimit;
        this.resultListener = iResultListener;
    }

    public <RET> RET execute2(String iText, Object ... iArgs) {
        this.text = iText;
        return this.execute(iArgs);
    }

    public T executeFirst() {
        this.execute(1);
        return null;
    }

    @Override
    public <RET> RET execute(final Object ... iArgs) {
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().get();
        final ONonBlockingQueryFuture future = new ONonBlockingQueryFuture();
        if (database instanceof ODatabaseDocumentTx) {
            ODatabaseDocumentInternal currentThreadLocal = ODatabaseRecordThreadLocal.instance().getIfDefined();
            final ODatabaseDocumentTx db = ((ODatabaseDocumentTx)database).copy();
            if (currentThreadLocal != null) {
                currentThreadLocal.activateOnCurrentThread();
            } else {
                ODatabaseRecordThreadLocal.instance().set(null);
            }
            Thread t = new Thread(new Runnable(){
                private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    db.activateOnCurrentThread();
                    try {
                        OSQLAsynchQuery query = new OSQLAsynchQuery(OSQLNonBlockingQuery.this.getText(), OSQLNonBlockingQuery.this.getResultListener());
                        query.setFetchPlan(OSQLNonBlockingQuery.this.getFetchPlan());
                        query.setLimit(OSQLNonBlockingQuery.this.getLimit());
                        query.execute(iArgs);
                    }
                    catch (RuntimeException e) {
                        if (OSQLNonBlockingQuery.this.getResultListener() != null) {
                            OSQLNonBlockingQuery.this.getResultListener().end();
                        }
                        throw e;
                    }
                    finally {
                        if (db != null) {
                            try {
                                db.close();
                            }
                            catch (Exception e) {
                                OLogManager.instance().error(this, "Error during database close", e, new Object[0]);
                            }
                        }
                        try {
                            ONonBlockingQueryFuture e = future;
                            synchronized (e) {
                                future.finished = true;
                                future.notifyAll();
                            }
                        }
                        catch (Exception e) {
                            OLogManager.instance().error(this, "", e, new Object[0]);
                        }
                    }
                }
            });
            t.start();
            t.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            return (RET)future;
        }
        throw new RuntimeException("cannot run non blocking query with non tx db");
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    @Override
    public boolean isAsynchronous() {
        return true;
    }

    public class ONonBlockingQueryFuture
    implements Future,
    List<Future> {
        protected volatile boolean finished = false;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.finished;
        }

        public synchronized Object get() throws InterruptedException, ExecutionException {
            while (!this.finished) {
                this.wait();
            }
            return OSQLNonBlockingQuery.this.getResultListener().getResult();
        }

        public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            while (!this.finished) {
                this.wait();
            }
            return OSQLNonBlockingQuery.this.getResultListener().getResult();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return o == this;
        }

        @Override
        public Iterator<Future> iterator() {
            return new Iterator<Future>(){
                private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Future next() {
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Unsuppored remove on non blocking query result");
                }
            };
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return null;
        }

        @Override
        public boolean add(Future future) {
            return false;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends Future> c) {
            return false;
        }

        @Override
        public boolean addAll(int index, Collection<? extends Future> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public Future get(int index) {
            if (index == 0) {
                return this;
            }
            return null;
        }

        public boolean isIdempotent() {
            return false;
        }

        @Override
        public Future set(int index, Future element) {
            return null;
        }

        @Override
        public void add(int index, Future element) {
        }

        @Override
        public Future remove(int index) {
            return this.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return 0;
        }

        @Override
        public int lastIndexOf(Object o) {
            return 0;
        }

        @Override
        public ListIterator<Future> listIterator() {
            return null;
        }

        @Override
        public ListIterator<Future> listIterator(int index) {
            return null;
        }

        @Override
        public List<Future> subList(int fromIndex, int toIndex) {
            return null;
        }
    }
}

