/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache;

import com.orientechnologies.orient.core.storage.cache.OCachePointer;

public class OCacheEntry {
    OCachePointer dataPointer;
    final long fileId;
    final long pageIndex;
    boolean dirty;
    int usagesCount;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OCacheEntry(long fileId, long pageIndex, OCachePointer dataPointer, boolean dirty) {
        this.fileId = fileId;
        this.pageIndex = pageIndex;
        this.dataPointer = dataPointer;
        this.dirty = dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public OCachePointer getCachePointer() {
        return this.dataPointer;
    }

    public void clearCachePointer() {
        this.dataPointer = null;
    }

    public void setCachePointer(OCachePointer cachePointer) {
        this.dataPointer = cachePointer;
    }

    public long getFileId() {
        return this.fileId;
    }

    public long getPageIndex() {
        return this.pageIndex;
    }

    public void acquireExclusiveLock() {
        this.dataPointer.acquireExclusiveLock();
    }

    public void releaseExclusiveLock() {
        this.dataPointer.releaseExclusiveLock();
    }

    public void acquireSharedLock() {
        this.dataPointer.acquireSharedLock();
    }

    public void releaseSharedLock() {
        this.dataPointer.releaseSharedLock();
    }

    public int getUsagesCount() {
        return this.usagesCount;
    }

    public void incrementUsages() {
        ++this.usagesCount;
    }

    public boolean isLockAcquiredByCurrentThread() {
        return this.dataPointer.isLockAcquiredByCurrentThread();
    }

    public void decrementUsages() {
        --this.usagesCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCacheEntry that = (OCacheEntry)o;
        if (this.fileId != that.fileId) {
            return false;
        }
        if (this.dirty != that.dirty) {
            return false;
        }
        if (this.pageIndex != that.pageIndex) {
            return false;
        }
        if (this.usagesCount != that.usagesCount) {
            return false;
        }
        return !(this.dataPointer != null ? !this.dataPointer.equals(that.dataPointer) : that.dataPointer != null);
    }

    public int hashCode() {
        int result = (int)(this.fileId ^ this.fileId >>> 32);
        result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
        result = 31 * result + (this.dataPointer != null ? this.dataPointer.hashCode() : 0);
        result = 31 * result + (this.dirty ? 1 : 0);
        result = 31 * result + this.usagesCount;
        return result;
    }

    public String toString() {
        return "OReadCacheEntry{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + ", dataPointer=" + this.dataPointer + ", dirty=" + this.dirty + ", usagesCount=" + this.usagesCount + '}';
    }
}

