/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.pages;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.pages.OPageCache;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class OLruPageCache
implements OPageCache {
    private final OReadCache readCache;
    private final int maximumSize;
    private final int evictionBatchSize;
    private final LinkedHashMap<Key, Record> pages;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OLruPageCache(OReadCache readCache, int maximumSize, int evictionBatchSize) {
        this.readCache = readCache;
        this.maximumSize = maximumSize;
        this.evictionBatchSize = evictionBatchSize;
        this.pages = new LinkedHashMap(maximumSize * 2, 0.75f, true);
    }

    @Override
    public OCacheEntry loadPage(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache, int pageCount) throws IOException {
        Key key = new Key(fileId, pageIndex);
        Record record = this.pages.get(key);
        if (record != null) {
            ++record.usages;
            return record.cacheEntry;
        }
        OCacheEntry cacheEntry = this.readCache.load(fileId, pageIndex, checkPinnedPages, writeCache, pageCount, true);
        if (cacheEntry == null) {
            return null;
        }
        if (this.pages.size() - this.maximumSize < this.evictionBatchSize) {
            this.pages.put(key, new Record(cacheEntry));
        } else {
            Iterator<Record> i = this.pages.values().iterator();
            while (i.hasNext()) {
                Record r = i.next();
                if (r.usages > 0L) continue;
                for (long j = r.usages; j <= 0L; ++j) {
                    this.readCache.release(r.cacheEntry, writeCache);
                }
                i.remove();
                if (this.pages.size() >= this.maximumSize) continue;
                this.pages.put(key, new Record(cacheEntry));
                break;
            }
        }
        return cacheEntry;
    }

    @Override
    public void releasePage(OCacheEntry cacheEntry, OWriteCache writeCache) {
        Key key = new Key(cacheEntry.getFileId(), cacheEntry.getPageIndex());
        Record record = this.pages.get(key);
        if (record == null) {
            this.readCache.release(cacheEntry, writeCache);
        } else {
            --record.usages;
        }
    }

    @Override
    public void releaseFilePages(long fileId, OWriteCache writeCache) {
        Iterator<Record> i = this.pages.values().iterator();
        while (i.hasNext()) {
            Record r = i.next();
            if (fileId != r.cacheEntry.getFileId()) continue;
            assert (r.usages <= 0L);
            for (long j = r.usages; j <= 0L; ++j) {
                this.readCache.release(r.cacheEntry, writeCache);
            }
            i.remove();
            break;
        }
    }

    @Override
    public OCacheEntry purgePage(long fileId, long pageIndex, OWriteCache writeCache) {
        Key key = new Key(fileId, pageIndex);
        Record record = (Record)this.pages.remove(key);
        assert (record == null || record.usages <= 0L);
        if (record != null) {
            for (long j = record.usages; j < 0L; ++j) {
                this.readCache.release(record.cacheEntry, writeCache);
            }
            return record.cacheEntry;
        }
        return null;
    }

    @Override
    public void reset(OWriteCache writeCache) {
        for (Record r : this.pages.values()) {
            assert (r.usages <= 0L);
            for (long j = r.usages; j <= 0L; ++j) {
                this.readCache.release(r.cacheEntry, writeCache);
            }
        }
        this.pages.clear();
    }

    static {
        try {
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }

    private static class Record {
        public final OCacheEntry cacheEntry;
        public long usages = 1L;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public Record(OCacheEntry cacheEntry) {
            this.cacheEntry = cacheEntry;
        }
    }

    private static class Key {
        public final long fileId;
        public final long pageIndex;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public Key(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public int hashCode() {
            return (int)(this.fileId ^ this.fileId >>> 32 ^ this.pageIndex);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            Key other = (Key)obj;
            return this.pageIndex == other.pageIndex && this.fileId == other.fileId;
        }
    }
}

