/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OClusterPage
extends ODurablePage {
    private static final int VERSION_SIZE = 4;
    private static final int NEXT_PAGE_OFFSET = 28;
    private static final int PREV_PAGE_OFFSET = 36;
    private static final int FREELIST_HEADER_OFFSET = 44;
    private static final int FREE_POSITION_OFFSET = 48;
    private static final int FREE_SPACE_COUNTER_OFFSET = 52;
    private static final int ENTRIES_COUNT_OFFSET = 56;
    private static final int PAGE_INDEXES_LENGTH_OFFSET = 60;
    private static final int PAGE_INDEXES_OFFSET = 64;
    private static final int INDEX_ITEM_SIZE = 8;
    private static final int MARKED_AS_DELETED_FLAG = 65536;
    private static final int POSITION_MASK = 65535;
    public static final int PAGE_SIZE;
    public static final int MAX_ENTRY_SIZE;
    public static final int MAX_RECORD_SIZE;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OClusterPage(OCacheEntry cacheEntry, boolean newPage, OWALChanges changes) throws IOException {
        super(cacheEntry, changes);
        if (newPage) {
            this.setLongValue(28, -1L);
            this.setLongValue(36, -1L);
            this.setIntValue(48, PAGE_SIZE);
            this.setIntValue(52, PAGE_SIZE - 64);
        }
    }

    public int appendRecord(int recordVersion, byte[] record) throws IOException {
        int entryIndex;
        int freePosition = this.getIntValue(48);
        int indexesLength = this.getIntValue(60);
        int lastEntryIndexPosition = 64 + indexesLength * 8;
        int entrySize = record.length + 12;
        int freeListHeader = this.getIntValue(44);
        if (!this.checkSpace(entrySize, freeListHeader)) {
            return -1;
        }
        if (freeListHeader > 0) {
            if (freePosition - entrySize < lastEntryIndexPosition) {
                this.doDefragmentation();
            }
        } else if (freePosition - entrySize < lastEntryIndexPosition + 8) {
            this.doDefragmentation();
        }
        freePosition = this.getIntValue(48);
        freePosition -= entrySize;
        if (freeListHeader > 0) {
            entryIndex = freeListHeader - 1;
            int tombstonePointer = this.getIntValue(64 + 8 * entryIndex);
            int nextEntryPosition = tombstonePointer & 0xFFFF;
            if (nextEntryPosition > 0) {
                this.setIntValue(44, nextEntryPosition);
            } else {
                this.setIntValue(44, 0);
            }
            this.setIntValue(52, this.getFreeSpace() - entrySize);
            int entryIndexPosition = 64 + entryIndex * 8;
            this.setIntValue(entryIndexPosition, freePosition);
            this.setIntValue(entryIndexPosition + 4, recordVersion);
        } else {
            entryIndex = indexesLength;
            this.setIntValue(60, indexesLength + 1);
            this.setIntValue(52, this.getFreeSpace() - entrySize - 8);
            int entryIndexPosition = 64 + entryIndex * 8;
            this.setIntValue(entryIndexPosition, freePosition);
            this.setIntValue(entryIndexPosition + 4, recordVersion);
        }
        int entryPosition = freePosition;
        this.setIntValue(entryPosition, entrySize);
        this.setIntValue(entryPosition += 4, entryIndex);
        this.setIntValue(entryPosition += 4, record.length);
        this.setBinaryValue(entryPosition += 4, record);
        this.setIntValue(48, freePosition);
        this.incrementEntriesCount();
        return entryIndex;
    }

    public int replaceRecord(int entryIndex, byte[] record, int recordVersion) throws IOException {
        int writtenBytes;
        int entryPointer;
        int entryPosition;
        int recordSize;
        int entryIndexPosition = 64 + entryIndex * 8;
        if (recordVersion != -1) {
            this.setIntValue(entryIndexPosition + 4, recordVersion);
        }
        if (record.length <= (recordSize = this.getIntValue(entryPosition = (entryPointer = this.getIntValue(entryIndexPosition)) & 0xFFFF) - 12)) {
            this.setIntValue(entryPointer + 8, record.length);
            this.setBinaryValue(entryPointer + 12, record);
            writtenBytes = record.length;
        } else {
            byte[] newRecord = new byte[recordSize];
            System.arraycopy(record, 0, newRecord, 0, newRecord.length);
            this.setBinaryValue(entryPointer + 12, newRecord);
            writtenBytes = newRecord.length;
        }
        return writtenBytes;
    }

    public int getRecordVersion(int position) {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return -1;
        }
        int entryIndexPosition = 64 + position * 8;
        return this.getIntValue(entryIndexPosition + 4);
    }

    public boolean isEmpty() {
        return this.getFreeSpace() == PAGE_SIZE - 64;
    }

    private boolean checkSpace(int entrySize, int freeListHeader) {
        return !(freeListHeader > 0 ? this.getFreeSpace() - entrySize < 0 : this.getFreeSpace() - entrySize - 8 < 0);
    }

    public boolean deleteRecord(int position) throws IOException {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return false;
        }
        int entryIndexPosition = 64 + 8 * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        if ((entryPointer & 0x10000) != 0) {
            return false;
        }
        int entryPosition = entryPointer & 0xFFFF;
        int freeListHeader = this.getIntValue(44);
        if (freeListHeader <= 0) {
            this.setIntValue(entryIndexPosition, 65536);
        } else {
            this.setIntValue(entryIndexPosition, freeListHeader | 0x10000);
        }
        this.setIntValue(44, position + 1);
        int entrySize = this.getIntValue(entryPosition);
        assert (entrySize > 0);
        this.setIntValue(entryPosition, -entrySize);
        this.setIntValue(52, this.getFreeSpace() + entrySize);
        this.decrementEntriesCount();
        return true;
    }

    public boolean isDeleted(int position) {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return true;
        }
        int entryIndexPosition = 64 + 8 * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        return (entryPointer & 0x10000) != 0;
    }

    public int getRecordSize(int position) {
        int indexesLength = this.getIntValue(60);
        if (position >= indexesLength) {
            return -1;
        }
        int entryIndexPosition = 64 + 8 * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        if ((entryPointer & 0x10000) != 0) {
            return -1;
        }
        int entryPosition = entryPointer & 0xFFFF;
        return this.getIntValue(entryPosition + 8);
    }

    public int findFirstDeletedRecord(int position) {
        int indexesLength = this.getIntValue(60);
        for (int i = position; i < indexesLength; ++i) {
            int entryIndexPosition = 64 + 8 * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) == 0) continue;
            return i;
        }
        return -1;
    }

    public int findFirstRecord(int position) {
        int indexesLength = this.getIntValue(60);
        for (int i = position; i < indexesLength; ++i) {
            int entryIndexPosition = 64 + 8 * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) != 0) continue;
            return i;
        }
        return -1;
    }

    public int findLastRecord(int position) {
        int endIndex;
        int indexesLength = this.getIntValue(60);
        for (int i = endIndex = Math.min(indexesLength - 1, position); i >= 0; --i) {
            int entryIndexPosition = 64 + 8 * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) != 0) continue;
            return i;
        }
        return -1;
    }

    public int getFreeSpace() {
        return this.getIntValue(52);
    }

    public int getMaxRecordSize() {
        int freeListHeader = this.getIntValue(44);
        int maxEntrySize = freeListHeader > 0 ? this.getFreeSpace() : this.getFreeSpace() - 8;
        int result = maxEntrySize - 12;
        if (result < 0) {
            return 0;
        }
        return result;
    }

    public int getRecordsCount() {
        return this.getIntValue(56);
    }

    public long getNextPage() {
        return this.getLongValue(28);
    }

    public void setNextPage(long nextPage) throws IOException {
        this.setLongValue(28, nextPage);
    }

    public long getPrevPage() {
        return this.getLongValue(36);
    }

    public void setPrevPage(long prevPage) throws IOException {
        this.setLongValue(36, prevPage);
    }

    public void setRecordLongValue(int recordPosition, int offset, long value) throws IOException {
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * 8;
        int entryPointer = this.getIntValue(entryIndexPosition);
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, 8));
            this.setLongValue(entryPosition + offset + 12, value);
        } else {
            int recordSize = this.getIntValue(entryPosition + 8);
            assert (this.insideRecordBounds(entryPosition, recordSize + offset, 8));
            this.setLongValue(entryPosition + 12 + recordSize + offset, value);
        }
    }

    public long getRecordLongValue(int recordPosition, int offset) {
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * 8;
        int entryPointer = this.getIntValue(entryIndexPosition);
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, 8));
            return this.getLongValue(entryPosition + offset + 12);
        }
        int recordSize = this.getIntValue(entryPosition + 8);
        assert (this.insideRecordBounds(entryPosition, recordSize + offset, 8));
        return this.getLongValue(entryPosition + 12 + recordSize + offset);
    }

    public byte[] getRecordBinaryValue(int recordPosition, int offset, int size) throws IOException {
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * 8;
        int entryPointer = this.getIntValue(entryIndexPosition);
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, size));
            return this.getBinaryValue(entryPosition + offset + 12, size);
        }
        int recordSize = this.getIntValue(entryPosition + 8);
        assert (this.insideRecordBounds(entryPosition, recordSize + offset, 8));
        return this.getBinaryValue(entryPosition + 12 + recordSize + offset, size);
    }

    public byte getRecordByteValue(int recordPosition, int offset) {
        assert (this.isPositionInsideInterval(recordPosition));
        int entryIndexPosition = 64 + recordPosition * 8;
        int entryPointer = this.getIntValue(entryIndexPosition);
        int entryPosition = entryPointer & 0xFFFF;
        if (offset >= 0) {
            assert (this.insideRecordBounds(entryPosition, offset, 1));
            return this.getByteValue(entryPosition + offset + 12);
        }
        int recordSize = this.getIntValue(entryPosition + 8);
        assert (this.insideRecordBounds(entryPosition, recordSize + offset, 1));
        return this.getByteValue(entryPosition + 12 + recordSize + offset);
    }

    public void dumpToLog() {
        StringBuilder text = new StringBuilder();
        text.append("Dump of ").append(this).append('\n');
        text.append("Magic:\t\t\t").append(String.format("%016X", this.getLongValue(0))).append('\n');
        text.append("CRC32:\t\t\t").append(String.format("%08X", this.getIntValue(8))).append('\n');
        text.append("WAL Segment:\t").append(String.format("%016X", this.getLongValue(12))).append('\n');
        text.append("WAL Position:\t").append(String.format("%016X", this.getLongValue(20))).append('\n');
        text.append("Next Page:\t\t").append(String.format("%016X", this.getLongValue(28))).append('\n');
        text.append("Prev Page:\t\t").append(String.format("%016X", this.getLongValue(36))).append('\n');
        text.append("Free List:\t\t").append(String.format("%08X", this.getIntValue(44))).append('\n');
        text.append("Free Pointer:\t").append(String.format("%08X", this.getIntValue(48))).append('\n');
        text.append("Free Space:\t\t").append(String.format("%08X", this.getIntValue(52))).append('\n');
        text.append("Entry Count:\t").append(String.format("%08X", this.getIntValue(56))).append('\n');
        int indexCount = this.getIntValue(60);
        text.append("Index Count:\t").append(String.format("%08X", indexCount)).append("\n\n");
        int foundEntries = 0;
        for (int i = 0; i < indexCount; ++i) {
            int offset = this.getIntValue(64 + i * 8);
            text.append("\tOffset:\t\t").append(String.format("%08X", offset)).append(" (").append(i).append(")\n");
            text.append("\tVersion:\t").append(String.format("%08X", this.getIntValue(64 + i * 8 + 4))).append('\n');
            if ((offset & 0x10000) != 0) continue;
            int cleanOffset = offset & 0xFFFF;
            text.append("\t\tEntry Size:\t");
            if (cleanOffset + 4 <= MAX_PAGE_SIZE_BYTES) {
                text.append(String.format("%08X", this.getIntValue(cleanOffset))).append(" (").append(foundEntries).append(")\n");
            } else {
                text.append("?\n");
            }
            if (cleanOffset + 8 <= MAX_PAGE_SIZE_BYTES) {
                text.append("\t\tIndex:\t\t").append(String.format("%08X", this.getIntValue(cleanOffset + 4))).append('\n');
            } else {
                text.append("?\n");
            }
            if (cleanOffset + 12 <= MAX_PAGE_SIZE_BYTES) {
                text.append("\t\tData Size:\t").append(String.format("%08X", this.getIntValue(cleanOffset + 8))).append('\n');
            } else {
                text.append("?\n");
            }
            ++foundEntries;
        }
        OLogManager.instance().error(this, "%s", null, text);
    }

    private boolean insideRecordBounds(int entryPosition, int offset, int contentSize) {
        int recordSize = this.getIntValue(entryPosition + 8);
        if (offset < 0) {
            return false;
        }
        return offset + contentSize <= recordSize;
    }

    private void incrementEntriesCount() throws IOException {
        this.setIntValue(56, this.getRecordsCount() + 1);
    }

    private void decrementEntriesCount() throws IOException {
        this.setIntValue(56, this.getRecordsCount() - 1);
    }

    private boolean isPositionInsideInterval(int recordPosition) {
        int indexesLength = this.getIntValue(60);
        return recordPosition < indexesLength;
    }

    private void doDefragmentation() throws IOException {
        int freePosition;
        int currentPosition = freePosition = this.getIntValue(48);
        ArrayList<Integer> processedPositions = new ArrayList<Integer>();
        while (currentPosition < PAGE_SIZE) {
            int entrySize = this.getIntValue(currentPosition);
            if (entrySize > 0) {
                int positionIndex = this.getIntValue(currentPosition + 4);
                processedPositions.add(positionIndex);
                currentPosition += entrySize;
                continue;
            }
            entrySize = -entrySize;
            this.moveData(freePosition, freePosition + entrySize, currentPosition - freePosition);
            currentPosition += entrySize;
            freePosition += entrySize;
            this.shiftPositions(processedPositions, entrySize);
        }
        this.setIntValue(48, freePosition);
    }

    private void shiftPositions(List<Integer> processedPositions, int entrySize) throws IOException {
        for (int positionIndex : processedPositions) {
            int entryIndexPosition = 64 + 8 * positionIndex;
            int entryPosition = this.getIntValue(entryIndexPosition);
            this.setIntValue(entryIndexPosition, entryPosition + entrySize);
        }
    }

    static {
        try {
            try {
                PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
                MAX_ENTRY_SIZE = PAGE_SIZE - 64 - 8;
                MAX_RECORD_SIZE = MAX_ENTRY_SIZE - 12;
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

