/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitBodyRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class OAtomicUnitEndRecord
extends OOperationUnitBodyRecord {
    private boolean rollback;
    private Map<String, OAtomicOperationMetadata<?>> atomicOperationMetadataMap = new LinkedHashMap();
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OAtomicUnitEndRecord() {
    }

    OAtomicUnitEndRecord(OOperationUnitId operationUnitId, boolean rollback, Map<String, OAtomicOperationMetadata<?>> atomicOperationMetadataMap) throws IOException {
        super(operationUnitId);
        this.rollback = rollback;
        assert (operationUnitId != null);
        if (atomicOperationMetadataMap != null && atomicOperationMetadataMap.size() > 0) {
            this.atomicOperationMetadataMap = atomicOperationMetadataMap;
        }
    }

    public boolean isRollback() {
        return this.rollback;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        content[offset] = this.rollback ? (byte)1 : 0;
        ++offset;
        if (this.atomicOperationMetadataMap.size() > 0) {
            for (Map.Entry<String, OAtomicOperationMetadata<?>> entry : this.atomicOperationMetadataMap.entrySet()) {
                if (entry.getKey().equals("rid")) {
                    content[offset] = 1;
                    ORecordOperationMetadata recordOperationMetadata = (ORecordOperationMetadata)entry.getValue();
                    Object rids = recordOperationMetadata.getValue();
                    OIntegerSerializer.INSTANCE.serializeNative(rids.size(), content, ++offset, new Object[0]);
                    offset += 4;
                    Iterator iterator = rids.iterator();
                    while (iterator.hasNext()) {
                        ORID rid = (ORID)iterator.next();
                        OLongSerializer.INSTANCE.serializeNative(rid.getClusterPosition(), content, offset, new Object[0]);
                        OIntegerSerializer.INSTANCE.serializeNative(rid.getClusterId(), content, offset += 8, new Object[0]);
                        offset += 4;
                    }
                    continue;
                }
                throw new IllegalStateException("Invalid metadata key rid");
            }
        } else {
            ++offset;
        }
        return offset;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        this.rollback = content[offset = super.fromStream(content, offset)] > 0;
        this.atomicOperationMetadataMap = new LinkedHashMap();
        byte metadataId = content[++offset];
        ++offset;
        if (metadataId == 1) {
            int collectionsSize = OIntegerSerializer.INSTANCE.deserializeNative(content, offset);
            offset += 4;
            ORecordOperationMetadata recordOperationMetadata = new ORecordOperationMetadata();
            for (int i = 0; i < collectionsSize; ++i) {
                long clusterPosition = OLongSerializer.INSTANCE.deserializeNative(content, offset);
                int clusterId = OIntegerSerializer.INSTANCE.deserializeNative(content, offset += 8);
                offset += 4;
                recordOperationMetadata.addRid(new ORecordId(clusterId, clusterPosition));
            }
            this.atomicOperationMetadataMap.put(recordOperationMetadata.getKey(), recordOperationMetadata);
        } else if (metadataId > 0) {
            throw new IllegalStateException("Invalid metadata entry id " + metadataId);
        }
        return offset;
    }

    public Map<String, OAtomicOperationMetadata<?>> getAtomicOperationMetadata() {
        return Collections.unmodifiableMap(this.atomicOperationMetadataMap);
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 1 + this.metadataSize();
    }

    private int metadataSize() {
        int size = 1;
        for (Map.Entry<String, OAtomicOperationMetadata<?>> entry : this.atomicOperationMetadataMap.entrySet()) {
            if (entry.getKey().equals("rid")) {
                ORecordOperationMetadata recordOperationMetadata = (ORecordOperationMetadata)entry.getValue();
                size += 4;
                Object rids = recordOperationMetadata.getValue();
                size += rids.size() * 12;
                continue;
            }
            throw new IllegalStateException("Invalid metadata key rid");
        }
        return size;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public String toString() {
        return this.toString("rollback=" + this.rollback);
    }

    static {
        try {
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

