/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.types.OModifiableLong;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import java.util.concurrent.atomic.AtomicLong;

public class OOperationUnitId {
    private static final AtomicLong sharedId;
    private static volatile ThreadLocal<OModifiableLong> localId;
    private static volatile ThreadLocal<Long> sharedIdCopy;
    public static final int SERIALIZED_SIZE = 16;
    private long lId;
    private long sId;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OOperationUnitId(long lId, long sId) {
        this.lId = lId;
        this.sId = sId;
    }

    public static OOperationUnitId generateId() {
        OOperationUnitId operationUnitId = new OOperationUnitId();
        OModifiableLong lId = localId.get();
        if (lId == null) {
            lId = new OModifiableLong();
            localId.set(lId);
        }
        lId.increment();
        Long sId = sharedIdCopy.get();
        if (sId == null) {
            sId = sharedId.incrementAndGet();
            sharedIdCopy.set(sId);
        }
        operationUnitId.lId = lId.getValue();
        operationUnitId.sId = sId;
        return operationUnitId;
    }

    public OOperationUnitId() {
    }

    public int toStream(byte[] content, int offset) {
        OLongSerializer.INSTANCE.serializeNative(this.sId, content, offset, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(this.lId, content, offset += 8, new Object[0]);
        return offset += 8;
    }

    public int fromStream(byte[] content, int offset) {
        this.sId = OLongSerializer.INSTANCE.deserializeNative(content, offset);
        this.lId = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        return offset += 8;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OOperationUnitId)) {
            return false;
        }
        OOperationUnitId that = (OOperationUnitId)o;
        if (this.lId != that.lId) {
            return false;
        }
        return this.sId == that.sId;
    }

    public int hashCode() {
        int result = (int)(this.lId ^ this.lId >>> 32);
        result = 31 * result + (int)(this.sId ^ this.sId >>> 32);
        return result;
    }

    public String toString() {
        return "OOperationUnitId{lId=" + this.lId + ", sId=" + this.sId + '}';
    }

    static {
        try {
            try {
                sharedId = new AtomicLong();
                localId = new ThreadLocal();
                sharedIdCopy = new ThreadLocal();
                Orient.instance().registerListener(new OOrientListenerAbstract(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public void onStartup() {
                        if (localId == null) {
                            localId = new ThreadLocal();
                        }
                        if (sharedIdCopy == null) {
                            sharedIdCopy = new ThreadLocal();
                        }
                    }

                    @Override
                    public void onShutdown() {
                        localId = null;
                        sharedIdCopy = null;
                    }
                });
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

