/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import java.nio.ByteBuffer;

public class OWALPageV1
implements OWALPage {
    static final long MAGIC_NUMBER = 4207608830L;
    static final int RECORDS_OFFSET = 16;
    static final int MAX_ENTRY_SIZE;
    private final ByteBuffer buffer;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    OWALPageV1(ByteBuffer buffer, boolean isNew) {
        this.buffer = buffer;
        if (isNew) {
            buffer.position(4);
            buffer.putLong(4207608830L);
            buffer.putInt(MAX_ENTRY_SIZE);
        }
    }

    @Override
    public byte[] getRecord(int position) {
        this.buffer.position(position + 2);
        int recordSize = this.buffer.getInt();
        byte[] record = new byte[recordSize];
        this.buffer.get(record);
        return record;
    }

    @Override
    public boolean mergeWithNextPage(int position) {
        return this.buffer.get(position) > 0;
    }

    @Override
    public int getFreeSpace() {
        return this.buffer.getInt(12);
    }

    static int calculateSerializedSize(int recordSize) {
        return recordSize + 4 + 2;
    }

    static int calculateRecordSize(int serializedSize) {
        return serializedSize - 4 - 2;
    }

    static {
        try {
            try {
                MAX_ENTRY_SIZE = PAGE_SIZE - 16;
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

