/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileDeletedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileTruncatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ONonTxOperationPerformedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import java.util.HashMap;
import java.util.Map;

public class OWALRecordsFactory {
    private Map<Byte, Class> idToTypeMap = new HashMap<Byte, Class>();
    private Map<Class, Byte> typeToIdMap = new HashMap<Class, Byte>();
    public static final OWALRecordsFactory INSTANCE;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public byte[] toStream(OWALRecord walRecord) {
        int contentSize = walRecord.serializedSize() + 1;
        byte[] content = new byte[contentSize];
        if (walRecord instanceof OUpdatePageRecord) {
            content[0] = 0;
        } else if (walRecord instanceof OFuzzyCheckpointStartRecord) {
            content[0] = 1;
        } else if (walRecord instanceof OFuzzyCheckpointEndRecord) {
            content[0] = 2;
        } else if (walRecord instanceof OFullCheckpointStartRecord) {
            content[0] = 4;
        } else if (walRecord instanceof OCheckpointEndRecord) {
            content[0] = 5;
        } else if (walRecord instanceof OAtomicUnitStartRecord) {
            content[0] = 8;
        } else if (walRecord instanceof OAtomicUnitEndRecord) {
            content[0] = 9;
        } else if (walRecord instanceof OFileCreatedWALRecord) {
            content[0] = 10;
        } else if (walRecord instanceof ONonTxOperationPerformedWALRecord) {
            content[0] = 11;
        } else if (walRecord instanceof OFileDeletedWALRecord) {
            content[0] = 12;
        } else if (walRecord instanceof OFileTruncatedWALRecord) {
            content[0] = 13;
        } else if (this.typeToIdMap.containsKey(walRecord.getClass())) {
            content[0] = this.typeToIdMap.get(walRecord.getClass());
        } else {
            throw new IllegalArgumentException(walRecord.getClass().getName() + " class cannot be serialized.");
        }
        walRecord.toStream(content, 1);
        return content;
    }

    public OWALRecord fromStream(byte[] content) {
        OWALRecord walRecord;
        switch (content[0]) {
            case 0: {
                walRecord = new OUpdatePageRecord();
                break;
            }
            case 1: {
                walRecord = new OFuzzyCheckpointStartRecord();
                break;
            }
            case 2: {
                walRecord = new OFuzzyCheckpointEndRecord();
                break;
            }
            case 4: {
                walRecord = new OFullCheckpointStartRecord();
                break;
            }
            case 5: {
                walRecord = new OCheckpointEndRecord();
                break;
            }
            case 8: {
                walRecord = new OAtomicUnitStartRecord();
                break;
            }
            case 9: {
                walRecord = new OAtomicUnitEndRecord();
                break;
            }
            case 10: {
                walRecord = new OFileCreatedWALRecord();
                break;
            }
            case 11: {
                walRecord = new ONonTxOperationPerformedWALRecord();
                break;
            }
            case 12: {
                walRecord = new OFileDeletedWALRecord();
                break;
            }
            case 13: {
                walRecord = new OFileTruncatedWALRecord();
                break;
            }
            default: {
                if (this.idToTypeMap.containsKey(content[0])) {
                    try {
                        walRecord = (OWALRecord)this.idToTypeMap.get(content[0]).newInstance();
                        break;
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException("Cannot deserialize passed in record", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Cannot deserialize passed in record", e);
                    }
                }
                throw new IllegalStateException("Cannot deserialize passed in wal record.");
            }
        }
        walRecord.fromStream(content, 1);
        return walRecord;
    }

    public void registerNewRecord(byte id, Class<? extends OWALRecord> type) {
        this.typeToIdMap.put(type, id);
        this.idToTypeMap.put(id, type);
    }

    static {
        try {
            try {
                INSTANCE = new OWALRecordsFactory();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

