/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.statistic;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;

public class OPerformanceStatisticManagerMBean
implements DynamicMBean {
    public static final String PAGES_PER_OPERATION = "pagesPerOperation";
    public static final String CACHE_HITS = "cacheHits";
    public static final String COMPONENT_SEPARATOR = "_";
    public static final String COMMIT_TIME = "commitTime";
    public static final String READ_SPEED_FROM_CACHE = "readSpeedFromCache";
    public static final String READ_SPEED_FROM_FILE = "readSpeedFromFile";
    public static final String WRITE_SPEED_IN_CACHE = "writeSpeedInCache";
    public static final String START_MONITORING = "startMonitoring";
    public static final String STOP_MONITORING = "stopMonitoring";
    public static final String WRITE_CACHE_PAGES_PER_FLUSH = "writeCachePagesPerFlush";
    public static final String WRITE_CACHE_FLUSH_OPERATION_TIME = "writeCacheFlushOperationTime";
    public static final String WRITE_CACHE_FUZZY_CHECKPOINT_TIME = "writeCacheFuzzyCheckpointTime";
    public static final String FULL_CHECKPOINT_TIME = "fullCheckpointTime";
    public static final String FULL_CHECKPOINT_COUNT = "fullCheckpointCount";
    public static final String READ_CACHE_SIZE = "readCacheSize";
    public static final String WRITE_CACHE_SIZE = "writeCacheSize";
    public static final String EXCLUSIVE_WRITE_CACHE_SIZE = "exclusiveWriteCacheSize";
    public static final String WRITE_CACHE_OVERFLOW_COUNT = "writeCacheOverflowCount";
    public static final String WAL_SIZE = "walSize";
    public static final String WAL_CACHE_OVERFLOW_COUNT = "walCacheOverflowCount";
    public static final String WAL_LOG_TIME = "walLogTime";
    public static final String WAL_START_AO_LOG_TIME = "walStartAOLogTime";
    public static final String WAL_END_AO_LOG_TIME = "walEndAOLogTime";
    public static final String WAL_FLUSH_TIME = "walFlushTime";
    private final OPerformanceStatisticManager manager;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OPerformanceStatisticManagerMBean(OPerformanceStatisticManager manager) {
        this.manager = manager;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        String componentName;
        String attributeName;
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.getClass().getSimpleName() + " with null attribute name");
        }
        int separatorIndex = attribute.indexOf(COMPONENT_SEPARATOR);
        if (separatorIndex == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Empty attribute"), "Performance attribute name is not specified before _ for attribute " + attribute);
        }
        if (separatorIndex == attribute.length() - 1) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Empty component"), "Component name is not specified after _ for attribute " + attribute);
        }
        if (separatorIndex > -1) {
            attributeName = attribute.substring(0, separatorIndex);
            componentName = attribute.substring(separatorIndex + 1);
        } else {
            attributeName = attribute;
            componentName = null;
        }
        if (attributeName.equals(CACHE_HITS)) {
            if (componentName == null) {
                return this.manager.getCacheHits();
            }
            return this.manager.getCacheHits(componentName);
        }
        if (attributeName.equals(COMMIT_TIME)) {
            if (componentName == null) {
                return this.manager.getCommitTime();
            }
            return this.throwComponentsAreNotSupported(COMMIT_TIME);
        }
        if (attributeName.equals(READ_SPEED_FROM_CACHE)) {
            if (componentName == null) {
                return this.manager.getReadSpeedFromCacheInPages();
            }
            return this.manager.getReadSpeedFromCacheInPages(componentName);
        }
        if (attributeName.equals(READ_SPEED_FROM_FILE)) {
            if (componentName == null) {
                return this.manager.getReadSpeedFromFileInPages();
            }
            return this.manager.getReadSpeedFromFileInPages(componentName);
        }
        if (attributeName.equals(WRITE_SPEED_IN_CACHE)) {
            if (componentName == null) {
                return this.manager.getWriteSpeedInCacheInPages();
            }
            return this.manager.getWriteSpeedInCacheInPages(componentName);
        }
        if (attributeName.equals(PAGES_PER_OPERATION)) {
            if (componentName == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Unknown attribute"), "Amount of pages per operation is measured only on component level");
            }
            return this.manager.getAmountOfPagesPerOperation(componentName);
        }
        if (attributeName.equals(WRITE_CACHE_PAGES_PER_FLUSH)) {
            if (componentName == null) {
                return this.manager.getWriteCachePagesPerFlush();
            }
            this.throwComponentsAreNotSupported(WRITE_CACHE_PAGES_PER_FLUSH);
        } else if (attributeName.equals(WRITE_CACHE_FLUSH_OPERATION_TIME)) {
            if (componentName == null) {
                return this.manager.getWriteCacheFlushOperationsTime();
            }
            this.throwComponentsAreNotSupported(WRITE_CACHE_FLUSH_OPERATION_TIME);
        } else if (attributeName.equals(WRITE_CACHE_FUZZY_CHECKPOINT_TIME)) {
            if (componentName == null) {
                return this.manager.getWriteCacheFuzzyCheckpointTime();
            }
            this.throwComponentsAreNotSupported(WRITE_CACHE_FUZZY_CHECKPOINT_TIME);
        } else if (attributeName.equals(FULL_CHECKPOINT_TIME)) {
            if (componentName == null) {
                return this.manager.getFullCheckpointTime();
            }
            this.throwComponentsAreNotSupported(FULL_CHECKPOINT_TIME);
        } else if (attributeName.equals(FULL_CHECKPOINT_COUNT)) {
            if (componentName == null) {
                return this.manager.getFullCheckpointCount();
            }
            this.throwComponentsAreNotSupported(FULL_CHECKPOINT_COUNT);
        } else if (attributeName.equals(READ_CACHE_SIZE)) {
            if (componentName == null) {
                return this.manager.getReadCacheSize();
            }
            this.throwComponentsAreNotSupported(READ_CACHE_SIZE);
        } else if (attributeName.equals(WRITE_CACHE_SIZE)) {
            if (componentName == null) {
                return this.manager.getWriteCacheSize();
            }
            this.throwComponentsAreNotSupported(WRITE_CACHE_SIZE);
        } else if (attributeName.equals(EXCLUSIVE_WRITE_CACHE_SIZE)) {
            if (componentName == null) {
                return this.manager.getExclusiveWriteCacheSize();
            }
            this.throwComponentsAreNotSupported(EXCLUSIVE_WRITE_CACHE_SIZE);
        } else if (attributeName.equals(WRITE_CACHE_OVERFLOW_COUNT)) {
            if (componentName == null) {
                return this.manager.getWriteCacheOverflowCount();
            }
            this.throwComponentsAreNotSupported(WAL_CACHE_OVERFLOW_COUNT);
        } else if (attributeName.equals(WAL_SIZE)) {
            if (componentName == null) {
                return this.manager.getWALSize();
            }
            this.throwComponentsAreNotSupported(WAL_SIZE);
        } else if (attributeName.equals(WAL_CACHE_OVERFLOW_COUNT)) {
            if (componentName == null) {
                return this.manager.getWALCacheOverflowCount();
            }
            this.throwComponentsAreNotSupported(WAL_CACHE_OVERFLOW_COUNT);
        } else if (attributeName.equals(WAL_LOG_TIME)) {
            if (componentName == null) {
                return this.manager.getWALLogRecordTime();
            }
            this.throwComponentsAreNotSupported(WAL_LOG_TIME);
        } else if (attributeName.equals(WAL_START_AO_LOG_TIME)) {
            if (componentName == null) {
                return this.manager.getWALStartAOLogRecordTime();
            }
            this.throwComponentsAreNotSupported(WAL_START_AO_LOG_TIME);
        } else if (attributeName.equals(WAL_END_AO_LOG_TIME)) {
            if (componentName == null) {
                return this.manager.getWALStopAOLogRecordTime();
            }
            this.throwComponentsAreNotSupported(WAL_END_AO_LOG_TIME);
        } else if (attributeName.equals(WAL_FLUSH_TIME)) {
            if (componentName == null) {
                return this.manager.getWALFlushTime();
            }
            this.throwComponentsAreNotSupported(WAL_FLUSH_TIME);
        }
        throw new AttributeNotFoundException("Cannot find " + attribute + " attribute in " + this.getClass().getSimpleName());
    }

    private Object throwComponentsAreNotSupported(String attributeName) {
        throw new RuntimeOperationsException(new IllegalArgumentException("Components are not supported"), attributeName + " attribute is not supported on component level");
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.throwAreNotSupported();
    }

    private void throwAreNotSupported() {
        throw new RuntimeOperationsException(new UnsupportedOperationException("Modification operations are not supported"), "You can not apply modification operations to performance attributes");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + this.getClass().getSimpleName());
        }
        AttributeList resultList = new AttributeList();
        if (attributes.length == 0) {
            return resultList;
        }
        for (String attribute : attributes) {
            try {
                Object value = this.getAttribute(attribute);
                resultList.add(new Attribute(attribute, value));
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during fetching of values of attributes", e, new Object[0]);
            }
        }
        return resultList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        this.throwAreNotSupported();
        return new AttributeList();
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.getClass().getSimpleName());
        }
        if (actionName.equals(START_MONITORING)) {
            this.manager.startMonitoring();
            return null;
        }
        if (actionName.equals(STOP_MONITORING)) {
            this.manager.stopMonitoring();
            return null;
        }
        throw new ReflectionException(new NoSuchMethodException(actionName), "Cannot find the operation " + actionName + " in " + this.getClass().getSimpleName());
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> performanceAttributes = new ArrayList<MBeanAttributeInfo>();
        this.populatePerformanceAttributes(performanceAttributes);
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        MBeanOperationInfo startMonitoring = new MBeanOperationInfo(START_MONITORING, "Starts monitoring OrientDB performance characteristics", new MBeanParameterInfo[0], Void.TYPE.getName(), 1);
        operations.add(startMonitoring);
        MBeanOperationInfo stopMonitoring = new MBeanOperationInfo(STOP_MONITORING, "Stops monitoring OrientDB performance characteristics", new MBeanParameterInfo[0], Void.TYPE.getName(), 1);
        operations.add(stopMonitoring);
        return new MBeanInfo(this.getClass().getName(), "MBean to monitor OrientDB performance characteristics", performanceAttributes.toArray(new MBeanAttributeInfo[performanceAttributes.size()]), new MBeanConstructorInfo[0], operations.toArray(new MBeanOperationInfo[operations.size()]), new MBeanNotificationInfo[0]);
    }

    private void populatePerformanceAttributes(List<MBeanAttributeInfo> performanceAttributes) {
        Set<String> components = this.manager.getComponentNames();
        this.populateCacheHits(performanceAttributes, components);
        this.populateCommitTime(performanceAttributes);
        this.populateReadSpeedFromCache(performanceAttributes, components);
        this.populateReadSpeedFromFile(performanceAttributes, components);
        this.populateWriteSpeedInCache(performanceAttributes, components);
        this.populatePagesPerOperation(performanceAttributes, components);
        this.populateWriteCachePagesPerFlush(performanceAttributes);
        this.populateWriteCacheFlushOperationsTime(performanceAttributes);
        this.populateWriteCacheFuzzyCheckpointTime(performanceAttributes);
        this.populateFullCheckpointTime(performanceAttributes);
        this.populateFullCheckpointCount(performanceAttributes);
        this.populateReadCacheSize(performanceAttributes);
        this.populateWriteCacheSize(performanceAttributes);
        this.populateExclusiveWriteCacheSize(performanceAttributes);
        this.populateWriteCacheOverflowCount(performanceAttributes);
        this.populateWALSize(performanceAttributes);
        this.populateWALCacheOverflowCount(performanceAttributes);
        this.populateWALLogTime(performanceAttributes);
        this.populateWALEndAOLogTime(performanceAttributes);
        this.populateWALStartAOLogTime(performanceAttributes);
        this.populateWALFlushTime(performanceAttributes);
    }

    private void populateWriteSpeedInCache(List<MBeanAttributeInfo> performanceAttributes, Collection<String> components) {
        ModelMBeanAttributeInfo writeSpeedInCache = new ModelMBeanAttributeInfo(WRITE_SPEED_IN_CACHE, Long.TYPE.getName(), "Write speed to disk cache in pages per second", true, false, false);
        performanceAttributes.add(writeSpeedInCache);
        for (String component : components) {
            ModelMBeanAttributeInfo componentWriteSpeedInCache = new ModelMBeanAttributeInfo("writeSpeedInCache_" + component, Long.TYPE.getName(), "Write speed to disk cache in pages per second for component " + component, true, false, false);
            performanceAttributes.add(componentWriteSpeedInCache);
        }
    }

    private void populateReadSpeedFromFile(List<MBeanAttributeInfo> performanceAttributes, Collection<String> components) {
        ModelMBeanAttributeInfo readSpeedFromFile = new ModelMBeanAttributeInfo(READ_SPEED_FROM_FILE, Long.TYPE.getName(), "Read speed from file system in pages per second", true, false, false);
        performanceAttributes.add(readSpeedFromFile);
        for (String component : components) {
            ModelMBeanAttributeInfo componentReadSpeedFromFile = new ModelMBeanAttributeInfo("readSpeedFromFile_" + component, Long.TYPE.getName(), "Read speed from file system in pages per second for component " + component, true, false, false);
            performanceAttributes.add(componentReadSpeedFromFile);
        }
    }

    private void populateReadSpeedFromCache(List<MBeanAttributeInfo> performanceAttributes, Collection<String> components) {
        ModelMBeanAttributeInfo readSpeedFromCache = new ModelMBeanAttributeInfo(READ_SPEED_FROM_CACHE, Long.TYPE.getName(), "Read speed from disk cache in pages per second", true, false, false);
        performanceAttributes.add(readSpeedFromCache);
        for (String component : components) {
            ModelMBeanAttributeInfo componentReadSpeedFromCache = new ModelMBeanAttributeInfo("readSpeedFromCache_" + component, Long.TYPE.getName(), "Read speed from disk cache in pages per second for component " + component, true, false, false);
            performanceAttributes.add(componentReadSpeedFromCache);
        }
    }

    private void populateCommitTime(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo commitTime = new ModelMBeanAttributeInfo(COMMIT_TIME, Long.TYPE.getName(), "Average commit time in nanoseconds", true, false, false);
        performanceAttributes.add(commitTime);
    }

    private void populateCacheHits(List<MBeanAttributeInfo> performanceAttributes, Collection<String> components) {
        MBeanAttributeInfo cacheHits = new MBeanAttributeInfo(CACHE_HITS, Integer.TYPE.getName(), "Cache hits of read disk cache in percents", true, false, false);
        performanceAttributes.add(cacheHits);
        for (String component : components) {
            ModelMBeanAttributeInfo componentCacheHits = new ModelMBeanAttributeInfo("cacheHits_" + component, Integer.TYPE.getName(), "Cache hits of read disc cache for component " + component + " in percents", true, false, false);
            performanceAttributes.add(componentCacheHits);
        }
    }

    private void populatePagesPerOperation(List<MBeanAttributeInfo> performanceAttributes, Collection<String> components) {
        for (String component : components) {
            ModelMBeanAttributeInfo componentCacheHits = new ModelMBeanAttributeInfo("pagesPerOperation_" + component, Integer.TYPE.getName(), "Average amount of pages per operation for component " + component, true, false, false);
            performanceAttributes.add(componentCacheHits);
        }
    }

    private void populateWriteCachePagesPerFlush(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo pagesPerFlush = new ModelMBeanAttributeInfo(WRITE_CACHE_PAGES_PER_FLUSH, Long.TYPE.getName(), "Amount of pages are flushed inside of write cache flush operation", true, false, false);
        performanceAttributes.add(pagesPerFlush);
    }

    private void populateWriteCacheFlushOperationsTime(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo flushOperationsTime = new ModelMBeanAttributeInfo(WRITE_CACHE_FLUSH_OPERATION_TIME, Long.TYPE.getName(), "Time which is spent on each flush operation", true, false, false);
        performanceAttributes.add(flushOperationsTime);
    }

    private void populateWriteCacheFuzzyCheckpointTime(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo fuzzyCheckpointTime = new ModelMBeanAttributeInfo(WRITE_CACHE_FUZZY_CHECKPOINT_TIME, Long.TYPE.getName(), "Time which is spent on each fuzzy checkpoint", true, false, false);
        performanceAttributes.add(fuzzyCheckpointTime);
    }

    private void populateFullCheckpointTime(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo fullCheckpointTime = new ModelMBeanAttributeInfo(FULL_CHECKPOINT_TIME, Long.TYPE.getName(), "Time which is spent on each full checkpoint", true, false, false);
        performanceAttributes.add(fullCheckpointTime);
    }

    private void populateFullCheckpointCount(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo fullCheckpointCount = new ModelMBeanAttributeInfo(FULL_CHECKPOINT_COUNT, Long.TYPE.getName(), "Amount of times full checkpoints were executed by storage", true, false, false);
        performanceAttributes.add(fullCheckpointCount);
    }

    private void populateReadCacheSize(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo readCacheSize = new ModelMBeanAttributeInfo(READ_CACHE_SIZE, Long.TYPE.getName(), "Size of read cache in bytes", true, false, false);
        performanceAttributes.add(readCacheSize);
    }

    private void populateWriteCacheSize(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo writeCacheSize = new ModelMBeanAttributeInfo(WRITE_CACHE_SIZE, Long.TYPE.getName(), "Size of write cache in bytes", true, false, false);
        performanceAttributes.add(writeCacheSize);
    }

    private void populateExclusiveWriteCacheSize(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo exclusiveWriteCacheSize = new ModelMBeanAttributeInfo(EXCLUSIVE_WRITE_CACHE_SIZE, Long.TYPE.getName(), "Size of exclusive part of write cache in bytes", true, false, false);
        performanceAttributes.add(exclusiveWriteCacheSize);
    }

    private void populateWriteCacheOverflowCount(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo writeCacheOverflowCount = new ModelMBeanAttributeInfo(WRITE_CACHE_OVERFLOW_COUNT, Long.TYPE.getName(), "Count of times when there was not enough space in write cache to keep already written data", true, false, false);
        performanceAttributes.add(writeCacheOverflowCount);
    }

    private void populateWALSize(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo walSize = new ModelMBeanAttributeInfo(WAL_SIZE, Long.TYPE.getName(), "WAL size in bytes", true, false, false);
        performanceAttributes.add(walSize);
    }

    private void populateWALCacheOverflowCount(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo walCacheOverflowCount = new ModelMBeanAttributeInfo(WAL_CACHE_OVERFLOW_COUNT, Long.TYPE.getName(), "Count of times when there was not enough space in WAL to keep already written data", true, false, false);
        performanceAttributes.add(walCacheOverflowCount);
    }

    private void populateWALLogTime(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo walLogTime = new ModelMBeanAttributeInfo(WAL_LOG_TIME, Long.TYPE.getName(), "Time which is spent to log single record in WAL", true, false, false);
        performanceAttributes.add(walLogTime);
    }

    private void populateWALEndAOLogTime(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo walLogTime = new ModelMBeanAttributeInfo(WAL_END_AO_LOG_TIME, Long.TYPE.getName(), "Time which is spent to log record which indicates end of atomic operation in WAL", true, false, false);
        performanceAttributes.add(walLogTime);
    }

    private void populateWALStartAOLogTime(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo walLogTime = new ModelMBeanAttributeInfo(WAL_START_AO_LOG_TIME, Long.TYPE.getName(), "Time which is spent to log record which indicates start of atomic operation in WAL", true, false, false);
        performanceAttributes.add(walLogTime);
    }

    private void populateWALFlushTime(List<MBeanAttributeInfo> performanceAttributes) {
        ModelMBeanAttributeInfo walFlushTime = new ModelMBeanAttributeInfo(WAL_FLUSH_TIME, Long.TYPE.getName(), "Time which is spent on flush of WAL cache", true, false, false);
        performanceAttributes.add(walFlushTime);
    }
}

