/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.metadata.schema;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionFactory;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javassist.util.proxy.Proxy;

public class OSchemaProxyObject
implements OSchema {
    protected OSchema underlying;

    public OSchemaProxyObject(OSchema iUnderlying) {
        this.underlying = iUnderlying;
    }

    public OImmutableSchema makeSnapshot() {
        return this.underlying.makeSnapshot();
    }

    public int countClasses() {
        return this.underlying.countClasses();
    }

    public OClass createClass(Class<?> iClass) {
        return this.underlying.createClass(iClass);
    }

    public OClass createClass(String iClassName) {
        return this.underlying.createClass(iClassName);
    }

    public OClass createClass(String iClassName, OClass iSuperClass) {
        return this.underlying.createClass(iClassName, iSuperClass);
    }

    public OClass createClass(String iClassName, OClass ... superClasses) {
        return this.underlying.createClass(iClassName, superClasses);
    }

    public OClass createClass(String iClassName, OClass iSuperClass, int[] iClusterIds) {
        return this.underlying.createClass(iClassName, iSuperClass, iClusterIds);
    }

    public OClass createClass(String className, int[] clusterIds, OClass ... superClasses) {
        return this.underlying.createClass(className, clusterIds, superClasses);
    }

    public OClass createAbstractClass(Class<?> iClass) {
        return this.underlying.createAbstractClass(iClass);
    }

    public OClass createAbstractClass(String iClassName) {
        return this.underlying.createAbstractClass(iClassName);
    }

    public OClass createAbstractClass(String iClassName, OClass iSuperClass) {
        return this.underlying.createAbstractClass(iClassName, iSuperClass);
    }

    public OClass createAbstractClass(String iClassName, OClass ... superClasses) {
        return this.underlying.createAbstractClass(iClassName, superClasses);
    }

    public void dropClass(String iClassName) {
        this.underlying.dropClass(iClassName);
    }

    public <RET extends ODocumentWrapper> RET reload() {
        return (RET)this.underlying.reload();
    }

    public boolean existsClass(String iClassName) {
        return this.underlying.existsClass(iClassName);
    }

    public OClass getClass(Class<?> iClass) {
        return this.underlying.getClass(iClass);
    }

    public OClass getClass(String iClassName) {
        return this.underlying.getClass(iClassName);
    }

    public OClass getOrCreateClass(String iClassName) {
        return this.underlying.getOrCreateClass(iClassName);
    }

    public OClass getOrCreateClass(String iClassName, OClass iSuperClass) {
        return this.underlying.getOrCreateClass(iClassName, iSuperClass);
    }

    public void onPostIndexManagement() {
        this.underlying.onPostIndexManagement();
    }

    public OClass getOrCreateClass(String iClassName, OClass ... superClasses) {
        return this.underlying.getOrCreateClass(iClassName, superClasses);
    }

    public OGlobalProperty getGlobalPropertyById(int id) {
        return this.underlying.getGlobalPropertyById(id);
    }

    public Collection<OClass> getClasses() {
        return this.underlying.getClasses();
    }

    public void create() {
        this.underlying.create();
    }

    @Deprecated
    public int getVersion() {
        return this.underlying.getVersion();
    }

    public ORID getIdentity() {
        return this.underlying.getIdentity();
    }

    public <RET extends ODocumentWrapper> RET save() {
        return (RET)this.underlying.save();
    }

    public Set<OClass> getClassesRelyOnCluster(String iClusterName) {
        return this.underlying.getClassesRelyOnCluster(iClusterName);
    }

    public OClass createClass(String className, int clusters, OClass ... superClasses) {
        return this.underlying.createClass(className, clusters, superClasses);
    }

    public OSchema getUnderlying() {
        return this.underlying;
    }

    public OClass getClassByClusterId(int clusterId) {
        return this.underlying.getClassByClusterId(clusterId);
    }

    public OClusterSelectionFactory getClusterSelectionFactory() {
        return this.underlying.getClusterSelectionFactory();
    }

    public synchronized void generateSchema(String iPackageName) {
        this.generateSchema(iPackageName, Thread.currentThread().getContextClassLoader());
    }

    public synchronized void generateSchema(String iPackageName, ClassLoader iClassLoader) {
        OLogManager.instance().debug((Object)this, "Generating schema inside package: %s", new Object[]{iPackageName});
        List classes = null;
        try {
            classes = OReflectionHelper.getClassesFor((String)iPackageName, (ClassLoader)iClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw OException.wrapException((OException)new ODatabaseException("Classes cannot be loaded during schema generation"), (Throwable)e);
        }
        for (Class c : classes) {
            this.generateSchema(c);
        }
    }

    public synchronized void generateSchema(Class<?> iClass) {
        this.generateSchema(iClass, (ODatabaseDocument)ODatabaseRecordThreadLocal.instance().get());
    }

    public synchronized void generateSchema(Class<?> iClass, ODatabaseDocument database) {
        List<String> fields;
        if (iClass == null || iClass.isInterface() || iClass.isPrimitive() || iClass.isEnum() || iClass.isAnonymousClass()) {
            return;
        }
        OObjectEntitySerializer.registerClass(iClass);
        OClass schema = database.getMetadata().getSchema().getClass(iClass);
        if (schema == null) {
            OSchemaProxyObject.generateOClass(iClass, database);
        }
        if ((fields = OObjectEntitySerializer.getClassFields(iClass)) != null) {
            block6: for (String field : fields) {
                OEntityManager entityManager;
                Field f;
                if (schema.existsProperty(field) || OObjectEntitySerializer.isVersionField(iClass, field) || OObjectEntitySerializer.isIdField(iClass, field) || (f = OObjectEntitySerializer.getField(field, iClass)).getType().equals(Object.class) || f.getType().equals(ODocument.class) || OBlob.class.isAssignableFrom(f.getType())) continue;
                OType t = OObjectEntitySerializer.getTypeByClass(iClass, field, f);
                if (t == OType.CUSTOM && (entityManager = OEntityManager.getEntityManagerByDatabaseURL((String)database.getURL())).getEntityClass(f.getType().getSimpleName()) != null) {
                    t = OType.LINK;
                }
                if (t == null) {
                    t = f.getType().isEnum() ? OType.STRING : OType.LINK;
                }
                switch (t) {
                    case LINK: {
                        Class<?> linkedClazz = OObjectEntitySerializer.getSpecifiedLinkedType(f);
                        if (linkedClazz == null) {
                            linkedClazz = f.getType();
                        }
                        OSchemaProxyObject.generateLinkProperty(database, schema, field, t, linkedClazz);
                        continue block6;
                    }
                    case LINKLIST: 
                    case LINKMAP: 
                    case LINKSET: {
                        Class<?> linkedClazz = OObjectEntitySerializer.getSpecifiedMultiLinkedType(f);
                        if (linkedClazz == null) {
                            linkedClazz = OReflectionHelper.getGenericMultivalueType((Field)f);
                        }
                        if (linkedClazz == null) continue block6;
                        OSchemaProxyObject.generateLinkProperty(database, schema, field, t, linkedClazz);
                        continue block6;
                    }
                    case EMBEDDED: {
                        Class<?> linkedClazz = f.getType();
                        if (linkedClazz == null || linkedClazz.equals(Object.class) || linkedClazz.equals(ODocument.class) || OBlob.class.isAssignableFrom(f.getType())) continue block6;
                        OSchemaProxyObject.generateLinkProperty(database, schema, field, t, linkedClazz);
                        continue block6;
                    }
                    case EMBEDDEDLIST: 
                    case EMBEDDEDSET: 
                    case EMBEDDEDMAP: {
                        Class<?> linkedClazz = OReflectionHelper.getGenericMultivalueType((Field)f);
                        if (linkedClazz == null || linkedClazz.equals(Object.class) || linkedClazz.equals(ODocument.class) || OBlob.class.isAssignableFrom(f.getType())) continue block6;
                        if (OReflectionHelper.isJavaType((Class)linkedClazz)) {
                            schema.createProperty(field, t, OType.getTypeByClass((Class)linkedClazz));
                            continue block6;
                        }
                        if (linkedClazz.isEnum()) {
                            schema.createProperty(field, t, OType.STRING);
                            continue block6;
                        }
                        OSchemaProxyObject.generateLinkProperty(database, schema, field, t, linkedClazz);
                        continue block6;
                    }
                }
                schema.createProperty(field, t);
            }
        }
    }

    public synchronized void synchronizeSchema() {
        OObjectDatabaseTx database = (OObjectDatabaseTx)ODatabaseRecordThreadLocal.instance().get().getDatabaseOwner();
        Collection registeredEntities = database.getEntityManager().getRegisteredEntities();
        boolean automaticSchemaGeneration = database.isAutomaticSchemaGeneration();
        boolean reloadSchema = false;
        for (Class iClass : registeredEntities) {
            if (Proxy.class.isAssignableFrom(iClass) || iClass.isEnum() || OReflectionHelper.isJavaType((Class)iClass) || iClass.isAnonymousClass()) {
                return;
            }
            if (!database.getMetadata().getSchema().existsClass(iClass.getSimpleName())) {
                database.getMetadata().getSchema().createClass(iClass.getSimpleName());
                reloadSchema = true;
            }
            Class<Object> currentClass = iClass;
            while (currentClass != Object.class) {
                OClass oSuperClass;
                if (automaticSchemaGeneration && !currentClass.equals(Object.class) && !currentClass.equals(ODocument.class)) {
                    database.getMetadata().getSchema().generateSchema(currentClass, (ODatabaseDocument)database.getUnderlying());
                }
                String iClassName = currentClass.getSimpleName();
                if ((currentClass = currentClass.getSuperclass()) == null || currentClass.equals(ODocument.class)) {
                    currentClass = Object.class;
                }
                if (database == null || database.isClosed() || currentClass.equals(Object.class)) continue;
                OClass currentOClass = database.getMetadata().getSchema().getClass(iClassName);
                if (!database.getMetadata().getSchema().existsClass(currentClass.getSimpleName())) {
                    oSuperClass = database.getMetadata().getSchema().createClass(currentClass.getSimpleName());
                    reloadSchema = true;
                } else {
                    oSuperClass = database.getMetadata().getSchema().getClass(currentClass.getSimpleName());
                    reloadSchema = true;
                }
                if (currentOClass.getSuperClasses().contains(oSuperClass)) continue;
                currentOClass.setSuperClasses(Arrays.asList(oSuperClass));
                reloadSchema = true;
            }
        }
        if (database != null && !database.isClosed() && reloadSchema) {
            database.getMetadata().getSchema().save();
            database.getMetadata().getSchema().reload();
        }
    }

    protected static void generateOClass(Class<?> iClass, ODatabaseDocument database) {
        boolean reloadSchema = false;
        Class<Object> currentClass = iClass;
        while (currentClass != Object.class) {
            OClass oSuperClass;
            String iClassName = currentClass.getSimpleName();
            if ((currentClass = currentClass.getSuperclass()) == null || currentClass.equals(ODocument.class)) {
                currentClass = Object.class;
            }
            if (ODatabaseRecordThreadLocal.instance().get() == null || ODatabaseRecordThreadLocal.instance().get().isClosed() || currentClass.equals(Object.class)) continue;
            OClass currentOClass = database.getMetadata().getSchema().getClass(iClassName);
            if (!database.getMetadata().getSchema().existsClass(currentClass.getSimpleName())) {
                oSuperClass = database.getMetadata().getSchema().createClass(currentClass.getSimpleName());
                reloadSchema = true;
            } else {
                oSuperClass = database.getMetadata().getSchema().getClass(currentClass.getSimpleName());
                reloadSchema = true;
            }
            if (currentOClass.getSuperClasses().contains(oSuperClass)) continue;
            currentOClass.setSuperClasses(Arrays.asList(oSuperClass));
            reloadSchema = true;
        }
        if (reloadSchema) {
            database.getMetadata().getSchema().save();
            database.getMetadata().getSchema().reload();
        }
    }

    protected static void generateLinkProperty(ODatabaseDocument database, OClass schema, String field, OType t, Class<?> linkedClazz) {
        OClass linkedClass = database.getMetadata().getSchema().getClass(linkedClazz);
        if (linkedClass == null) {
            OObjectEntitySerializer.registerClass(linkedClazz);
            linkedClass = database.getMetadata().getSchema().getClass(linkedClazz);
        }
        schema.createProperty(field, t, linkedClass);
    }

    public List<OGlobalProperty> getGlobalProperties() {
        return this.underlying.getGlobalProperties();
    }

    public OGlobalProperty createGlobalProperty(String name, OType type, Integer id) {
        return this.underlying.createGlobalProperty(name, type, id);
    }
}

