/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.security.authz.permission;

import com.stormpath.sdk.lang.Strings;
import com.stormpath.spring.security.authz.permission.Permission;
import com.stormpath.spring.security.util.CollectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class WildcardPermission
implements Permission,
Serializable {
    public static final String WILDCARD_TOKEN = "*";
    public static final String PART_DIVIDER_TOKEN = ":";
    public static final String SUBPART_DIVIDER_TOKEN = ",";
    protected static final boolean DEFAULT_CASE_SENSITIVE = false;
    private List<Set<String>> parts;
    private final boolean caseSensitive;

    protected WildcardPermission() {
        this.caseSensitive = false;
    }

    public WildcardPermission(String wildcardString) {
        this(wildcardString, false);
    }

    public WildcardPermission(String wildcardString, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.setParts(wildcardString, caseSensitive);
    }

    protected void setParts(String wildcardString) {
        this.setParts(wildcardString, false);
    }

    protected void setParts(String wildcardString, boolean caseSensitive) {
        if (wildcardString == null || wildcardString.trim().length() == 0) {
            throw new IllegalArgumentException("Wildcard string cannot be null or empty. Make sure permission strings are properly formatted.");
        }
        wildcardString = wildcardString.trim();
        List<String> parts = CollectionUtils.asList(wildcardString.split(PART_DIVIDER_TOKEN));
        this.parts = new ArrayList<Set<String>>();
        for (String part : parts) {
            Set<String> subparts = CollectionUtils.asSet(part.split(SUBPART_DIVIDER_TOKEN));
            if (subparts.isEmpty()) {
                throw new IllegalArgumentException("Wildcard string cannot contain parts with only dividers. Make sure permission strings are properly formatted.");
            }
            this.parts.add(subparts);
        }
        if (this.parts.isEmpty()) {
            throw new IllegalArgumentException("Wildcard string cannot contain only dividers. Make sure permission strings are properly formatted.");
        }
    }

    private boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    protected List<Set<String>> getParts() {
        return this.parts;
    }

    public String getAuthority() {
        return this.toString();
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof WildcardPermission)) {
            return false;
        }
        WildcardPermission wp = (WildcardPermission)p;
        List<Set<String>> otherParts = wp.getParts();
        int i = 0;
        for (Set<String> otherPart : otherParts) {
            if (this.getParts().size() - 1 < i) {
                return true;
            }
            Set<String> part = this.getParts().get(i);
            if (this.isCaseSensitive() ? !this.compareCaseSensitive(part, otherPart) : !this.compareCaseInsensitive(part, otherPart)) {
                return false;
            }
            ++i;
        }
        while (i < this.getParts().size()) {
            Set<String> part = this.getParts().get(i);
            if (!part.contains(WILDCARD_TOKEN)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Set<String> part : this.getParts()) {
            if (buffer.length() > 0) {
                buffer.append(PART_DIVIDER_TOKEN);
            }
            buffer.append(Strings.collectionToDelimitedString(part, (String)SUBPART_DIVIDER_TOKEN));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof WildcardPermission) {
            WildcardPermission wp = (WildcardPermission)o;
            return this.parts.equals(wp.parts);
        }
        return false;
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    private boolean compareCaseSensitive(Set<String> part, Set<String> otherPart) {
        return part.contains(WILDCARD_TOKEN) || part.containsAll(otherPart);
    }

    private boolean compareCaseInsensitive(Set<String> part, Set<String> otherPart) {
        if (!part.contains(WILDCARD_TOKEN)) {
            boolean foundSubOtherPart = false;
            for (String subOtherPart : otherPart) {
                foundSubOtherPart = false;
                for (String subPart : part) {
                    if (!subPart.equalsIgnoreCase(subOtherPart)) continue;
                    foundSubOtherPart = true;
                    break;
                }
                if (foundSubOtherPart) continue;
                return false;
            }
            if (!foundSubOtherPart) {
                return false;
            }
        }
        return true;
    }
}

