/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.security.authz.permission.evaluator;

import com.stormpath.spring.security.authz.permission.WildcardPermission;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class WildcardPermissionEvaluator
implements PermissionEvaluator {
    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        String domainObjectString = "";
        if (targetDomainObject != null) {
            domainObjectString = targetDomainObject + ":";
        }
        WildcardPermission toMatch = new WildcardPermission(domainObjectString + permission);
        Collection authorities = authentication.getAuthorities();
        for (GrantedAuthority authority : authorities) {
            WildcardPermission wp;
            if (!(authority instanceof WildcardPermission) || !(wp = (WildcardPermission)authority).implies(toMatch)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        String targetIdString = "";
        if (targetIdString != null) {
            targetIdString = ":" + targetId;
        }
        return this.hasPermission(authentication, targetType + targetIdString, permission);
    }
}

