/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.security.cache;

import com.stormpath.sdk.lang.Assert;
import org.springframework.cache.Cache;

public class SpringCache<K, V>
implements com.stormpath.sdk.cache.Cache<K, V> {
    private final Cache SPRING_CACHE;

    public SpringCache(Cache springCache) {
        Assert.notNull((Object)springCache, (String)"Spring cache instance cannot be null.");
        this.SPRING_CACHE = springCache;
    }

    public V get(K key) {
        Cache.ValueWrapper valueWrapper = this.SPRING_CACHE.get(key);
        if (valueWrapper != null) {
            return (V)valueWrapper.get();
        }
        return null;
    }

    public V put(K key, V value) {
        V previousValue = this.get(key);
        this.SPRING_CACHE.put(key, value);
        return previousValue;
    }

    public V remove(K key) {
        V value = this.get(key);
        this.SPRING_CACHE.evict(key);
        return value;
    }
}

