/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.security.provider;

import com.stormpath.sdk.directory.CustomData;
import com.stormpath.spring.security.authz.CustomDataPermissionsEditor;
import com.stormpath.spring.security.authz.permission.Permission;
import com.stormpath.spring.security.provider.PermissionResolver;
import com.stormpath.spring.security.provider.WildcardPermissionResolver;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class CustomDataPermissionResolver {
    private String customDataFieldName = "springSecurityPermissions";
    private PermissionResolver permissionResolver = new WildcardPermissionResolver();

    public String getCustomDataFieldName() {
        return this.customDataFieldName;
    }

    public void setCustomDataFieldName(String customDataFieldName) {
        this.customDataFieldName = customDataFieldName;
    }

    public PermissionResolver getPermissionResolver() {
        return this.permissionResolver;
    }

    public void setPermissionResolver(PermissionResolver permissionResolver) {
        this.permissionResolver = permissionResolver;
    }

    protected Set<String> getPermissionStrings(CustomData customData) {
        return new CustomDataPermissionsEditor(customData).setFieldName(this.getCustomDataFieldName()).getPermissionStrings();
    }

    protected Set<Permission> getPermissions(CustomData customData) {
        Set<String> permStrings = this.getPermissionStrings(customData);
        if (CollectionUtils.isEmpty(permStrings)) {
            return Collections.emptySet();
        }
        PermissionResolver permissionResolver = this.getPermissionResolver();
        HashSet<Permission> permissions = new HashSet<Permission>(permStrings.size());
        for (String s : permStrings) {
            Permission permission = permissionResolver.resolvePermission(s);
            permissions.add(permission);
        }
        return permissions;
    }
}

