/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.security.provider;

import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.spring.security.provider.GroupGrantedAuthorityResolver;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class DefaultGroupGrantedAuthorityResolver
implements GroupGrantedAuthorityResolver {
    private Set<Mode> modes = new HashSet<Mode>();

    public DefaultGroupGrantedAuthorityResolver() {
        this.modes.add(Mode.HREF);
    }

    public Set<Mode> getModes() {
        return this.modes;
    }

    public void setModes(Set<Mode> modes) {
        if (modes == null || modes.isEmpty()) {
            throw new IllegalArgumentException("modes property cannot be null or empty.");
        }
        this.modes = modes;
    }

    @Override
    public Set<GrantedAuthority> resolveGrantedAuthorities(Group group) {
        String name;
        String instanceId;
        HashSet<GrantedAuthority> set = new HashSet<GrantedAuthority>();
        Set<Mode> modes = this.getModes();
        String groupHref = group.getHref();
        if (groupHref == null) {
            throw new IllegalStateException("Group does not have an href property.  This should never happen.");
        }
        if (modes.contains((Object)Mode.HREF)) {
            set.add((GrantedAuthority)new SimpleGrantedAuthority(groupHref));
        }
        if (modes.contains((Object)Mode.ID) && (instanceId = this.getInstanceId(groupHref)) != null) {
            set.add((GrantedAuthority)new SimpleGrantedAuthority(instanceId));
        }
        if (modes.contains((Object)Mode.NAME) && (name = group.getName()) != null) {
            set.add((GrantedAuthority)new SimpleGrantedAuthority(name));
        }
        return set;
    }

    private String getInstanceId(String href) {
        int i = href.lastIndexOf(47);
        if (i >= 0) {
            return href.substring(i + 1);
        }
        return null;
    }

    public static enum Mode {
        HREF,
        ID,
        NAME;


        public static Mode fromString(String name) {
            Assert.notNull((Object)name);
            String upper = name.toUpperCase();
            for (Mode mode : Mode.values()) {
                if (!mode.name().equals(upper)) continue;
                return mode;
            }
            throw new IllegalArgumentException("There is no Mode name '" + name + "'");
        }
    }
}

