/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.security.provider;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.UsernamePasswordRequest;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.spring.security.authz.permission.Permission;
import com.stormpath.spring.security.provider.AccountCustomDataPermissionResolver;
import com.stormpath.spring.security.provider.AccountGrantedAuthorityResolver;
import com.stormpath.spring.security.provider.AccountPermissionResolver;
import com.stormpath.spring.security.provider.AuthenticationTokenFactory;
import com.stormpath.spring.security.provider.DefaultGroupGrantedAuthorityResolver;
import com.stormpath.spring.security.provider.GroupCustomDataPermissionResolver;
import com.stormpath.spring.security.provider.GroupGrantedAuthorityResolver;
import com.stormpath.spring.security.provider.GroupPermissionResolver;
import com.stormpath.spring.security.provider.UsernamePasswordAuthenticationTokenFactory;
import com.stormpath.spring.security.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;

public class StormpathAuthenticationProvider
implements AuthenticationProvider {
    private Client client;
    private String applicationRestUrl;
    private GroupGrantedAuthorityResolver groupGrantedAuthorityResolver;
    private GroupPermissionResolver groupPermissionResolver;
    private AccountGrantedAuthorityResolver accountGrantedAuthorityResolver;
    private AccountPermissionResolver accountPermissionResolver;
    private AuthenticationTokenFactory authenticationTokenFactory;
    private Application application;

    public StormpathAuthenticationProvider() {
        this.setGroupGrantedAuthorityResolver(new DefaultGroupGrantedAuthorityResolver());
        this.setGroupPermissionResolver(new GroupCustomDataPermissionResolver());
        this.setAccountPermissionResolver(new AccountCustomDataPermissionResolver());
        this.setAuthenticationTokenFactory(new UsernamePasswordAuthenticationTokenFactory());
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public String getApplicationRestUrl() {
        return this.applicationRestUrl;
    }

    public void setApplicationRestUrl(String applicationRestUrl) {
        this.applicationRestUrl = applicationRestUrl;
    }

    public GroupGrantedAuthorityResolver getGroupGrantedAuthorityResolver() {
        return this.groupGrantedAuthorityResolver;
    }

    public void setGroupGrantedAuthorityResolver(GroupGrantedAuthorityResolver groupGrantedAuthorityResolver) {
        this.groupGrantedAuthorityResolver = groupGrantedAuthorityResolver;
    }

    public AccountGrantedAuthorityResolver getAccountGrantedAuthorityResolver() {
        return this.accountGrantedAuthorityResolver;
    }

    public void setAccountGrantedAuthorityResolver(AccountGrantedAuthorityResolver accountGrantedAuthorityResolver) {
        this.accountGrantedAuthorityResolver = accountGrantedAuthorityResolver;
    }

    public GroupPermissionResolver getGroupPermissionResolver() {
        return this.groupPermissionResolver;
    }

    public void setGroupPermissionResolver(GroupPermissionResolver groupPermissionResolver) {
        this.groupPermissionResolver = groupPermissionResolver;
    }

    public AccountPermissionResolver getAccountPermissionResolver() {
        return this.accountPermissionResolver;
    }

    public void setAccountPermissionResolver(AccountPermissionResolver accountPermissionResolver) {
        this.accountPermissionResolver = accountPermissionResolver;
    }

    public AuthenticationTokenFactory getAuthenticationTokenFactory() {
        return this.authenticationTokenFactory;
    }

    public void setAuthenticationTokenFactory(AuthenticationTokenFactory authenticationTokenFactory) {
        if (authenticationTokenFactory == null) {
            throw new IllegalArgumentException("authenticationTokenFactory cannot be null.");
        }
        this.authenticationTokenFactory = authenticationTokenFactory;
    }

    private void assertState() {
        if (this.client == null) {
            throw new IllegalStateException("Stormpath SDK Client instance must be configured.");
        }
        if (this.applicationRestUrl == null) {
            throw new IllegalStateException("\n\nThis application's Stormpath REST URL must be configured.\n\n  You may get your application's Stormpath REST URL as shown here:\n\n http://www.stormpath.com/docs/application-rest-url\n\nCopy and paste the 'REST URL' value as the 'applicationRestUrl' property of this class.");
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Account account;
        this.assertState();
        AuthenticationRequest request = this.createAuthenticationRequest(authentication);
        Application application = this.ensureApplicationReference();
        try {
            account = application.authenticateAccount(request).getAccount();
        }
        catch (ResourceException e) {
            String msg = StringUtils.clean(e.getMessage());
            if (msg == null) {
                msg = StringUtils.clean(e.getDeveloperMessage());
            }
            if (msg == null) {
                msg = "Invalid login or password.";
            }
            throw new AuthenticationServiceException(msg, (Throwable)e);
        }
        finally {
            request.clear();
        }
        Authentication authToken = this.authenticationTokenFactory.createAuthenticationToken(authentication.getPrincipal(), null, this.getGrantedAuthorities(account), account);
        return authToken;
    }

    public boolean supports(Class<?> authentication) {
        return Authentication.class.isAssignableFrom(authentication);
    }

    protected final Application ensureApplicationReference() {
        if (this.application == null) {
            String href = this.getApplicationRestUrl();
            this.application = (Application)this.client.getDataStore().getResource(href, Application.class);
        }
        return this.application;
    }

    protected AuthenticationRequest createAuthenticationRequest(Authentication authentication) {
        String username = (String)authentication.getPrincipal();
        String password = (String)authentication.getCredentials();
        return new UsernamePasswordRequest(username, password);
    }

    protected Collection<GrantedAuthority> getGrantedAuthorities(Account account) {
        HashSet<GrantedAuthority> grantedAuthorities = new HashSet<GrantedAuthority>();
        GroupList groups = account.getGroups();
        for (Group group : groups) {
            Set<GrantedAuthority> groupGrantedAuthorities = this.resolveGrantedAuthorities(group);
            grantedAuthorities.addAll(groupGrantedAuthorities);
            Set<Permission> set = this.resolvePermissions(group);
            grantedAuthorities.addAll(set);
        }
        Set<GrantedAuthority> accountGrantedAuthorities = this.resolveGrantedAuthorities(account);
        grantedAuthorities.addAll(accountGrantedAuthorities);
        Set<Permission> accountPermissions = this.resolvePermissions(account);
        for (GrantedAuthority grantedAuthority : accountPermissions) {
            grantedAuthorities.add(grantedAuthority);
        }
        return grantedAuthorities;
    }

    private Set<GrantedAuthority> resolveGrantedAuthorities(Group group) {
        if (this.groupGrantedAuthorityResolver != null) {
            return this.groupGrantedAuthorityResolver.resolveGrantedAuthorities(group);
        }
        return Collections.emptySet();
    }

    private Set<GrantedAuthority> resolveGrantedAuthorities(Account account) {
        if (this.accountGrantedAuthorityResolver != null) {
            return this.accountGrantedAuthorityResolver.resolveGrantedAuthorities(account);
        }
        return Collections.emptySet();
    }

    private Set<Permission> resolvePermissions(Group group) {
        if (this.groupPermissionResolver != null) {
            return this.groupPermissionResolver.resolvePermissions(group);
        }
        return Collections.emptySet();
    }

    private Set<Permission> resolvePermissions(Account account) {
        if (this.accountPermissionResolver != null) {
            return this.accountPermissionResolver.resolvePermissions(account);
        }
        return Collections.emptySet();
    }
}

