/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.security.provider;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.spring.security.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class StormpathUserDetails
implements UserDetails {
    private final String username;
    private final String password;
    private final Collection<? extends GrantedAuthority> authorities;
    private Map<String, String> stormpathUserDetails = null;

    public StormpathUserDetails(String username, String password, Collection<? extends GrantedAuthority> grantedAuthorities, Account account) {
        if (username == null) {
            throw new IllegalArgumentException("Username cannot be null.");
        }
        if (grantedAuthorities == null) {
            throw new IllegalArgumentException("Granted authorities cannot be null.");
        }
        if (account == null) {
            throw new IllegalArgumentException("Account cannot be null.");
        }
        this.password = password;
        this.stormpathUserDetails = this.createUnmodifiableMap(account);
        this.username = account.getUsername();
        this.authorities = grantedAuthorities;
    }

    public Map<String, String> getProperties() {
        return this.stormpathUserDetails;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return AccountStatus.ENABLED.toString().equals(this.stormpathUserDetails.get("status"));
    }

    private Map<String, String> createUnmodifiableMap(Account account) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("href", account.getHref());
        this.nullSafePut(props, "username", account.getUsername());
        this.nullSafePut(props, "email", account.getEmail());
        this.nullSafePut(props, "givenName", account.getGivenName());
        this.nullSafePut(props, "middleName", account.getMiddleName());
        this.nullSafePut(props, "surname", account.getSurname());
        if (account.getStatus() != null) {
            this.nullSafePut(props, "status", account.getStatus().toString());
        }
        return Collections.unmodifiableMap(props);
    }

    private void nullSafePut(Map<String, String> props, String propName, String value) {
        if ((value = StringUtils.clean(value)) != null) {
            props.put(propName, value);
        }
    }
}

