/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.ldap.sdk.RDN;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.args.IPAddressArgumentValueValidator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.cert.BasicConstraintsExtension;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.ExtendedKeyUsageExtension;
import com.unboundid.util.ssl.cert.ExtendedKeyUsageID;
import com.unboundid.util.ssl.cert.KeyUsageExtension;
import com.unboundid.util.ssl.cert.SubjectAlternativeNameExtension;
import com.unboundid.util.ssl.cert.X509Certificate;
import com.unboundid.util.ssl.cert.X509CertificateExtension;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

final class PromptTrustManagerProcessor {
    private PromptTrustManagerProcessor() {
    }

    static ObjectPair<Boolean, List<String>> shouldPrompt(String cacheKey, X509Certificate[] chain, boolean isServerChain, boolean examineValidityDates, Map<String, Boolean> acceptedCertificates, List<String> expectedServerAddresses) {
        Boolean acceptedEvenWithBadValidity;
        boolean outsideValidityWindow = false;
        ArrayList<String> warningMessages = new ArrayList<String>(5);
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < chain.length; ++i) {
            if (chain[i].isWithinValidityWindow(currentTime)) continue;
            outsideValidityWindow = true;
            String identifier = i == 0 ? (isServerChain ? SSLMessages.WARN_PROMPT_PROCESSOR_LABEL_SERVER.get() : SSLMessages.WARN_PROMPT_PROCESSOR_LABEL_CLIENT.get()) : SSLMessages.WARN_PROMPT_PROCESSOR_LABEL_ISSUER.get();
            if (currentTime > chain[i].getNotAfterTime()) {
                long expiredSecondsAgo = Math.round((double)(currentTime - chain[i].getNotAfterTime()) / 1000.0);
                warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_CERT_EXPIRED.get(identifier, PromptTrustManagerProcessor.formatDate(chain[i].getNotAfterDate()), StaticUtils.secondsToHumanReadableDuration(expiredSecondsAgo)));
                continue;
            }
            long secondsUntilValid = Math.round((double)(chain[i].getNotBeforeTime() - currentTime) / 1000.0);
            warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_CERT_NOT_YET_VALID.get(identifier, PromptTrustManagerProcessor.formatDate(chain[i].getNotBeforeDate()), StaticUtils.secondsToHumanReadableDuration(secondsUntilValid)));
        }
        SubjectAlternativeNameExtension san = null;
        for (X509CertificateExtension extension : chain[0].getExtensions()) {
            if (extension instanceof ExtendedKeyUsageExtension) {
                ExtendedKeyUsageExtension eku = (ExtendedKeyUsageExtension)extension;
                if (isServerChain) {
                    if (eku.getKeyPurposeIDs().contains(ExtendedKeyUsageID.TLS_SERVER_AUTHENTICATION.getOID())) continue;
                    warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_EKU_MISSING_SERVER_AUTH.get(chain[0].getSubjectDN()));
                    continue;
                }
                if (eku.getKeyPurposeIDs().contains(ExtendedKeyUsageID.TLS_CLIENT_AUTHENTICATION.getOID())) continue;
                warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_EKU_MISSING_CLIENT_AUTH.get(chain[0].getSubjectDN()));
                continue;
            }
            if (!(extension instanceof SubjectAlternativeNameExtension)) continue;
            san = (SubjectAlternativeNameExtension)extension;
        }
        if (chain.length == 1) {
            if (chain[0].isSelfSigned()) {
                warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_CERT_IS_SELF_SIGNED.get());
                try {
                    chain[0].verifySignature(chain[0]);
                }
                catch (CertException ce) {
                    Debug.debugException(ce);
                    warningMessages.add(ce.getMessage());
                }
            } else {
                warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_CHAIN_NOT_COMPLETE.get(chain[0].getSubjectDN()));
            }
        } else {
            for (int i = 1; i < chain.length; ++i) {
                if (chain[i].isIssuerFor(chain[i - 1])) {
                    try {
                        chain[i - 1].verifySignature(chain[i]);
                    }
                    catch (CertException ce) {
                        Debug.debugException(ce);
                        warningMessages.add(ce.getMessage());
                    }
                } else {
                    warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_CHAIN_ISSUER_MISMATCH.get(chain[i].getSubjectDN(), chain[i - 1].getSubjectDN()));
                }
                BasicConstraintsExtension bc = null;
                KeyUsageExtension ku = null;
                for (X509CertificateExtension extension : chain[i].getExtensions()) {
                    if (extension instanceof BasicConstraintsExtension) {
                        bc = (BasicConstraintsExtension)extension;
                        continue;
                    }
                    if (!(extension instanceof KeyUsageExtension)) continue;
                    ku = (KeyUsageExtension)extension;
                }
                if (bc == null) {
                    warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_NO_BC_EXTENSION.get(chain[i].getSubjectDN()));
                } else if (!bc.isCA()) {
                    warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_BC_NOT_CA.get(chain[i].getSubjectDN()));
                } else if (bc.getPathLengthConstraint() != null && bc.getPathLengthConstraint() < chain.length) {
                    warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_BC_PATH_LENGTH_EXCEEDED.get(chain[i].getSubjectDN(), bc.getPathLengthConstraint(), chain.length));
                }
                if (ku == null || ku.isKeyCertSignBitSet()) continue;
                warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_KU_NO_KEY_CERT_SIGN.get(chain[i].getSubjectDN()));
            }
            if (chain[chain.length - 1].isSelfSigned()) {
                try {
                    chain[chain.length - 1].verifySignature(chain[chain.length - 1]);
                }
                catch (CertException ce) {
                    Debug.debugException(ce);
                    warningMessages.add(ce.getMessage());
                }
            } else {
                warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_CHAIN_NOT_COMPLETE.get(chain[chain.length - 1].getSubjectDN()));
            }
        }
        if (isServerChain && expectedServerAddresses != null && !expectedServerAddresses.isEmpty()) {
            boolean hasAllowedAddress = false;
            StringBuilder addressBuffer = new StringBuilder();
            for (RDN rdn : chain[0].getSubjectDN().getRDNs()) {
                String[] names = rdn.getAttributeNames();
                for (int i = 0; i < names.length; ++i) {
                    String cnValue;
                    String lowerCNValue;
                    if (!names[i].equalsIgnoreCase("cn") && !names[i].equalsIgnoreCase("commonName") && !names[i].equalsIgnoreCase("2.5.4.3") || !PromptTrustManagerProcessor.isHostnameOrIPAddress(lowerCNValue = StaticUtils.toLowerCase(cnValue = rdn.getAttributeValues()[i]))) continue;
                    PromptTrustManagerProcessor.commaAppend(addressBuffer, cnValue);
                    if (!PromptTrustManagerProcessor.isAllowedHostnameOrIPAddress(lowerCNValue, expectedServerAddresses)) continue;
                    hasAllowedAddress = true;
                    break;
                }
                if (hasAllowedAddress) break;
            }
            if (!hasAllowedAddress && san != null) {
                for (String dnsName : san.getDNSNames()) {
                    PromptTrustManagerProcessor.commaAppend(addressBuffer, dnsName);
                    if (!PromptTrustManagerProcessor.isAllowedHostnameOrIPAddress(dnsName, expectedServerAddresses)) continue;
                    hasAllowedAddress = true;
                    break;
                }
                if (!hasAllowedAddress) {
                    for (InetAddress ipAddress : san.getIPAddresses()) {
                        PromptTrustManagerProcessor.commaAppend(addressBuffer, ipAddress.getHostAddress());
                        if (!PromptTrustManagerProcessor.isAllowedIPAddress(ipAddress, expectedServerAddresses)) continue;
                        hasAllowedAddress = true;
                        break;
                    }
                }
            }
            if (!hasAllowedAddress && addressBuffer.length() != 0) {
                if (addressBuffer.indexOf(",") > 0) {
                    warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_MULTIPLE_ADDRESSES_NOT_MATCHED.get(chain[0].getSubjectDN(), addressBuffer));
                } else {
                    warningMessages.add(SSLMessages.WARN_PROMPT_PROCESSOR_SINGLE_ADDRESS_NOT_MATCHED.get(chain[0].getSubjectDN(), addressBuffer));
                }
            }
        }
        if ((acceptedEvenWithBadValidity = acceptedCertificates.get(cacheKey)) == null) {
            return new ObjectPair<Boolean, List<String>>(Boolean.TRUE, warningMessages);
        }
        if (acceptedEvenWithBadValidity.booleanValue()) {
            return new ObjectPair<Boolean, List<String>>(Boolean.FALSE, warningMessages);
        }
        return new ObjectPair<Boolean, List<String>>(outsideValidityWindow, warningMessages);
    }

    static String formatDate(Date d) {
        String dateFormatString = "EEEE, MMMM d, yyyy";
        String formattedDate = new SimpleDateFormat("EEEE, MMMM d, yyyy").format(d);
        String timeFormatString = "hh:mm:ss aa z";
        String formattedTime = new SimpleDateFormat("hh:mm:ss aa z").format(d);
        return SSLMessages.WARN_PROMPT_PROCESSOR_DATE_TIME.get(formattedDate, formattedTime);
    }

    static boolean isHostnameOrIPAddress(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (IPAddressArgumentValueValidator.isValidNumericIPAddress(s)) {
            return true;
        }
        boolean lastWasPeriod = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z') {
                lastWasPeriod = false;
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (i == 0 || lastWasPeriod) {
                    return false;
                }
                lastWasPeriod = false;
                continue;
            }
            if (c == '.') {
                if (i == 0 || lastWasPeriod) {
                    return false;
                }
                lastWasPeriod = true;
                continue;
            }
            if (c != '*') continue;
            if (i > 0) {
                return false;
            }
            if (s.length() == 1 || s.charAt(1) != '.') {
                return false;
            }
            lastWasPeriod = false;
        }
        return !lastWasPeriod;
    }

    static boolean isAllowedHostnameOrIPAddress(String s, List<String> expectedAddresses) {
        if (IPAddressArgumentValueValidator.isValidNumericIPAddress(s)) {
            try {
                InetAddress ip = InetAddress.getByName(s);
                for (String expectedAddress : expectedAddresses) {
                    if (!IPAddressArgumentValueValidator.isValidNumericIPAddress(expectedAddress) || !ip.equals(InetAddress.getByName(expectedAddress))) continue;
                    return true;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        for (String expectedAddress : expectedAddresses) {
            String endOfExpectedAddress;
            String endOfS;
            int periodPos;
            if (s.equalsIgnoreCase(expectedAddress)) {
                return true;
            }
            if (!s.startsWith("*.") || (periodPos = expectedAddress.indexOf(46)) <= 0 || !(endOfS = s.substring(2)).equalsIgnoreCase(endOfExpectedAddress = expectedAddress.substring(periodPos + 1))) continue;
            return true;
        }
        return false;
    }

    static boolean isAllowedIPAddress(InetAddress a, List<String> expectedAddresses) {
        for (String s : expectedAddresses) {
            try {
                if (!IPAddressArgumentValueValidator.isValidNumericIPAddress(s) || !a.equals(InetAddress.getByName(s))) continue;
                return true;
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return false;
    }

    private static void commaAppend(StringBuilder b, String s) {
        if (b.length() > 0) {
            b.append(", ");
        }
        b.append(s);
    }
}

