/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser;

import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.parser.MutableListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSetter;
import java.util.Arrays;

public class ListOptions
implements MutableDataSetter {
    protected ParserEmulationProfile myParserEmulationProfile;
    protected ItemInterrupt itemInterrupt;
    protected boolean autoLoose;
    protected boolean autoLooseOneLevelLists;
    protected boolean delimiterMismatchToNewList;
    protected boolean endOnDoubleBlank;
    protected boolean itemMarkerSpace;
    protected boolean itemTypeMismatchToNewList;
    protected boolean itemTypeMismatchToSubList;
    protected boolean looseWhenPrevHasTrailingBlankLine;
    protected boolean looseWhenLastItemPrevHasTrailingBlankLine;
    protected boolean looseWhenHasNonListChildren;
    protected boolean looseWhenBlankLineFollowsItemParagraph;
    protected boolean looseWhenHasLooseSubItem;
    protected boolean looseWhenHasTrailingBlankLine;
    protected boolean looseWhenContainsBlankLine;
    protected boolean numberedItemMarkerSuffixed;
    protected boolean orderedItemDotOnly;
    protected boolean orderedListManualStart;
    protected boolean itemContentAfterSuffix;
    protected String itemPrefixChars;
    protected int codeIndent;
    protected int itemIndent;
    protected int newItemCodeIndent;
    protected String[] itemMarkerSuffixes;

    public ListOptions() {
        this((DataHolder)null);
    }

    private ListOptions(DataHolder options) {
        this.myParserEmulationProfile = (ParserEmulationProfile)((Object)Parser.PARSER_EMULATION_PROFILE.getFrom(options));
        this.itemInterrupt = new ItemInterrupt(options);
        this.autoLoose = (Boolean)Parser.LISTS_AUTO_LOOSE.getFrom(options);
        this.autoLooseOneLevelLists = (Boolean)Parser.LISTS_AUTO_LOOSE_ONE_LEVEL_LISTS.getFrom(options);
        this.delimiterMismatchToNewList = (Boolean)Parser.LISTS_DELIMITER_MISMATCH_TO_NEW_LIST.getFrom(options);
        this.endOnDoubleBlank = (Boolean)Parser.LISTS_END_ON_DOUBLE_BLANK.getFrom(options);
        this.itemMarkerSpace = (Boolean)Parser.LISTS_ITEM_MARKER_SPACE.getFrom(options);
        this.itemTypeMismatchToNewList = (Boolean)Parser.LISTS_ITEM_TYPE_MISMATCH_TO_NEW_LIST.getFrom(options);
        this.itemTypeMismatchToSubList = (Boolean)Parser.LISTS_ITEM_TYPE_MISMATCH_TO_SUB_LIST.getFrom(options);
        this.looseWhenPrevHasTrailingBlankLine = (Boolean)Parser.LISTS_LOOSE_WHEN_PREV_HAS_TRAILING_BLANK_LINE.getFrom(options);
        this.looseWhenLastItemPrevHasTrailingBlankLine = (Boolean)Parser.LISTS_LOOSE_WHEN_LAST_ITEM_PREV_HAS_TRAILING_BLANK_LINE.getFrom(options);
        this.looseWhenHasNonListChildren = (Boolean)Parser.LISTS_LOOSE_WHEN_HAS_NON_LIST_CHILDREN.getFrom(options);
        this.looseWhenBlankLineFollowsItemParagraph = (Boolean)Parser.LISTS_LOOSE_WHEN_BLANK_LINE_FOLLOWS_ITEM_PARAGRAPH.getFrom(options);
        this.looseWhenHasLooseSubItem = (Boolean)Parser.LISTS_LOOSE_WHEN_HAS_LOOSE_SUB_ITEM.getFrom(options);
        this.looseWhenHasTrailingBlankLine = (Boolean)Parser.LISTS_LOOSE_WHEN_HAS_TRAILING_BLANK_LINE.getFrom(options);
        this.looseWhenContainsBlankLine = (Boolean)Parser.LISTS_LOOSE_WHEN_CONTAINS_BLANK_LINE.getFrom(options);
        this.numberedItemMarkerSuffixed = (Boolean)Parser.LISTS_NUMBERED_ITEM_MARKER_SUFFIXED.getFrom(options);
        this.orderedItemDotOnly = (Boolean)Parser.LISTS_ORDERED_ITEM_DOT_ONLY.getFrom(options);
        this.orderedListManualStart = (Boolean)Parser.LISTS_ORDERED_LIST_MANUAL_START.getFrom(options);
        this.itemContentAfterSuffix = (Boolean)Parser.LISTS_ITEM_CONTENT_AFTER_SUFFIX.getFrom(options);
        this.itemPrefixChars = (String)Parser.LISTS_ITEM_PREFIX_CHARS.getFrom(options);
        this.codeIndent = (Integer)Parser.LISTS_CODE_INDENT.getFrom(options);
        this.itemIndent = (Integer)Parser.LISTS_ITEM_INDENT.getFrom(options);
        this.newItemCodeIndent = (Integer)Parser.LISTS_NEW_ITEM_CODE_INDENT.getFrom(options);
        this.itemMarkerSuffixes = (String[])Parser.LISTS_ITEM_MARKER_SUFFIXES.getFrom(options);
    }

    ListOptions(ListOptions other) {
        this.myParserEmulationProfile = other.getParserEmulationProfile();
        this.itemInterrupt = new ItemInterrupt(other.getItemInterrupt());
        this.autoLoose = other.isAutoLoose();
        this.autoLooseOneLevelLists = other.isAutoLooseOneLevelLists();
        this.delimiterMismatchToNewList = other.isDelimiterMismatchToNewList();
        this.endOnDoubleBlank = other.isEndOnDoubleBlank();
        this.itemMarkerSpace = other.isItemMarkerSpace();
        this.itemTypeMismatchToNewList = other.isItemTypeMismatchToNewList();
        this.itemTypeMismatchToSubList = other.isItemTypeMismatchToSubList();
        this.looseWhenPrevHasTrailingBlankLine = other.isLooseWhenPrevHasTrailingBlankLine();
        this.looseWhenLastItemPrevHasTrailingBlankLine = other.isLooseWhenLastItemPrevHasTrailingBlankLine();
        this.looseWhenHasNonListChildren = other.isLooseWhenHasNonListChildren();
        this.looseWhenBlankLineFollowsItemParagraph = other.isLooseWhenBlankLineFollowsItemParagraph();
        this.looseWhenHasLooseSubItem = other.isLooseWhenHasLooseSubItem();
        this.looseWhenHasTrailingBlankLine = other.isLooseWhenHasTrailingBlankLine();
        this.looseWhenContainsBlankLine = other.isLooseWhenContainsBlankLine();
        this.numberedItemMarkerSuffixed = other.isNumberedItemMarkerSuffixed();
        this.orderedItemDotOnly = other.isOrderedItemDotOnly();
        this.orderedListManualStart = other.isOrderedListManualStart();
        this.itemContentAfterSuffix = other.isItemContentAfterSuffix();
        this.itemPrefixChars = other.getItemPrefixChars();
        this.codeIndent = other.getCodeIndent();
        this.itemIndent = other.getItemIndent();
        this.newItemCodeIndent = other.getNewItemCodeIndent();
        this.itemMarkerSuffixes = other.getItemMarkerSuffixes();
    }

    public static ListOptions getFrom(DataHolder options) {
        return new ListOptions(options);
    }

    public static ListOptions getNew(DataHolder options) {
        return new ListOptions(options);
    }

    public boolean isTightListItem(ListItem node) {
        if (node.isLoose()) {
            return false;
        }
        boolean autoLoose = this.isAutoLoose();
        if (autoLoose && this.isAutoLooseOneLevelLists()) {
            boolean singleLevel = node.getAncestorOfType(new Class[]{ListItem.class}) == null && node.getChildOfType(new Class[]{ListBlock.class}) == null;
            return node.getFirstChild() == null || !singleLevel && node.isTight() || singleLevel && node.isInTightList();
        }
        return node.getFirstChild() == null || !autoLoose && node.isTight() || autoLoose && node.isInTightList();
    }

    public boolean isInTightListItem(Paragraph node) {
        Block parent = node.getParent();
        if (!(parent instanceof ListItem)) {
            return false;
        }
        ListItem listItem = (ListItem)parent;
        if (!listItem.isItemParagraph(node)) {
            return false;
        }
        boolean autoLoose = this.isAutoLoose();
        if (autoLoose && this.isAutoLooseOneLevelLists()) {
            return this.isTightListItem(listItem);
        }
        return !autoLoose && listItem.isParagraphInTightListItem(node) || autoLoose && listItem.isInTightList();
    }

    public boolean canInterrupt(ListBlock a, boolean isEmptyItem, boolean isItemParagraph) {
        boolean isNumberedItem = a instanceof OrderedList;
        boolean isOneItem = isNumberedItem && (!this.isOrderedListManualStart() || ((OrderedList)a).getStartNumber() == 1);
        return this.getItemInterrupt().canInterrupt(isNumberedItem, isOneItem, isEmptyItem, isItemParagraph);
    }

    public boolean canStartSubList(ListBlock a, boolean isEmptyItem) {
        boolean isNumberedItem = a instanceof OrderedList;
        boolean isOneItem = isNumberedItem && (!this.isOrderedListManualStart() || ((OrderedList)a).getStartNumber() == 1);
        return this.getItemInterrupt().canStartSubList(isNumberedItem, isOneItem, isEmptyItem);
    }

    public boolean startNewList(ListBlock a, ListBlock b) {
        boolean isNumberedList = a instanceof OrderedList;
        boolean isNumberedItem = b instanceof OrderedList;
        if (isNumberedList == isNumberedItem) {
            if (isNumberedList) {
                return this.isDelimiterMismatchToNewList() && ((OrderedList)a).getDelimiter() != ((OrderedList)b).getDelimiter();
            }
            return this.isDelimiterMismatchToNewList() && ((BulletList)a).getOpeningMarker() != ((BulletList)b).getOpeningMarker();
        }
        return this.isItemTypeMismatchToNewList();
    }

    public boolean startSubList(ListBlock a, ListBlock b) {
        boolean isNumberedList = a instanceof OrderedList;
        boolean isNumberedItem = b instanceof OrderedList;
        return isNumberedList != isNumberedItem && this.isItemTypeMismatchToSubList();
    }

    public MutableListOptions getMutable() {
        return new MutableListOptions(this);
    }

    public MutableDataHolder setIn(MutableDataHolder options) {
        options.set(Parser.PARSER_EMULATION_PROFILE, (Object)this.getParserEmulationProfile());
        this.getItemInterrupt().setIn(options);
        options.set(Parser.LISTS_AUTO_LOOSE, (Object)this.autoLoose);
        options.set(Parser.LISTS_AUTO_LOOSE_ONE_LEVEL_LISTS, (Object)this.autoLooseOneLevelLists);
        options.set(Parser.LISTS_DELIMITER_MISMATCH_TO_NEW_LIST, (Object)this.delimiterMismatchToNewList);
        options.set(Parser.LISTS_END_ON_DOUBLE_BLANK, (Object)this.endOnDoubleBlank);
        options.set(Parser.LISTS_ITEM_MARKER_SPACE, (Object)this.itemMarkerSpace);
        options.set(Parser.LISTS_ITEM_TYPE_MISMATCH_TO_NEW_LIST, (Object)this.itemTypeMismatchToNewList);
        options.set(Parser.LISTS_ITEM_TYPE_MISMATCH_TO_SUB_LIST, (Object)this.itemTypeMismatchToSubList);
        options.set(Parser.LISTS_LOOSE_WHEN_PREV_HAS_TRAILING_BLANK_LINE, (Object)this.looseWhenPrevHasTrailingBlankLine);
        options.set(Parser.LISTS_LOOSE_WHEN_LAST_ITEM_PREV_HAS_TRAILING_BLANK_LINE, (Object)this.looseWhenLastItemPrevHasTrailingBlankLine);
        options.set(Parser.LISTS_LOOSE_WHEN_HAS_NON_LIST_CHILDREN, (Object)this.looseWhenHasNonListChildren);
        options.set(Parser.LISTS_LOOSE_WHEN_BLANK_LINE_FOLLOWS_ITEM_PARAGRAPH, (Object)this.looseWhenBlankLineFollowsItemParagraph);
        options.set(Parser.LISTS_LOOSE_WHEN_HAS_LOOSE_SUB_ITEM, (Object)this.looseWhenHasLooseSubItem);
        options.set(Parser.LISTS_LOOSE_WHEN_HAS_TRAILING_BLANK_LINE, (Object)this.looseWhenHasTrailingBlankLine);
        options.set(Parser.LISTS_LOOSE_WHEN_CONTAINS_BLANK_LINE, (Object)this.looseWhenContainsBlankLine);
        options.set(Parser.LISTS_NUMBERED_ITEM_MARKER_SUFFIXED, (Object)this.numberedItemMarkerSuffixed);
        options.set(Parser.LISTS_ORDERED_ITEM_DOT_ONLY, (Object)this.orderedItemDotOnly);
        options.set(Parser.LISTS_ORDERED_LIST_MANUAL_START, (Object)this.orderedListManualStart);
        options.set(Parser.LISTS_CODE_INDENT, (Object)this.codeIndent);
        options.set(Parser.LISTS_ITEM_INDENT, (Object)this.itemIndent);
        options.set(Parser.LISTS_NEW_ITEM_CODE_INDENT, (Object)this.newItemCodeIndent);
        options.set(Parser.LISTS_ITEM_MARKER_SUFFIXES, (Object)this.itemMarkerSuffixes);
        options.set(Parser.LISTS_ITEM_CONTENT_AFTER_SUFFIX, (Object)this.itemContentAfterSuffix);
        options.set(Parser.LISTS_ITEM_PREFIX_CHARS, (Object)this.itemPrefixChars);
        return options;
    }

    public static void addItemMarkerSuffixes(MutableDataHolder options, String ... itemMarkerSuffixes) {
        String[] suffixes = (String[])Parser.LISTS_ITEM_MARKER_SUFFIXES.getFrom((DataHolder)options);
        int addSuffixCount = itemMarkerSuffixes.length;
        int iMax = itemMarkerSuffixes.length;
        for (String suffix : suffixes) {
            for (int i = 0; i < iMax; ++i) {
                String addSuffix = itemMarkerSuffixes[i];
                if (addSuffix == null || !addSuffix.equals(suffix)) continue;
                --addSuffixCount;
                itemMarkerSuffixes[i] = null;
                break;
            }
            if (addSuffixCount == 0) break;
        }
        if (addSuffixCount > 0) {
            String[] newSuffixes = new String[suffixes.length + addSuffixCount];
            System.arraycopy(suffixes, 0, newSuffixes, 0, suffixes.length);
            int suffixIndex = suffixes.length;
            for (String addSuffix : itemMarkerSuffixes) {
                if (addSuffix == null) continue;
                newSuffixes[suffixIndex++] = addSuffix;
            }
            options.set(Parser.LISTS_ITEM_MARKER_SUFFIXES, (Object)newSuffixes);
        }
    }

    public ParserEmulationProfile getParserEmulationProfile() {
        return this.myParserEmulationProfile;
    }

    public ItemInterrupt getItemInterrupt() {
        return this.itemInterrupt;
    }

    public boolean isAutoLoose() {
        return this.autoLoose;
    }

    public boolean isAutoLooseOneLevelLists() {
        return this.autoLooseOneLevelLists;
    }

    public boolean isDelimiterMismatchToNewList() {
        return this.delimiterMismatchToNewList;
    }

    public boolean isEndOnDoubleBlank() {
        return this.endOnDoubleBlank;
    }

    public boolean isItemMarkerSpace() {
        return this.itemMarkerSpace;
    }

    public boolean isItemTypeMismatchToNewList() {
        return this.itemTypeMismatchToNewList;
    }

    public boolean isItemContentAfterSuffix() {
        return this.itemContentAfterSuffix;
    }

    public String getItemPrefixChars() {
        return this.itemPrefixChars;
    }

    public boolean isItemTypeMismatchToSubList() {
        return this.itemTypeMismatchToSubList;
    }

    public boolean isLooseWhenPrevHasTrailingBlankLine() {
        return this.looseWhenPrevHasTrailingBlankLine;
    }

    public boolean isLooseWhenLastItemPrevHasTrailingBlankLine() {
        return this.looseWhenLastItemPrevHasTrailingBlankLine;
    }

    public boolean isLooseWhenHasNonListChildren() {
        return this.looseWhenHasNonListChildren;
    }

    public boolean isLooseWhenHasLooseSubItem() {
        return this.looseWhenHasLooseSubItem;
    }

    public boolean isLooseWhenHasTrailingBlankLine() {
        return this.looseWhenHasTrailingBlankLine;
    }

    public boolean isLooseWhenContainsBlankLine() {
        return this.looseWhenContainsBlankLine;
    }

    public boolean isLooseWhenBlankLineFollowsItemParagraph() {
        return this.looseWhenBlankLineFollowsItemParagraph;
    }

    public boolean isOrderedItemDotOnly() {
        return this.orderedItemDotOnly;
    }

    public boolean isOrderedListManualStart() {
        return this.orderedListManualStart;
    }

    public boolean isNumberedItemMarkerSuffixed() {
        return this.numberedItemMarkerSuffixed;
    }

    public int getCodeIndent() {
        return this.codeIndent;
    }

    public int getItemIndent() {
        return this.itemIndent;
    }

    public int getNewItemCodeIndent() {
        return this.newItemCodeIndent;
    }

    public String[] getItemMarkerSuffixes() {
        return this.itemMarkerSuffixes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListOptions)) {
            return false;
        }
        ListOptions that = (ListOptions)o;
        if (this.myParserEmulationProfile != that.myParserEmulationProfile) {
            return false;
        }
        if (this.autoLoose != that.autoLoose) {
            return false;
        }
        if (this.autoLooseOneLevelLists != that.autoLooseOneLevelLists) {
            return false;
        }
        if (this.delimiterMismatchToNewList != that.delimiterMismatchToNewList) {
            return false;
        }
        if (this.endOnDoubleBlank != that.endOnDoubleBlank) {
            return false;
        }
        if (this.itemMarkerSpace != that.itemMarkerSpace) {
            return false;
        }
        if (this.itemTypeMismatchToNewList != that.itemTypeMismatchToNewList) {
            return false;
        }
        if (this.itemTypeMismatchToSubList != that.itemTypeMismatchToSubList) {
            return false;
        }
        if (this.looseWhenPrevHasTrailingBlankLine != that.looseWhenPrevHasTrailingBlankLine) {
            return false;
        }
        if (this.looseWhenLastItemPrevHasTrailingBlankLine != that.looseWhenLastItemPrevHasTrailingBlankLine) {
            return false;
        }
        if (this.looseWhenHasNonListChildren != that.looseWhenHasNonListChildren) {
            return false;
        }
        if (this.looseWhenBlankLineFollowsItemParagraph != that.looseWhenBlankLineFollowsItemParagraph) {
            return false;
        }
        if (this.looseWhenHasLooseSubItem != that.looseWhenHasLooseSubItem) {
            return false;
        }
        if (this.looseWhenHasTrailingBlankLine != that.looseWhenHasTrailingBlankLine) {
            return false;
        }
        if (this.looseWhenContainsBlankLine != that.looseWhenContainsBlankLine) {
            return false;
        }
        if (this.numberedItemMarkerSuffixed != that.numberedItemMarkerSuffixed) {
            return false;
        }
        if (this.orderedItemDotOnly != that.orderedItemDotOnly) {
            return false;
        }
        if (this.orderedListManualStart != that.orderedListManualStart) {
            return false;
        }
        if (this.codeIndent != that.codeIndent) {
            return false;
        }
        if (this.itemIndent != that.itemIndent) {
            return false;
        }
        if (this.newItemCodeIndent != that.newItemCodeIndent) {
            return false;
        }
        if (this.itemMarkerSuffixes != that.itemMarkerSuffixes) {
            return false;
        }
        if (this.itemContentAfterSuffix != that.itemContentAfterSuffix) {
            return false;
        }
        if (this.itemPrefixChars != that.itemPrefixChars) {
            return false;
        }
        return this.itemInterrupt.equals(that.itemInterrupt);
    }

    public int hashCode() {
        int result = this.myParserEmulationProfile.hashCode();
        result = 31 * result + this.itemInterrupt.hashCode();
        result = 31 * result + (this.autoLoose ? 1 : 0);
        result = 31 * result + (this.autoLooseOneLevelLists ? 1 : 0);
        result = 31 * result + (this.delimiterMismatchToNewList ? 1 : 0);
        result = 31 * result + (this.endOnDoubleBlank ? 1 : 0);
        result = 31 * result + (this.itemMarkerSpace ? 1 : 0);
        result = 31 * result + (this.itemTypeMismatchToNewList ? 1 : 0);
        result = 31 * result + (this.itemTypeMismatchToSubList ? 1 : 0);
        result = 31 * result + (this.looseWhenPrevHasTrailingBlankLine ? 1 : 0);
        result = 31 * result + (this.looseWhenLastItemPrevHasTrailingBlankLine ? 1 : 0);
        result = 31 * result + (this.looseWhenHasNonListChildren ? 1 : 0);
        result = 31 * result + (this.looseWhenBlankLineFollowsItemParagraph ? 1 : 0);
        result = 31 * result + (this.looseWhenHasLooseSubItem ? 1 : 0);
        result = 31 * result + (this.looseWhenHasTrailingBlankLine ? 1 : 0);
        result = 31 * result + (this.looseWhenContainsBlankLine ? 1 : 0);
        result = 31 * result + (this.numberedItemMarkerSuffixed ? 1 : 0);
        result = 31 * result + (this.orderedItemDotOnly ? 1 : 0);
        result = 31 * result + (this.orderedListManualStart ? 1 : 0);
        result = 31 * result + (this.itemContentAfterSuffix ? 1 : 0);
        result = 31 * result + this.itemPrefixChars.hashCode();
        result = 31 * result + this.codeIndent;
        result = 31 * result + this.itemIndent;
        result = 31 * result + this.newItemCodeIndent;
        result = 31 * result + Arrays.hashCode(this.itemMarkerSuffixes);
        return result;
    }

    public static class MutableItemInterrupt
    extends ItemInterrupt {
        public MutableItemInterrupt() {
        }

        public MutableItemInterrupt(DataHolder options) {
            super(options);
        }

        public MutableItemInterrupt(ItemInterrupt other) {
            super(other);
        }

        public boolean isBulletItemInterruptsParagraph() {
            return this.bulletItemInterruptsParagraph;
        }

        public boolean isOrderedItemInterruptsParagraph() {
            return this.orderedItemInterruptsParagraph;
        }

        public boolean isOrderedNonOneItemInterruptsParagraph() {
            return this.orderedNonOneItemInterruptsParagraph;
        }

        public boolean isEmptyBulletItemInterruptsParagraph() {
            return this.emptyBulletItemInterruptsParagraph;
        }

        public boolean isEmptyOrderedItemInterruptsParagraph() {
            return this.emptyOrderedItemInterruptsParagraph;
        }

        public boolean isEmptyOrderedNonOneItemInterruptsParagraph() {
            return this.emptyOrderedNonOneItemInterruptsParagraph;
        }

        public boolean isBulletItemInterruptsItemParagraph() {
            return this.bulletItemInterruptsItemParagraph;
        }

        public boolean isOrderedItemInterruptsItemParagraph() {
            return this.orderedItemInterruptsItemParagraph;
        }

        public boolean isOrderedNonOneItemInterruptsItemParagraph() {
            return this.orderedNonOneItemInterruptsItemParagraph;
        }

        public boolean isEmptyBulletItemInterruptsItemParagraph() {
            return this.emptyBulletItemInterruptsItemParagraph;
        }

        public boolean isEmptyOrderedItemInterruptsItemParagraph() {
            return this.emptyOrderedItemInterruptsItemParagraph;
        }

        public boolean isEmptyOrderedNonOneItemInterruptsItemParagraph() {
            return this.emptyOrderedNonOneItemInterruptsItemParagraph;
        }

        public boolean isEmptyBulletSubItemInterruptsItemParagraph() {
            return this.emptyBulletSubItemInterruptsItemParagraph;
        }

        public boolean isEmptyOrderedSubItemInterruptsItemParagraph() {
            return this.emptyOrderedSubItemInterruptsItemParagraph;
        }

        public boolean isEmptyOrderedNonOneSubItemInterruptsItemParagraph() {
            return this.emptyOrderedNonOneSubItemInterruptsItemParagraph;
        }

        public MutableItemInterrupt setBulletItemInterruptsParagraph(boolean bulletItemInterruptsParagraph) {
            this.bulletItemInterruptsParagraph = bulletItemInterruptsParagraph;
            return this;
        }

        public MutableItemInterrupt setOrderedItemInterruptsParagraph(boolean orderedItemInterruptsParagraph) {
            this.orderedItemInterruptsParagraph = orderedItemInterruptsParagraph;
            return this;
        }

        public MutableItemInterrupt setOrderedNonOneItemInterruptsParagraph(boolean orderedNonOneItemInterruptsParagraph) {
            this.orderedNonOneItemInterruptsParagraph = orderedNonOneItemInterruptsParagraph;
            return this;
        }

        public MutableItemInterrupt setEmptyBulletItemInterruptsParagraph(boolean emptyBulletItemInterruptsParagraph) {
            this.emptyBulletItemInterruptsParagraph = emptyBulletItemInterruptsParagraph;
            return this;
        }

        public MutableItemInterrupt setEmptyOrderedItemInterruptsParagraph(boolean emptyOrderedItemInterruptsParagraph) {
            this.emptyOrderedItemInterruptsParagraph = emptyOrderedItemInterruptsParagraph;
            return this;
        }

        public MutableItemInterrupt setEmptyOrderedNonOneItemInterruptsParagraph(boolean emptyOrderedNonOneItemInterruptsParagraph) {
            this.emptyOrderedNonOneItemInterruptsParagraph = emptyOrderedNonOneItemInterruptsParagraph;
            return this;
        }

        public MutableItemInterrupt setBulletItemInterruptsItemParagraph(boolean bulletItemInterruptsItemParagraph) {
            this.bulletItemInterruptsItemParagraph = bulletItemInterruptsItemParagraph;
            return this;
        }

        public MutableItemInterrupt setOrderedItemInterruptsItemParagraph(boolean orderedItemInterruptsItemParagraph) {
            this.orderedItemInterruptsItemParagraph = orderedItemInterruptsItemParagraph;
            return this;
        }

        public MutableItemInterrupt setOrderedNonOneItemInterruptsItemParagraph(boolean orderedNonOneItemInterruptsItemParagraph) {
            this.orderedNonOneItemInterruptsItemParagraph = orderedNonOneItemInterruptsItemParagraph;
            return this;
        }

        public MutableItemInterrupt setEmptyBulletItemInterruptsItemParagraph(boolean emptyBulletItemInterruptsItemParagraph) {
            this.emptyBulletItemInterruptsItemParagraph = emptyBulletItemInterruptsItemParagraph;
            return this;
        }

        public MutableItemInterrupt setEmptyOrderedItemInterruptsItemParagraph(boolean emptyOrderedItemInterruptsItemParagraph) {
            this.emptyOrderedItemInterruptsItemParagraph = emptyOrderedItemInterruptsItemParagraph;
            return this;
        }

        public MutableItemInterrupt setEmptyOrderedNonOneItemInterruptsItemParagraph(boolean emptyOrderedNonOneItemInterruptsItemParagraph) {
            this.emptyOrderedNonOneItemInterruptsItemParagraph = emptyOrderedNonOneItemInterruptsItemParagraph;
            return this;
        }

        public MutableItemInterrupt setEmptyBulletSubItemInterruptsItemParagraph(boolean emptyBulletItemStartsSubList) {
            this.emptyBulletSubItemInterruptsItemParagraph = emptyBulletItemStartsSubList;
            return this;
        }

        public MutableItemInterrupt setEmptyOrderedSubItemInterruptsItemParagraph(boolean emptyOrderedItemStartsSubList) {
            this.emptyOrderedSubItemInterruptsItemParagraph = emptyOrderedItemStartsSubList;
            return this;
        }

        public MutableItemInterrupt setEmptyOrderedNonOneSubItemInterruptsItemParagraph(boolean emptyOrderedNonOneItemStartsSubList) {
            this.emptyOrderedNonOneSubItemInterruptsItemParagraph = emptyOrderedNonOneItemStartsSubList;
            return this;
        }
    }

    public static class ItemInterrupt {
        protected boolean bulletItemInterruptsParagraph;
        protected boolean orderedItemInterruptsParagraph;
        protected boolean orderedNonOneItemInterruptsParagraph;
        protected boolean emptyBulletItemInterruptsParagraph;
        protected boolean emptyOrderedItemInterruptsParagraph;
        protected boolean emptyOrderedNonOneItemInterruptsParagraph;
        protected boolean bulletItemInterruptsItemParagraph;
        protected boolean orderedItemInterruptsItemParagraph;
        protected boolean orderedNonOneItemInterruptsItemParagraph;
        protected boolean emptyBulletItemInterruptsItemParagraph;
        protected boolean emptyOrderedItemInterruptsItemParagraph;
        protected boolean emptyOrderedNonOneItemInterruptsItemParagraph;
        protected boolean emptyBulletSubItemInterruptsItemParagraph;
        protected boolean emptyOrderedSubItemInterruptsItemParagraph;
        protected boolean emptyOrderedNonOneSubItemInterruptsItemParagraph;

        public ItemInterrupt() {
            this.bulletItemInterruptsParagraph = false;
            this.orderedItemInterruptsParagraph = false;
            this.orderedNonOneItemInterruptsParagraph = false;
            this.emptyBulletItemInterruptsParagraph = false;
            this.emptyOrderedItemInterruptsParagraph = false;
            this.emptyOrderedNonOneItemInterruptsParagraph = false;
            this.bulletItemInterruptsItemParagraph = false;
            this.orderedItemInterruptsItemParagraph = false;
            this.orderedNonOneItemInterruptsItemParagraph = false;
            this.emptyBulletItemInterruptsItemParagraph = false;
            this.emptyOrderedItemInterruptsItemParagraph = false;
            this.emptyOrderedNonOneItemInterruptsItemParagraph = false;
            this.emptyBulletSubItemInterruptsItemParagraph = false;
            this.emptyOrderedSubItemInterruptsItemParagraph = false;
            this.emptyOrderedNonOneSubItemInterruptsItemParagraph = false;
        }

        public ItemInterrupt(DataHolder options) {
            this.bulletItemInterruptsParagraph = (Boolean)Parser.LISTS_BULLET_ITEM_INTERRUPTS_PARAGRAPH.getFrom(options);
            this.orderedItemInterruptsParagraph = (Boolean)Parser.LISTS_ORDERED_ITEM_INTERRUPTS_PARAGRAPH.getFrom(options);
            this.orderedNonOneItemInterruptsParagraph = (Boolean)Parser.LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH.getFrom(options);
            this.emptyBulletItemInterruptsParagraph = (Boolean)Parser.LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_PARAGRAPH.getFrom(options);
            this.emptyOrderedItemInterruptsParagraph = (Boolean)Parser.LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_PARAGRAPH.getFrom(options);
            this.emptyOrderedNonOneItemInterruptsParagraph = (Boolean)Parser.LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH.getFrom(options);
            this.bulletItemInterruptsItemParagraph = (Boolean)Parser.LISTS_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH.getFrom(options);
            this.orderedItemInterruptsItemParagraph = (Boolean)Parser.LISTS_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH.getFrom(options);
            this.orderedNonOneItemInterruptsItemParagraph = (Boolean)Parser.LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH.getFrom(options);
            this.emptyBulletItemInterruptsItemParagraph = (Boolean)Parser.LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH.getFrom(options);
            this.emptyOrderedItemInterruptsItemParagraph = (Boolean)Parser.LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH.getFrom(options);
            this.emptyOrderedNonOneItemInterruptsItemParagraph = (Boolean)Parser.LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH.getFrom(options);
            this.emptyBulletSubItemInterruptsItemParagraph = (Boolean)Parser.LISTS_EMPTY_BULLET_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH.getFrom(options);
            this.emptyOrderedSubItemInterruptsItemParagraph = (Boolean)Parser.LISTS_EMPTY_ORDERED_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH.getFrom(options);
            this.emptyOrderedNonOneSubItemInterruptsItemParagraph = (Boolean)Parser.LISTS_EMPTY_ORDERED_NON_ONE_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH.getFrom(options);
        }

        public void setIn(MutableDataHolder options) {
            options.set(Parser.LISTS_BULLET_ITEM_INTERRUPTS_PARAGRAPH, (Object)this.bulletItemInterruptsParagraph);
            options.set(Parser.LISTS_ORDERED_ITEM_INTERRUPTS_PARAGRAPH, (Object)this.orderedItemInterruptsParagraph);
            options.set(Parser.LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH, (Object)this.orderedNonOneItemInterruptsParagraph);
            options.set(Parser.LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_PARAGRAPH, (Object)this.emptyBulletItemInterruptsParagraph);
            options.set(Parser.LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_PARAGRAPH, (Object)this.emptyOrderedItemInterruptsParagraph);
            options.set(Parser.LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH, (Object)this.emptyOrderedNonOneItemInterruptsParagraph);
            options.set(Parser.LISTS_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH, (Object)this.bulletItemInterruptsItemParagraph);
            options.set(Parser.LISTS_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH, (Object)this.orderedItemInterruptsItemParagraph);
            options.set(Parser.LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH, (Object)this.orderedNonOneItemInterruptsItemParagraph);
            options.set(Parser.LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH, (Object)this.emptyBulletItemInterruptsItemParagraph);
            options.set(Parser.LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH, (Object)this.emptyOrderedItemInterruptsItemParagraph);
            options.set(Parser.LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH, (Object)this.emptyOrderedNonOneItemInterruptsItemParagraph);
            options.set(Parser.LISTS_EMPTY_BULLET_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH, (Object)this.emptyBulletSubItemInterruptsItemParagraph);
            options.set(Parser.LISTS_EMPTY_ORDERED_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH, (Object)this.emptyOrderedSubItemInterruptsItemParagraph);
            options.set(Parser.LISTS_EMPTY_ORDERED_NON_ONE_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH, (Object)this.emptyOrderedNonOneSubItemInterruptsItemParagraph);
        }

        public ItemInterrupt(ItemInterrupt other) {
            this.bulletItemInterruptsParagraph = other.bulletItemInterruptsParagraph;
            this.orderedItemInterruptsParagraph = other.orderedItemInterruptsParagraph;
            this.orderedNonOneItemInterruptsParagraph = other.orderedNonOneItemInterruptsParagraph;
            this.emptyBulletItemInterruptsParagraph = other.emptyBulletItemInterruptsParagraph;
            this.emptyOrderedItemInterruptsParagraph = other.emptyOrderedItemInterruptsParagraph;
            this.emptyOrderedNonOneItemInterruptsParagraph = other.emptyOrderedNonOneItemInterruptsParagraph;
            this.bulletItemInterruptsItemParagraph = other.bulletItemInterruptsItemParagraph;
            this.orderedItemInterruptsItemParagraph = other.orderedItemInterruptsItemParagraph;
            this.orderedNonOneItemInterruptsItemParagraph = other.orderedNonOneItemInterruptsItemParagraph;
            this.emptyBulletItemInterruptsItemParagraph = other.emptyBulletItemInterruptsItemParagraph;
            this.emptyOrderedItemInterruptsItemParagraph = other.emptyOrderedItemInterruptsItemParagraph;
            this.emptyOrderedNonOneItemInterruptsItemParagraph = other.emptyOrderedNonOneItemInterruptsItemParagraph;
            this.emptyBulletSubItemInterruptsItemParagraph = other.emptyBulletSubItemInterruptsItemParagraph;
            this.emptyOrderedSubItemInterruptsItemParagraph = other.emptyOrderedSubItemInterruptsItemParagraph;
            this.emptyOrderedNonOneSubItemInterruptsItemParagraph = other.emptyOrderedNonOneSubItemInterruptsItemParagraph;
        }

        public boolean canInterrupt(boolean isNumberedItem, boolean isOneItem, boolean isEmptyItem, boolean isItemParagraph) {
            if (isNumberedItem) {
                if (isOneItem) {
                    if (isItemParagraph) {
                        return this.orderedItemInterruptsItemParagraph && (!isEmptyItem || this.emptyOrderedItemInterruptsItemParagraph);
                    }
                    return this.orderedItemInterruptsParagraph && (!isEmptyItem || this.emptyOrderedItemInterruptsParagraph);
                }
                if (isItemParagraph) {
                    return this.orderedNonOneItemInterruptsItemParagraph && (!isEmptyItem || this.emptyOrderedNonOneItemInterruptsItemParagraph);
                }
                return this.orderedNonOneItemInterruptsParagraph && (!isEmptyItem || this.emptyOrderedNonOneItemInterruptsParagraph);
            }
            if (isItemParagraph) {
                return this.bulletItemInterruptsItemParagraph && (!isEmptyItem || this.emptyBulletItemInterruptsItemParagraph);
            }
            return this.bulletItemInterruptsParagraph && (!isEmptyItem || this.emptyBulletItemInterruptsParagraph);
        }

        public boolean canStartSubList(boolean isNumberedItem, boolean isOneItem, boolean isEmptyItem) {
            if (isNumberedItem) {
                return this.orderedItemInterruptsItemParagraph && (!isEmptyItem || this.emptyOrderedSubItemInterruptsItemParagraph && this.emptyOrderedItemInterruptsItemParagraph) && (isOneItem || this.orderedNonOneItemInterruptsItemParagraph && (!isEmptyItem || this.emptyOrderedNonOneSubItemInterruptsItemParagraph && this.emptyOrderedNonOneItemInterruptsItemParagraph));
            }
            return this.bulletItemInterruptsItemParagraph && (!isEmptyItem || this.emptyBulletSubItemInterruptsItemParagraph && this.emptyBulletItemInterruptsItemParagraph);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemInterrupt)) {
                return false;
            }
            ItemInterrupt interrupt = (ItemInterrupt)o;
            if (this.bulletItemInterruptsParagraph != interrupt.bulletItemInterruptsParagraph) {
                return false;
            }
            if (this.orderedItemInterruptsParagraph != interrupt.orderedItemInterruptsParagraph) {
                return false;
            }
            if (this.orderedNonOneItemInterruptsParagraph != interrupt.orderedNonOneItemInterruptsParagraph) {
                return false;
            }
            if (this.emptyBulletItemInterruptsParagraph != interrupt.emptyBulletItemInterruptsParagraph) {
                return false;
            }
            if (this.emptyOrderedItemInterruptsParagraph != interrupt.emptyOrderedItemInterruptsParagraph) {
                return false;
            }
            if (this.emptyOrderedNonOneItemInterruptsParagraph != interrupt.emptyOrderedNonOneItemInterruptsParagraph) {
                return false;
            }
            if (this.bulletItemInterruptsItemParagraph != interrupt.bulletItemInterruptsItemParagraph) {
                return false;
            }
            if (this.orderedItemInterruptsItemParagraph != interrupt.orderedItemInterruptsItemParagraph) {
                return false;
            }
            if (this.orderedNonOneItemInterruptsItemParagraph != interrupt.orderedNonOneItemInterruptsItemParagraph) {
                return false;
            }
            if (this.emptyBulletItemInterruptsItemParagraph != interrupt.emptyBulletItemInterruptsItemParagraph) {
                return false;
            }
            if (this.emptyOrderedItemInterruptsItemParagraph != interrupt.emptyOrderedItemInterruptsItemParagraph) {
                return false;
            }
            if (this.emptyOrderedNonOneItemInterruptsItemParagraph != interrupt.emptyOrderedNonOneItemInterruptsItemParagraph) {
                return false;
            }
            if (this.emptyBulletSubItemInterruptsItemParagraph != interrupt.emptyBulletSubItemInterruptsItemParagraph) {
                return false;
            }
            if (this.emptyOrderedSubItemInterruptsItemParagraph != interrupt.emptyOrderedSubItemInterruptsItemParagraph) {
                return false;
            }
            return this.emptyOrderedNonOneSubItemInterruptsItemParagraph == interrupt.emptyOrderedNonOneSubItemInterruptsItemParagraph;
        }

        public int hashCode() {
            int result = this.bulletItemInterruptsParagraph ? 1 : 0;
            result = 31 * result + (this.orderedItemInterruptsParagraph ? 1 : 0);
            result = 31 * result + (this.orderedNonOneItemInterruptsParagraph ? 1 : 0);
            result = 31 * result + (this.emptyBulletItemInterruptsParagraph ? 1 : 0);
            result = 31 * result + (this.emptyOrderedItemInterruptsParagraph ? 1 : 0);
            result = 31 * result + (this.emptyOrderedNonOneItemInterruptsParagraph ? 1 : 0);
            result = 31 * result + (this.bulletItemInterruptsItemParagraph ? 1 : 0);
            result = 31 * result + (this.orderedItemInterruptsItemParagraph ? 1 : 0);
            result = 31 * result + (this.orderedNonOneItemInterruptsItemParagraph ? 1 : 0);
            result = 31 * result + (this.emptyBulletItemInterruptsItemParagraph ? 1 : 0);
            result = 31 * result + (this.emptyOrderedItemInterruptsItemParagraph ? 1 : 0);
            result = 31 * result + (this.emptyOrderedNonOneItemInterruptsItemParagraph ? 1 : 0);
            result = 31 * result + (this.emptyBulletSubItemInterruptsItemParagraph ? 1 : 0);
            result = 31 * result + (this.emptyOrderedSubItemInterruptsItemParagraph ? 1 : 0);
            result = 31 * result + (this.emptyOrderedNonOneSubItemInterruptsItemParagraph ? 1 : 0);
            return result;
        }
    }
}

