/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Function;
import javaslang.Lazy;
import javaslang.collection.AbstractIterator;
import javaslang.collection.Iterator;
import javaslang.collection.Set;

interface IteratorModule {

    public static final class BigDecimalHelper {
        private static final Lazy<BigDecimal> INFINITY_DISTANCE = Lazy.of(() -> {
            BigDecimal supremum;
            BigDecimal two = BigDecimal.valueOf(2L);
            BigDecimal lowerBound = supremum = BigDecimal.valueOf(Math.nextDown(Double.POSITIVE_INFINITY));
            BigDecimal upperBound = two.pow(1024);
            while (true) {
                BigDecimal magicValue;
                if (Double.isInfinite((magicValue = lowerBound.add(upperBound).divide(two, RoundingMode.HALF_UP)).doubleValue())) {
                    if (BigDecimalHelper.areEqual(magicValue, upperBound)) {
                        return magicValue.subtract(supremum);
                    }
                    upperBound = magicValue;
                    continue;
                }
                lowerBound = magicValue;
            }
        });

        static boolean areEqual(BigDecimal from, BigDecimal toExclusive) {
            return from.compareTo(toExclusive) == 0;
        }

        static BigDecimal asDecimal(double number) {
            if (number == Double.NEGATIVE_INFINITY) {
                BigDecimal result = BigDecimal.valueOf(Math.nextUp(Double.NEGATIVE_INFINITY));
                return result.subtract(INFINITY_DISTANCE.get());
            }
            if (number == Double.POSITIVE_INFINITY) {
                BigDecimal result = BigDecimal.valueOf(Math.nextDown(Double.POSITIVE_INFINITY));
                return result.add(INFINITY_DISTANCE.get());
            }
            return BigDecimal.valueOf(number);
        }
    }

    public static final class DistinctIterator<T, U>
    extends AbstractIterator<T> {
        private final Iterator<? extends T> that;
        private Set<U> known;
        private final Function<? super T, ? extends U> keyExtractor;
        private T next = null;

        DistinctIterator(Iterator<? extends T> that, Set<U> set, Function<? super T, ? extends U> keyExtractor) {
            this.that = that;
            this.known = set;
            this.keyExtractor = keyExtractor;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null && this.that.hasNext()) {
                Object elem = this.that.next();
                U key = this.keyExtractor.apply(elem);
                if (this.known.contains(key)) continue;
                this.known = this.known.add(key);
                this.next = elem;
            }
            return this.next != null;
        }

        @Override
        public T getNext() {
            T result = this.next;
            this.next = null;
            return result;
        }
    }

    public static final class ConcatIterator<T>
    extends AbstractIterator<T> {
        private final Iterator<? extends Iterator<? extends T>> iterators;
        private Iterator<? extends T> current = Iterator.empty();

        ConcatIterator(Iterator<? extends Iterator<? extends T>> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while (!this.current.hasNext() && !this.iterators.isEmpty()) {
                this.current = (Iterator)this.iterators.next();
            }
            return this.current.hasNext();
        }

        @Override
        public T getNext() {
            return (T)this.current.next();
        }
    }
}

