/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javaslang.Function1;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.collection.Collections;
import javaslang.collection.Iterator;
import javaslang.collection.List;
import javaslang.collection.Seq;
import javaslang.collection.Set;
import javaslang.collection.Stream;
import javaslang.collection.Traversable;
import javaslang.collection.Vector;
import javaslang.control.Option;

public interface Map<K, V>
extends Traversable<Tuple2<K, V>>,
Function1<K, V> {
    public static final long serialVersionUID = 1L;

    public static <K, V> Map<K, V> narrow(Map<? extends K, ? extends V> map) {
        return map;
    }

    @Override
    default public V apply(K key) {
        return this.get(key).getOrElseThrow(NoSuchElementException::new);
    }

    public <K2, V2> Map<K2, V2> bimap(Function<? super K, ? extends K2> var1, Function<? super V, ? extends V2> var2);

    public boolean containsKey(K var1);

    default public boolean containsValue(V value) {
        return this.iterator().map(Tuple2::_2).contains(value);
    }

    public <K2, V2> Map<K2, V2> flatMap(BiFunction<? super K, ? super V, ? extends Iterable<Tuple2<K2, V2>>> var1);

    public Option<V> get(K var1);

    public Set<K> keySet();

    public <K2, V2> Map<K2, V2> map(BiFunction<? super K, ? super V, Tuple2<K2, V2>> var1);

    public <V2> Map<K, V2> mapValues(Function<? super V, ? extends V2> var1);

    public Map<K, V> put(K var1, V var2);

    public Map<K, V> put(Tuple2<? extends K, ? extends V> var1);

    public Map<K, V> remove(K var1);

    public Map<K, V> removeAll(Iterable<? extends K> var1);

    @Override
    public int size();

    public java.util.Map<K, V> toJavaMap();

    default public <U> U transform(Function<? super Map<K, V>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    default public <U> Seq<U> traverse(BiFunction<K, V, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.foldLeft(Vector.empty(), (acc, entry) -> acc.append(mapper.apply(entry._1, entry._2)));
    }

    default public <T1, T2> Tuple2<Seq<T1>, Seq<T2>> unzip(BiFunction<? super K, ? super V, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        return this.unzip((Function<? super Tuple2<K, V>, Tuple2<? extends T1, ? extends T2>>)((Function<Tuple2, Tuple2>)entry -> (Tuple2)unzipper.apply((Object)entry._1, (Object)entry._2)));
    }

    default public <T1, T2, T3> Tuple3<Seq<T1>, Seq<T2>, Seq<T3>> unzip3(BiFunction<? super K, ? super V, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        return this.unzip3((Function<? super Tuple2<K, V>, Tuple3<? extends T1, ? extends T2, ? extends T3>>)((Function<Tuple2, Tuple3>)entry -> (Tuple3)unzipper.apply((Object)entry._1, (Object)entry._2)));
    }

    public Seq<V> values();

    @Override
    default public boolean contains(Tuple2<K, V> element) {
        return this.get(element._1).map((T v) -> Objects.equals(v, element._2)).getOrElse(false);
    }

    public Map<K, V> distinct();

    public Map<K, V> distinctBy(Comparator<? super Tuple2<K, V>> var1);

    public <U> Map<K, V> distinctBy(Function<? super Tuple2<K, V>, ? extends U> var1);

    public Map<K, V> drop(long var1);

    public Map<K, V> dropRight(long var1);

    public Map<K, V> dropUntil(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> dropWhile(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> filter(Predicate<? super Tuple2<K, V>> var1);

    @Override
    default public <U> Seq<U> flatMap(Function<? super Tuple2<K, V>, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.iterator().flatMap(mapper).toStream();
    }

    @Override
    default public <U> U foldRight(U zero, BiFunction<? super Tuple2<K, V>, ? super U, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return this.iterator().foldRight(zero, f);
    }

    @Override
    public <C> Map<C, ? extends Map<K, V>> groupBy(Function<? super Tuple2<K, V>, ? extends C> var1);

    @Override
    public Iterator<? extends Map<K, V>> grouped(long var1);

    @Override
    default public boolean hasDefiniteSize() {
        return true;
    }

    public Map<K, V> init();

    @Override
    public Option<? extends Map<K, V>> initOption();

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator();

    @Override
    default public int length() {
        return this.size();
    }

    @Override
    default public <U> Seq<U> map(Function<? super Tuple2<K, V>, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.iterator().map(mapper).toStream();
    }

    public Map<K, V> merge(Map<? extends K, ? extends V> var1);

    public <U extends V> Map<K, V> merge(Map<? extends K, U> var1, BiFunction<? super V, ? super U, ? extends V> var2);

    @Override
    public Tuple2<? extends Map<K, V>, ? extends Map<K, V>> partition(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> peek(Consumer<? super Tuple2<K, V>> var1);

    public Map<K, V> replace(Tuple2<K, V> var1, Tuple2<K, V> var2);

    public Map<K, V> replaceAll(Tuple2<K, V> var1, Tuple2<K, V> var2);

    public Map<K, V> retainAll(Iterable<? extends Tuple2<K, V>> var1);

    public Map<K, V> scan(Tuple2<K, V> var1, BiFunction<? super Tuple2<K, V>, ? super Tuple2<K, V>, ? extends Tuple2<K, V>> var2);

    @Override
    default public <U> Seq<U> scanLeft(U zero, BiFunction<? super U, ? super Tuple2<K, V>, ? extends U> operation) {
        Objects.requireNonNull(operation, "operation is null");
        return Collections.scanLeft(this, zero, operation, List.empty(), List::prepend, List::reverse);
    }

    @Override
    default public <U> Seq<U> scanRight(U zero, BiFunction<? super Tuple2<K, V>, ? super U, ? extends U> operation) {
        Objects.requireNonNull(operation, "operation is null");
        return (Seq)Collections.scanRight(this, zero, operation, List.empty(), List::prepend, Function.identity());
    }

    @Override
    public Iterator<? extends Map<K, V>> sliding(long var1);

    @Override
    public Iterator<? extends Map<K, V>> sliding(long var1, long var3);

    @Override
    public Tuple2<? extends Map<K, V>, ? extends Map<K, V>> span(Predicate<? super Tuple2<K, V>> var1);

    @Override
    default public Spliterator<Tuple2<K, V>> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    public Map<K, V> tail();

    @Override
    public Option<? extends Map<K, V>> tailOption();

    public Map<K, V> take(long var1);

    public Map<K, V> takeRight(long var1);

    public Map<K, V> takeUntil(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> takeWhile(Predicate<? super Tuple2<K, V>> var1);

    @Override
    default public <T1, T2> Tuple2<Seq<T1>, Seq<T2>> unzip(Function<? super Tuple2<K, V>, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        return this.iterator().unzip(unzipper).map(Stream::ofAll, Stream::ofAll);
    }

    @Override
    default public <T1, T2, T3> Tuple3<Seq<T1>, Seq<T2>, Seq<T3>> unzip3(Function<? super Tuple2<K, V>, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        return this.iterator().unzip3(unzipper).map(Stream::ofAll, Stream::ofAll, Stream::ofAll);
    }

    @Override
    default public <U> Seq<Tuple2<Tuple2<K, V>, U>> zip(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        return Stream.ofAll(this.iterator().zip(that));
    }

    @Override
    default public <U> Seq<Tuple2<Tuple2<K, V>, U>> zipAll(Iterable<? extends U> that, Tuple2<K, V> thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        return Stream.ofAll(this.iterator().zipAll(that, thisElem, thatElem));
    }

    @Override
    default public Seq<Tuple2<Tuple2<K, V>, Long>> zipWithIndex() {
        return Stream.ofAll(this.iterator().zipWithIndex());
    }

    default public void forEach(BiConsumer<K, V> action) {
        Objects.requireNonNull(action, "action is null");
        for (Tuple2 t : this) {
            action.accept(t._1, t._2);
        }
    }
}

