/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.generator.AggregateSpecification;
import ma.glasnost.orika.impl.generator.Node;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public class MultiOccurrenceToMultiOccurrence
implements AggregateSpecification {
    protected MapperFactory mapperFactory;

    @Override
    public String generateMappingCode(List<FieldMap> fieldMappings, SourceCodeContext code) {
        StringBuilder out = new StringBuilder();
        while (!fieldMappings.isEmpty()) {
            Set<FieldMap> associated = code.getAssociatedMappings(fieldMappings, fieldMappings.get(0));
            fieldMappings.removeAll(associated);
            Node.NodeList sourceNodes = new Node.NodeList();
            Node.NodeList destNodes = new Node.NodeList();
            for (FieldMap map : associated) {
                Node.addFieldMap(map, sourceNodes, true);
                Node.addFieldMap(map, destNodes, false);
            }
            this.registerClassMaps(sourceNodes, destNodes);
            out.append(this.generateMultiOccurrenceMapping(sourceNodes, destNodes, associated, code));
        }
        return out.toString();
    }

    @Override
    public void setMapperFactory(MapperFactory mapperFactory) {
        this.mapperFactory = mapperFactory;
    }

    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getSource().getContainer() != null || fieldMap.getDestination().getContainer() != null;
    }

    /*
     * WARNING - void declaration
     */
    private String generateMultiOccurrenceMapping(Node.NodeList sourceNodes, Node.NodeList destNodes, Set<FieldMap> subFields, SourceCodeContext code) {
        void var8_12;
        StringBuilder out = new StringBuilder();
        StringBuilder sourcesNotNull = new StringBuilder();
        for (FieldMap fieldMap : subFields) {
            out.append(code.assureContainerInstanceExists(fieldMap));
        }
        ArrayList<String> sourceSizes = new ArrayList<String>();
        for (Object ref : sourceNodes) {
            if (((Node)ref).isLeaf()) continue;
            sourceSizes.add(((Node)ref).multiOccurrenceVar.size());
            if (sourcesNotNull.length() > 0) {
                sourcesNotNull.append(" && ");
            }
            sourcesNotNull.append(((Node)ref).multiOccurrenceVar.notNull());
        }
        String string = SourceCodeContext.join(sourceSizes, ", ");
        if (!"".equals(string)) {
            String string2 = "min(new int[]{" + string + "})";
        }
        for (Node destRef : destNodes) {
            if (destRef.isLeaf()) continue;
            out.append(SourceCodeContext.statement(destRef.newDestination.declare(), new Object[0]));
            if (!"".equals(sourcesNotNull.toString())) {
                out.append(SourceCodeContext.statement("if (%s) {\n%s;\n} else {\n%s;}", sourcesNotNull, destRef.newDestination.assign(destRef.newDestination.newInstance((String)var8_12), new Object[0]), destRef.newDestination.assign("null", new Object[0])));
            } else {
                out.append(SourceCodeContext.statement(destRef.newDestination.assign("null", new Object[0]), new Object[0]));
            }
            if (destRef.newDestination.isArray()) {
                out.append(SourceCodeContext.statement(destRef.newDestination.declareIterator(), new Object[0]));
            }
            ArrayList<Node> children = new ArrayList<Node>();
            children.add(destRef);
            while (!children.isEmpty()) {
                Node child = (Node)children.remove(0);
                children.addAll(child.children);
                if (child.elementRef == null) continue;
                out.append(SourceCodeContext.statement(child.elementRef.declare(), new Object[0]));
                if (child.multiOccurrenceVar.isArray()) {
                    out.append(SourceCodeContext.statement(child.multiOccurrenceVar.declareIterator(), new Object[0]));
                }
                if (child.elementRef.isPrimitive()) {
                    out.append(SourceCodeContext.statement(child.nullCheckFlag.declare("true", new Object[0]), new Object[0]));
                }
                out.append(SourceCodeContext.statement(child.shouldAddToCollectorFlag.declare("false", new Object[0]), new Object[0]));
            }
        }
        StringBuilder endWhiles = new StringBuilder();
        this.iterateSources(sourceNodes, destNodes, out, endWhiles);
        LinkedList<Node> stack = new LinkedList<Node>(destNodes);
        while (!stack.isEmpty()) {
            Node currentNode = stack.removeFirst();
            stack.addAll(0, currentNode.children);
            Node srcNode = null;
            if (currentNode.value != null) {
                srcNode = Node.findFieldMap(currentNode.value, sourceNodes, true);
            } else {
                FieldMap fieldMap = currentNode.getMap();
                if (fieldMap != null) {
                    srcNode = Node.findFieldMap((FieldMap)fieldMap, (Node.NodeList)sourceNodes, (boolean)true).parent;
                }
            }
            if (!currentNode.isLeaf() && srcNode != null) {
                String or;
                String currentElementNull = currentNode.elementRef.isPrimitive() ? currentNode.nullCheckFlag.toString() : currentNode.elementRef.isNull();
                String currentElementComparator = code.currentElementComparator(srcNode, currentNode, sourceNodes, destNodes);
                String string3 = or = !"".equals(currentElementNull) && !"".equals(currentElementComparator) ? " || " : "";
                if (this.mapperFactory.getConverterFactory().canConvert(srcNode.elementRef.type(), currentNode.elementRef.type()) || currentNode.elementRef.type().isImmutable()) {
                    SourceCodeContext.append(out, currentNode.elementRef.isPrimitive() ? currentNode.nullCheckFlag.assign("false", new Object[0]) : "", currentNode.shouldAddToCollectorFlag.assign("true", new Object[0]));
                } else {
                    SourceCodeContext.append(out, "if ( " + currentElementNull + or + currentElementComparator + ") {\n", currentNode.elementRef.assign(code.newObject(srcNode.elementRef, currentNode.elementRef.type()), new Object[0]), currentNode.shouldAddToCollectorFlag.assign("true", new Object[0]), "}");
                }
            }
            if (srcNode == null) continue;
            if (currentNode.value != null) {
                String assignNull;
                boolean wasConverted = this.mapFields(currentNode, srcNode, out, code);
                if (srcNode.parent == null || srcNode.parent.elementRef == null || currentNode.parent == null || currentNode.parent.elementRef == null || currentNode.parent.addedToCollector) continue;
                String string4 = assignNull = currentNode.parent.elementRef.isPrimitive() ? currentNode.parent.nullCheckFlag.assign("true", new Object[0]) : currentNode.parent.elementRef.assign("null", new Object[0]);
                if (this.mapperFactory.getConverterFactory().canConvert(srcNode.parent.elementRef.type(), currentNode.parent.elementRef.type())) {
                    SourceCodeContext.append(out, currentNode.parent.isRoot() ? currentNode.parent.newDestination.add(currentNode.parent.elementRef) : currentNode.parent.multiOccurrenceVar.add(currentNode.parent.elementRef), assignNull);
                } else {
                    SourceCodeContext.append(out, String.format("if (%s) {", currentNode.parent.shouldAddToCollectorFlag), currentNode.parent.isRoot() ? currentNode.parent.newDestination.add(currentNode.parent.elementRef) : currentNode.parent.multiOccurrenceVar.add(currentNode.parent.elementRef), currentNode.parent.shouldAddToCollectorFlag.assign("false", new Object[0]), wasConverted ? assignNull : "", "}");
                }
                currentNode.parent.addedToCollector = true;
                continue;
            }
            VariableRef s = this.makeVariable(srcNode.property, srcNode, "source");
            VariableRef d = this.makeVariable(currentNode.property, currentNode, "destination");
            code.applyFilters(s, d, out, endWhiles);
            d = currentNode.isRoot() ? currentNode.newDestination : currentNode.multiOccurrenceVar;
            out.append(String.format("\nmappingContext.beginMapping(%s, %s, %s, %s);\n", code.usedType(s.type()), s.asWrapper(), code.usedType(d.type()), d.asWrapper()));
            out.append("try {\n");
            endWhiles.insert(0, "\n} finally {\n  mappingContext.endMapping();\n}\n");
        }
        out.append(endWhiles.toString());
        for (Node destRef : destNodes) {
            if (!destRef.isRoot() || destRef.isLeaf()) continue;
            if (destRef.multiOccurrenceVar.isArray()) {
                SourceCodeContext.append(out, String.format("if (%s && %s) {", destRef.newDestination.notNull(), destRef.newDestination.notEmpty()), destRef.multiOccurrenceVar.addAll(destRef.newDestination), "}\n");
                continue;
            }
            SourceCodeContext.append(out, String.format("if (%s && %s) {", destRef.newDestination.notNull(), destRef.newDestination.notEmpty()), String.format("if (%s) {", destRef.multiOccurrenceVar.isNull()), destRef.multiOccurrenceVar.assignIfPossible(destRef.multiOccurrenceVar.newInstance((String)var8_12), new Object[0]), "} else {\n", destRef.multiOccurrenceVar + ".clear()", "}\n", destRef.multiOccurrenceVar.addAllButNoAssign(destRef.newDestination), "}\n");
        }
        return out.toString();
    }

    private Property innermostElement(Property p) {
        Property result = p;
        while (result.getElement() != null) {
            result = result.getElement();
        }
        return result;
    }

    private boolean mapFields(Node currentNode, Node srcNode, StringBuilder out, SourceCodeContext code) {
        VariableRef elRef;
        VariableRef s = this.makeVariable(currentNode.value.getSource(), srcNode, "source");
        VariableRef d = this.makeVariable(currentNode.value.getDestination(), currentNode, "destination");
        String mapStmt = SourceCodeContext.statement(code.mapFields(currentNode.value, s, d), new Object[0]);
        VariableRef variableRef = elRef = currentNode.parent != null ? currentNode.parent.elementRef : null;
        if (elRef != null && !elRef.isPrimitive() && !elRef.type().isImmutable() && srcNode.parent != null) {
            SourceCodeContext.append(out, String.format("if((%s)) { \n", elRef.isNull()), elRef.assign(code.newObject(srcNode.parent.elementRef, elRef.type()), new Object[0]), "}");
        }
        out.append(mapStmt);
        Type<Object> parentElementType = currentNode.parent != null ? currentNode.parent.elementRef.type() : TypeFactory.TYPE_OF_OBJECT;
        return d.type().equals(parentElementType) && this.mapperFactory.getConverterFactory().canConvert(s.type(), d.type());
    }

    private VariableRef makeVariable(Property currentProp, Node node, String defName) {
        String name = node.parent != null ? node.parent.elementRef.name() : defName;
        Property p = this.innermostElement(currentProp);
        Property prop = new Property.Builder().merge(p).expression(p.getExpression()).build();
        return new VariableRef(prop, name);
    }

    private void registerClassMaps(Node.NodeList sourceNodes, Node.NodeList destNodes) {
        HashMap<MapperKey, ClassMapBuilder<Object, Object>> builders = new HashMap<MapperKey, ClassMapBuilder<Object, Object>>();
        LinkedList<Node> stack = new LinkedList<Node>(destNodes);
        while (!stack.isEmpty()) {
            MapperKey key;
            Node currentNode = stack.removeFirst();
            stack.addAll(0, currentNode.children);
            Node srcNode = null;
            if (currentNode.value != null) {
                srcNode = Node.findFieldMap(currentNode.value, sourceNodes, true);
            } else {
                FieldMap fieldMap = currentNode.getMap();
                if (fieldMap != null) {
                    srcNode = Node.findFieldMap((FieldMap)fieldMap, (Node.NodeList)sourceNodes, (boolean)true).parent;
                }
            }
            if (srcNode == null || srcNode.parent == null || srcNode.parent.elementRef == null || currentNode == null || currentNode.parent == null || currentNode.parent.elementRef == null || (key = new MapperKey(srcNode.parent.elementRef.type(), currentNode.parent.elementRef.type())).getAType().isImmutable() || key.getBType().isImmutable() || this.mapperFactory.existsRegisteredMapper(key.getAType(), key.getBType(), true) || this.mapperFactory.getClassMap(key) != null) continue;
            ClassMapBuilder<Object, Object> builder = (ClassMapBuilder<Object, Object>)builders.get(key);
            if (builder == null) {
                builder = this.mapperFactory.classMap(key.getAType(), key.getBType());
                builders.put(key, builder);
            }
            Property sp = this.innermostElement(currentNode.value.getSource());
            Property dp = this.innermostElement(currentNode.value.getDestination());
            builder.fieldMap(sp.getExpression(), dp.getExpression()).add();
        }
        for (ClassMapBuilder builder : builders.values()) {
            builder.register();
        }
    }

    private void iterateSources(Node.NodeList sourceNodes, Node.NodeList destNodes, StringBuilder out, StringBuilder endWhiles) {
        if (!sourceNodes.isEmpty()) {
            for (Node srcRef : sourceNodes) {
                if (srcRef.isLeaf()) continue;
                out.append(srcRef.multiOccurrenceVar.ifNotNull()).append(" {\n");
                endWhiles.append("\n}");
                out.append(SourceCodeContext.statement(srcRef.multiOccurrenceVar.declareIterator(), new Object[0]));
            }
            StringBuilder loopSource = new StringBuilder();
            loopSource.append("while (");
            Iterator sourcesIter = sourceNodes.iterator();
            boolean atLeastOneIter = false;
            while (sourcesIter.hasNext()) {
                Node ref = (Node)sourcesIter.next();
                if (ref.isLeaf()) continue;
                if (atLeastOneIter) {
                    loopSource.append(" && ");
                }
                loopSource.append(ref.multiOccurrenceVar.iteratorHasNext());
                atLeastOneIter = true;
            }
            loopSource.append(") {");
            if (atLeastOneIter) {
                out.append("\n");
                out.append(loopSource.toString());
            }
            for (Node srcRef : sourceNodes) {
                if (srcRef.isLeaf()) continue;
                out.append(SourceCodeContext.statement(srcRef.elementRef.declare(srcRef.multiOccurrenceVar.nextElementRef()), new Object[0]));
                this.iterateSources(srcRef.children, destNodes, out, endWhiles);
            }
            if (atLeastOneIter) {
                endWhiles.append("}\n");
            }
        }
    }
}

