/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.metadata.TypeKey;

public final class Type<T>
implements ParameterizedType,
Comparable<Type<?>> {
    private static final AtomicInteger nextUniqueIndex = new AtomicInteger();
    private final Class<T> rawType;
    private final Type<?>[] actualTypeArguments;
    private final boolean isParameterized;
    private Map<String, Type<?>> typesByVariable;
    private volatile Type<?> superType;
    private volatile Type<?>[] interfaces;
    private Type<?> componentType;
    private final TypeKey key;
    private final int uniqueIndex;
    private static final Set<Class<?>> PRIMITIVE_WRAPPER_TYPES;
    private static final Set<Class<?>> IMMUTABLE_WRAPPER_TYPES;

    Type(TypeKey key, Class<?> rawType, Map<String, Type<?>> typesByVariable, Type<?> ... actualTypeArguments) {
        this.key = key;
        this.rawType = rawType;
        this.actualTypeArguments = actualTypeArguments;
        this.typesByVariable = typesByVariable;
        this.isParameterized = rawType.getTypeParameters().length > 0;
        this.uniqueIndex = nextUniqueIndex.getAndIncrement();
    }

    public boolean isParameterized() {
        return this.isParameterized;
    }

    public synchronized boolean isSelfOrAncestorParameterized() {
        Type<?> superType = this;
        while (!superType.equals(TypeFactory.TYPE_OF_OBJECT)) {
            if (superType.isParameterized()) {
                return true;
            }
            superType = superType.getSuperType();
        }
        return false;
    }

    private Type<?> resolveGenericAncestor(java.lang.reflect.Type ancestor) {
        Type<Object> resolvedType = null;
        if (ancestor instanceof ParameterizedType) {
            resolvedType = TypeFactory.resolveValueOf((ParameterizedType)ancestor, this);
        } else if (ancestor instanceof Class) {
            resolvedType = TypeFactory.valueOf((Class)ancestor);
        } else if (ancestor == null) {
            resolvedType = TypeFactory.TYPE_OF_OBJECT;
        } else {
            throw new IllegalStateException("super-type of " + this.toString() + " is neither Class, nor ParameterizedType, but " + ancestor);
        }
        return resolvedType;
    }

    public int getUniqueIndex() {
        return this.uniqueIndex;
    }

    public <X> Type<X> getNestedType(int index) {
        return index > -1 && this.actualTypeArguments.length > index ? this.actualTypeArguments[index] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type<?> getSuperType() {
        if (this.superType == null) {
            Type type = this;
            synchronized (type) {
                if (this.superType == null) {
                    this.superType = this.resolveGenericAncestor(this.rawType.getGenericSuperclass());
                }
            }
        }
        return this.superType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type<?>[] getInterfaces() {
        if (this.interfaces == null) {
            Type type = this;
            synchronized (type) {
                if (this.interfaces == null) {
                    Type[] interfaces = new Type[this.rawType.getGenericInterfaces().length];
                    int i = 0;
                    for (java.lang.reflect.Type interfaceType : this.rawType.getGenericInterfaces()) {
                        interfaces[i++] = this.resolveGenericAncestor(interfaceType);
                    }
                    this.interfaces = interfaces;
                }
            }
        }
        return this.interfaces;
    }

    @Override
    public java.lang.reflect.Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    public java.lang.reflect.Type getTypeByVariable(TypeVariable<?> typeVariable) {
        if (this.isParameterized) {
            return this.typesByVariable.get(typeVariable.getName());
        }
        return null;
    }

    @Override
    public Class<T> getRawType() {
        return this.rawType;
    }

    public Type<?> getComponentType() {
        if (this.componentType == null) {
            if (this.rawType.isArray()) {
                this.componentType = TypeFactory.valueOf(this.rawType.getComponentType());
            } else if (this.isParameterized) {
                this.componentType = this.getNestedType(0);
            }
        }
        return this.componentType;
    }

    @Override
    public java.lang.reflect.Type getOwnerType() {
        throw new UnsupportedOperationException();
    }

    public String getSimpleName() {
        return this.rawType.getSimpleName();
    }

    public String getName() {
        return this.rawType.getName();
    }

    public String getCanonicalName() {
        return this.rawType.getCanonicalName();
    }

    public boolean isAssignableFrom(Type<?> other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!((Class)this.getRawType()).isAssignableFrom((Class<?>)other.getRawType())) {
            return false;
        }
        if (!this.isParameterized && other.isParameterized) {
            return true;
        }
        if (this.rawType.equals(Enum.class) && other.isEnum()) {
            return true;
        }
        Type<?> sp = other.getSuperType();
        if (sp.getRawType() != Object.class && this.isAssignableFrom(sp)) {
            return true;
        }
        if (this.getRawType() != Object.class) {
            for (Type<?> superInterface : other.getInterfaces()) {
                if (!this.isAssignableFrom(superInterface)) continue;
                return true;
            }
        }
        if (this.getActualTypeArguments().length != other.getActualTypeArguments().length) {
            return false;
        }
        java.lang.reflect.Type[] thisTypes = this.getActualTypeArguments();
        java.lang.reflect.Type[] thatTypes = other.getActualTypeArguments();
        int total = thisTypes.length;
        for (int i = 0; i < total; ++i) {
            Type thisType = (Type)thisTypes[i];
            Type thatType = (Type)thatTypes[i];
            if (thisType.isAssignableFrom(thatType)) continue;
            return false;
        }
        return true;
    }

    public boolean isAssignableFrom(Class<?> other) {
        if (other == null) {
            return false;
        }
        if (this.isParameterized()) {
            return false;
        }
        return ((Class)this.getRawType()).isAssignableFrom(other);
    }

    public boolean isEnum() {
        return ((Class)this.getRawType()).isEnum() || Enum.class.equals((Object)this.getRawType());
    }

    public boolean isArray() {
        return ((Class)this.getRawType()).isArray();
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom((Class<?>)this.getRawType());
    }

    public boolean isList() {
        return List.class.isAssignableFrom((Class<?>)this.getRawType());
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom((Class<?>)this.getRawType());
    }

    public boolean isMultiOccurrence() {
        return this.isMap() || this.isCollection() || this.isArray();
    }

    public boolean isString() {
        return String.class.isAssignableFrom((Class<?>)this.getRawType());
    }

    public boolean isPrimitive() {
        return ((Class)this.getRawType()).isPrimitive();
    }

    public boolean isPrimitiveWrapper() {
        return PRIMITIVE_WRAPPER_TYPES.contains(this.getRawType());
    }

    public boolean isWrapperFor(Type<?> primitive) {
        return primitive != null && this.isPrimitiveWrapper() && ClassUtil.getPrimitiveType(this.rawType).equals(primitive.getRawType());
    }

    public boolean isPrimitiveFor(Type<?> wrapper) {
        return wrapper != null && this.isPrimitive() && ClassUtil.getPrimitiveType(wrapper.rawType).equals(this.getRawType());
    }

    public boolean isImmutable() {
        return this.isPrimitive() || IMMUTABLE_WRAPPER_TYPES.contains(this.getRawType()) || this.isEnum();
    }

    public boolean isConcrete() {
        return !this.isInterface() && (this.isPrimitive() || this.isArray() || this.isAbstract());
    }

    private boolean isAbstract() {
        return !Modifier.isAbstract(((Class)this.getRawType()).getModifiers());
    }

    private boolean isInterface() {
        return ((Class)this.getRawType()).isInterface();
    }

    public Type<?> getWrapperType() {
        if (!this.rawType.isPrimitive()) {
            throw new IllegalStateException(this.rawType + " is not primitive");
        }
        return TypeFactory.valueOf(ClassUtil.getWrapperType(this.rawType));
    }

    public Type<?> findAncestor(Class<?> ancestor) {
        if (ancestor.isInterface()) {
            return this.findInterface(ancestor);
        }
        if (this.getRawType().equals(ancestor)) {
            return this;
        }
        if (!TypeFactory.TYPE_OF_OBJECT.equals(this)) {
            return this.getSuperType().findAncestor(ancestor);
        }
        return null;
    }

    private Type<?> findInterface(Class<?> theInterface) {
        Type theInterfaceType = null;
        LinkedList types = new LinkedList();
        types.add(this);
        while (theInterfaceType == null && !types.isEmpty()) {
            Type currentType = (Type)types.removeFirst();
            if (theInterface.equals(currentType.getRawType())) {
                theInterfaceType = currentType;
                continue;
            }
            if (currentType.equals(TypeFactory.TYPE_OF_OBJECT)) continue;
            types.addAll(Arrays.asList(currentType.getInterfaces()));
            types.add(currentType.getSuperType());
        }
        return theInterfaceType;
    }

    public Type<?> findInterface(Type<?> theInterface) {
        return this.findInterface(theInterface.rawType);
    }

    public Type<?> getPrimitiveType() {
        if (!this.isPrimitiveWrapper()) {
            throw new IllegalStateException(this.rawType + " is not a primitive wrapper");
        }
        return TypeFactory.valueOf(ClassUtil.getPrimitiveType(this.rawType));
    }

    public boolean isConvertibleFromString() {
        Class<?> rawType = this.getRawType();
        if (this.isPrimitive()) {
            rawType = ClassUtil.getWrapperType(rawType);
        }
        try {
            rawType.getMethod("valueOf", String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder stringValue = new StringBuilder();
        if (this.rawType.isAnonymousClass()) {
            this.rawType.getName();
        } else {
            stringValue.append(this.rawType.getSimpleName());
        }
        if (this.actualTypeArguments.length > 0) {
            stringValue.append("<");
            for (Type<?> arg : this.actualTypeArguments) {
                stringValue.append("" + arg + ", ");
            }
            stringValue.setLength(stringValue.length() - 2);
            stringValue.append(">");
        }
        return stringValue.toString();
    }

    public String toFullyQualifiedString() {
        StringBuilder stringValue = new StringBuilder();
        stringValue.append(this.rawType.getCanonicalName());
        if (this.actualTypeArguments.length > 0) {
            stringValue.append("<");
            for (Type<?> arg : this.actualTypeArguments) {
                stringValue.append("" + arg + ", ");
            }
            stringValue.setLength(stringValue.length() - 2);
            stringValue.append(">");
        }
        return stringValue.toString();
    }

    public int hashCode() {
        return this.uniqueIndex;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        return this.key.equals(other.key);
    }

    @Override
    public int compareTo(Type<?> other) {
        if (this.equals(other)) {
            return 0;
        }
        String thisChain = this.buildClassInheritanceChain(this).toString();
        String otherChain = this.buildClassInheritanceChain(other).toString();
        return thisChain.compareTo(otherChain);
    }

    private StringBuilder buildClassInheritanceChain(Type<?> type) {
        if (type.equals(TypeFactory.TYPE_OF_OBJECT)) {
            return new StringBuilder("/java.lang.Object");
        }
        return this.buildClassInheritanceChain(type.getSuperType()).append('/').append(type.getName());
    }

    static {
        HashSet<Class> tmpPrimitiveWrapperTypes = new HashSet<Class>();
        tmpPrimitiveWrapperTypes.add(Byte.class);
        tmpPrimitiveWrapperTypes.add(Short.class);
        tmpPrimitiveWrapperTypes.add(Integer.class);
        tmpPrimitiveWrapperTypes.add(Long.class);
        tmpPrimitiveWrapperTypes.add(Boolean.class);
        tmpPrimitiveWrapperTypes.add(Character.class);
        tmpPrimitiveWrapperTypes.add(Float.class);
        tmpPrimitiveWrapperTypes.add(Double.class);
        PRIMITIVE_WRAPPER_TYPES = Collections.unmodifiableSet(tmpPrimitiveWrapperTypes);
        HashSet tmpImmutableWrapperTypes = new HashSet();
        tmpImmutableWrapperTypes.addAll(PRIMITIVE_WRAPPER_TYPES);
        tmpImmutableWrapperTypes.add(String.class);
        tmpImmutableWrapperTypes.add(BigDecimal.class);
        tmpImmutableWrapperTypes.add(Byte.TYPE);
        tmpImmutableWrapperTypes.add(Short.TYPE);
        tmpImmutableWrapperTypes.add(Integer.TYPE);
        tmpImmutableWrapperTypes.add(Long.TYPE);
        tmpImmutableWrapperTypes.add(Boolean.TYPE);
        tmpImmutableWrapperTypes.add(Character.TYPE);
        tmpImmutableWrapperTypes.add(Float.TYPE);
        tmpImmutableWrapperTypes.add(Double.TYPE);
        IMMUTABLE_WRAPPER_TYPES = Collections.unmodifiableSet(tmpImmutableWrapperTypes);
    }
}

