/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.property;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.PropertyNotFoundException;
import ma.glasnost.orika.constructor.ConstructorParameterResolver;
import ma.glasnost.orika.metadata.ArrayElementProperty;
import ma.glasnost.orika.metadata.ListElementProperty;
import ma.glasnost.orika.metadata.MapKeyProperty;
import ma.glasnost.orika.metadata.NestedElementProperty;
import ma.glasnost.orika.metadata.NestedProperty;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.property.PropertyResolverStrategy;

public abstract class PropertyResolver
implements PropertyResolverStrategy {
    public static final String ELEMENT_PROPERT_PREFIX = "{";
    public static final String ELEMENT_PROPERT_SUFFIX = "}";
    private final boolean includePublicFields;
    private final Map<java.lang.reflect.Type, Map<String, Property>> propertiesCache = new ConcurrentHashMap<java.lang.reflect.Type, Map<String, Property>>();
    private final Map<java.lang.reflect.Type, Map<String, Property>> inlinePropertiesCache = new ConcurrentHashMap<java.lang.reflect.Type, Map<String, Property>>();
    private final ConstructorParameterResolver constructorParamResolver = new ConstructorParameterResolver();
    private static final String DYNAMIC_PROPERTY_CHARACTERS = "[\\w.='\"\\|\\%,\\(\\)\\$\\<\\> ]+";
    private static final String NESTED_PROPERTY_SPLITTER = "(?!\\:\\{[\\w.='\"\\|\\%,\\(\\)\\$\\<\\> ]+)[.](?![\\w.='\"\\|\\%,\\(\\)\\$\\<\\> ]+\\})";
    private static final String ELEMENT_PROPERTY_SPLITTER = "(?!\\:\\{[\\w.='\"\\|\\%,\\(\\)\\$\\<\\> ]+)\\{";
    private static final Pattern INLINE_PROPERTY_PATTERN = Pattern.compile("([\\w]+)\\:\\{(?:\\s*([\\w\\(\\)'\\\"\\% ]+))?\\s*(?:\\|\\s*([\\w\\(\\)'\\\"\\%, ]+)\\s*)?(?:\\|?\\s*(?:type=)([\\w.\\$ \\<\\>]+))?\\}");

    public PropertyResolver(boolean includePublicFields) {
        this.includePublicFields = includePublicFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Property> getProperties(java.lang.reflect.Type theType) {
        Map<String, Property> properties = this.propertiesCache.get(theType);
        if (properties == null) {
            java.lang.reflect.Type type = theType;
            synchronized (type) {
                properties = this.propertiesCache.get(theType);
                if (properties == null) {
                    Type referenceType;
                    properties = new LinkedHashMap<String, Property>();
                    if (theType instanceof Type) {
                        referenceType = (Type)theType;
                    } else if (theType instanceof Class) {
                        referenceType = TypeFactory.valueOf((Class)theType);
                    } else {
                        throw new IllegalArgumentException("type " + theType + " not supported.");
                    }
                    LinkedList<java.lang.reflect.Type> types = new LinkedList<java.lang.reflect.Type>();
                    types.addFirst(referenceType.getRawType());
                    while (!types.isEmpty()) {
                        Class type2 = (Class)types.removeFirst();
                        this.collectProperties(type2, referenceType, properties);
                        if (type2.getSuperclass() != null && !Object.class.equals(type2.getSuperclass())) {
                            types.add(type2.getSuperclass());
                        }
                        List<Class<?>> interfaces = Arrays.asList(type2.getInterfaces());
                        types.addAll(interfaces);
                    }
                    if (this.includePublicFields) {
                        this.collectPublicFieldProperties(referenceType, properties);
                    }
                    this.propertiesCache.put(theType, Collections.unmodifiableMap(properties));
                }
            }
        }
        return properties;
    }

    private Type<?> resolveGenericType(java.lang.reflect.Type genericType, Class<?> owningType, Type<?> referenceType) {
        Type resolvedType = null;
        Type<?> reference = referenceType;
        do {
            Type<?> referenceInterface = null;
            if (genericType instanceof TypeVariable) {
                if (reference.isParameterized()) {
                    java.lang.reflect.Type t = reference.getTypeByVariable((TypeVariable)genericType);
                    if (t != null) {
                        resolvedType = TypeFactory.valueOf(t);
                    }
                } else if (this.hasTypeParameters(owningType) && owningType.isInterface()) {
                    referenceInterface = reference.findInterface(TypeFactory.valueOf(owningType));
                }
            } else if (genericType instanceof ParameterizedType) {
                if (reference.isSelfOrAncestorParameterized()) {
                    resolvedType = TypeFactory.resolveValueOf((ParameterizedType)genericType, reference);
                } else if (this.hasTypeParameters(owningType) && owningType.isInterface()) {
                    referenceInterface = reference.findInterface(TypeFactory.valueOf(owningType));
                } else {
                    resolvedType = TypeFactory.valueOf((ParameterizedType)genericType);
                }
            }
            Type<?> type = reference = referenceInterface != null ? referenceInterface : reference.getSuperType();
        } while (resolvedType == null && reference != TypeFactory.TYPE_OF_OBJECT);
        return resolvedType;
    }

    protected String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private Class<?> resolveRawPropertyType(Class<?> rawType, Method readMethod) {
        try {
            return readMethod == null ? rawType : readMethod.getDeclaringClass().getDeclaredMethod(readMethod.getName(), new Class[0]).getReturnType();
        }
        catch (Exception e) {
            return rawType;
        }
    }

    protected Property processProperty(String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, Class<?> owningType, Type<?> referenceType, Map<String, Property> properties) {
        Property.Builder builder = new Property.Builder();
        Property property = null;
        builder.expression(propertyName);
        builder.name(propertyName);
        if (readMethod != null) {
            builder.getter(readMethod.getName() + "()");
        }
        if (writeMethod != null) {
            builder.setter(writeMethod.getName() + "(%s)");
        }
        if (readMethod != null || writeMethod != null) {
            builder.type(this.resolvePropertyType(readMethod, propertyType, owningType, referenceType));
            property = builder.build(this);
            Property existing = properties.get(propertyName);
            if (existing == null) {
                properties.put(propertyName, property);
            } else if (existing.getType().isAssignableFrom(property.getType())) {
                property = builder.merge(existing).build(this);
                properties.put(propertyName, property);
            }
        }
        return property;
    }

    protected boolean hasTypeParameters(Class<?> type) {
        boolean hasTypeParams = false;
        if (type.getTypeParameters().length > 0) {
            hasTypeParams = true;
        } else if (type.getGenericSuperclass() instanceof ParameterizedType) {
            hasTypeParams = true;
        } else {
            for (java.lang.reflect.Type anInterface : type.getGenericInterfaces()) {
                if (!(anInterface instanceof ParameterizedType)) continue;
                hasTypeParams = true;
                break;
            }
        }
        return hasTypeParams;
    }

    public Type<?> resolvePropertyType(Method readMethod, Class<?> rawType, Class<?> owningType, Type<?> referenceType) {
        rawType = this.resolveRawPropertyType(rawType, readMethod);
        Type<?> resolvedGenericType = null;
        if ((referenceType.isParameterized() || this.hasTypeParameters(owningType) || this.hasTypeParameters(rawType)) && readMethod != null) {
            try {
                resolvedGenericType = this.resolveGenericType(readMethod.getDeclaringClass().getDeclaredMethod(readMethod.getName(), new Class[0]).getGenericReturnType(), owningType, referenceType);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("readMethod does not exist", e);
            }
        }
        if (resolvedGenericType == null || resolvedGenericType.isAssignableFrom(rawType)) {
            resolvedGenericType = TypeFactory.valueOf(rawType);
        }
        return resolvedGenericType;
    }

    protected void collectPublicFieldProperties(Type<?> referenceType, Map<String, Property> properties) {
        for (Field f : ((Class)referenceType.getRawType()).getFields()) {
            Property existing;
            if (Modifier.isStatic(f.getModifiers())) continue;
            Property.Builder builder = new Property.Builder();
            builder.expression(f.getName());
            builder.name(f.getName());
            Class<?> rawType = f.getType();
            Type<?> genericType = this.resolveGenericType(f.getGenericType(), f.getDeclaringClass(), referenceType);
            if (genericType != null && !genericType.isAssignableFrom(rawType)) {
                builder.type(genericType);
            } else {
                builder.type(TypeFactory.valueOf(rawType));
            }
            if (!Modifier.isFinal(f.getModifiers())) {
                builder.setter(f.getName() + " = %s");
            }
            if ((existing = properties.get(f.getName())) == null) {
                builder.getter(f.getName());
                properties.put(f.getName(), builder.build(this));
                continue;
            }
            if (existing.getSetter() != null) continue;
            builder.merge(existing);
            properties.put(f.getName(), builder.build(this));
        }
    }

    protected boolean isNestedPropertyExpression(String expression) {
        return expression.replaceAll("\\:\\{[\\w.='\"\\|\\%,\\(\\)\\$\\<\\> ]+\\}", "").indexOf(46) != -1;
    }

    protected boolean isElementPropertyExpression(String expression) {
        return expression.replaceAll("\\:\\{[\\w.='\"\\|\\%,\\(\\)\\$\\<\\> ]+\\}", "").indexOf(123) != -1;
    }

    protected boolean isIndividualElementExpression(String expression) {
        String normalized = expression.replaceAll("\\:\\{[\\w.='\"\\|\\%,\\(\\)\\$\\<\\> ]+\\}", "");
        return normalized.contains("[") && normalized.endsWith("]");
    }

    private boolean isSelfReferenceExpression(String expr) {
        return "".equals(expr);
    }

    protected String[] splitNestedProperty(String propertyName) {
        return propertyName.split(NESTED_PROPERTY_SPLITTER, 50);
    }

    protected String[] splitElementProperty(String propertyName) {
        return propertyName.split(ELEMENT_PROPERTY_SPLITTER, 2);
    }

    @Override
    public NestedProperty getNestedProperty(java.lang.reflect.Type type, String p) {
        return this.getNestedProperty(type, p, null);
    }

    protected NestedProperty getNestedProperty(java.lang.reflect.Type type, String p, Property owner) {
        Property property = null;
        Type<?> propertyType = type;
        ArrayList<Property> path = new ArrayList<Property>();
        StringBuilder expression = new StringBuilder();
        Property container = owner;
        if (p.indexOf(46) != -1) {
            String[] ps;
            try {
                ps = this.splitNestedProperty(p);
            }
            catch (StackOverflowError e) {
                System.out.println("p=" + p);
                throw e;
            }
            int i = 0;
            while (i < ps.length) {
                try {
                    property = this.getProperty(propertyType, ps[i], i < ps.length - 1, container);
                    propertyType = property.getType();
                    container = null;
                }
                catch (PropertyNotFoundException e) {
                    throw new PropertyNotFoundException("could not resolve nested property [" + p + "] on " + type + ", because " + e.getLocalizedMessage());
                }
                if (++i < ps.length) {
                    path.add(property);
                    expression.append(property.getExpression() + ".");
                    continue;
                }
                expression.append(property.getExpression());
            }
        }
        if (property == null) {
            throw new PropertyNotFoundException(p, type);
        }
        return new NestedProperty(expression.toString(), property, path.toArray(new Property[path.size()]));
    }

    public Property getElementProperty(java.lang.reflect.Type type, String p) {
        return this.getElementProperty(type, p, null);
    }

    public Property getElementProperty(java.lang.reflect.Type type, String p, Property owner) {
        Property elementProperty;
        String[] ps = this.splitElementProperty(p);
        String elementPropertyExpression = ps[1].substring(0, ps[1].length() - 1);
        Property owningProperty = owner != null ? (type.equals(owner.getType()) ? owner : this.getProperty(type, ps[0], false, owner)) : this.getProperty(type, ps[0]);
        if (owningProperty.isMap()) {
            Type elementType = MapEntry.concreteEntryType(owningProperty.getType());
            elementProperty = this.getProperty(elementType, elementPropertyExpression, false, owningProperty);
        } else if (owningProperty.isCollection()) {
            Type elementType = owningProperty.getType().getNestedType(0);
            elementProperty = this.getProperty(elementType, elementPropertyExpression, false, owningProperty);
        } else if (owningProperty.isArray()) {
            Type<?> elementType = owningProperty.getType().getComponentType();
            elementProperty = this.getProperty(elementType, elementPropertyExpression, false, owningProperty);
        } else {
            throw new IllegalArgumentException("'" + p + "' is not a valid element property for " + type);
        }
        return new NestedElementProperty(owningProperty, elementProperty, this);
    }

    public Property getIndividualElementProperty(java.lang.reflect.Type type, String p, Property owner) {
        Property elementProperty;
        String[] ps = p.split("\\[", 2);
        String elementPropertyExpression = ps[1].substring(0, ps[1].length() - 1);
        Property owningProperty = owner != null ? (type.equals(owner.getType()) ? owner : this.getProperty(type, ps[0], false, owner)) : this.getProperty(type, ps[0]);
        if (owningProperty.isMap()) {
            Type elementType = MapEntry.concreteEntryType(owningProperty.getType());
            String key = elementPropertyExpression.substring(1, elementPropertyExpression.length() - 1);
            elementProperty = new MapKeyProperty(key, elementType.getNestedType(0), elementType.getNestedType(1), null);
        } else if (owningProperty.isCollection()) {
            Type elementType = owningProperty.getType().getNestedType(0);
            try {
                int index = Integer.valueOf(elementPropertyExpression.replaceAll("[\\[\\]]", ""));
                elementProperty = new ListElementProperty(index, elementType, null);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("'" + p + "' is not a valid element property for " + type);
            }
        } else if (owningProperty.isArray()) {
            Type<?> elementType = owningProperty.getType().getComponentType();
            try {
                int index = Integer.valueOf(elementPropertyExpression);
                elementProperty = new ArrayElementProperty(index, elementType, null);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("'" + p + "' is not a valid element property for " + type);
            }
        } else {
            throw new IllegalArgumentException("'" + p + "' is not a valid element property for " + type);
        }
        if (!"".equals(owningProperty.getName())) {
            elementProperty = new NestedProperty(p, elementProperty, new Property[]{owningProperty});
        }
        return elementProperty;
    }

    @Override
    public Property getProperty(java.lang.reflect.Type type, String expr) {
        return this.getProperty(type, expr, false, null);
    }

    @Override
    public boolean existsProperty(java.lang.reflect.Type type, String expr) {
        try {
            return this.getProperty(type, expr) != null;
        }
        catch (PropertyNotFoundException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public Property getProperty(Property owner, String expr) {
        return this.getProperty(owner.getType(), expr, false, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Property getProperty(java.lang.reflect.Type type, String expr, boolean isNestedLookup, Property owner) throws MappingException {
        Property property = null;
        if (this.isSelfReferenceExpression(expr)) {
            property = new Property.Builder().name("").getter("").setter(" = %s").type(TypeFactory.valueOf(type)).container(owner).build(this);
        } else if (this.isNestedPropertyExpression(expr) && !this.isElementPropertyExpression(expr)) {
            property = this.getNestedProperty(type, expr, owner);
        } else if (this.isElementPropertyExpression(expr)) {
            property = this.getElementProperty(type, expr, owner);
        } else if (this.isIndividualElementExpression(expr)) {
            property = this.getIndividualElementProperty(type, expr, owner);
        } else {
            Map<String, Property> inlinePoperties = this.inlinePropertiesCache.get(type);
            if (inlinePoperties != null) {
                property = inlinePoperties.get(expr);
            }
            if (property == null) {
                Map<String, Property> properties = this.getProperties(type);
                if (properties.containsKey(expr)) {
                    property = properties.get(expr);
                } else if (this.isInlinePropertyExpression(expr)) {
                    property = this.resolveInlineProperty(type, expr);
                    java.lang.reflect.Type type2 = type;
                    synchronized (type2) {
                        if (inlinePoperties == null) {
                            inlinePoperties = new HashMap<String, Property>(1);
                            this.inlinePropertiesCache.put(type, inlinePoperties);
                        }
                        inlinePoperties.put(property.getName(), property);
                    }
                } else {
                    property = this.resolveConstructorProperty(type, expr);
                    if (property == null) {
                        throw new PropertyNotFoundException(expr, type);
                    }
                }
                if (owner != null) {
                    property = new Property.Builder().merge(property).container(owner).build();
                }
            }
        }
        return property;
    }

    private Property resolveConstructorProperty(java.lang.reflect.Type type, String expr) {
        Set<Property> prop = this.constructorParamResolver.getPossibleConstructorParams(type, expr);
        if (prop != null && !prop.isEmpty()) {
            return prop.iterator().next();
        }
        return null;
    }

    protected boolean isInlinePropertyExpression(String expression) {
        Matcher matcher = INLINE_PROPERTY_PATTERN.matcher(expression);
        return matcher.matches() && (matcher.group(2) != null || matcher.group(3) != null);
    }

    public Property resolveInlineProperty(java.lang.reflect.Type type, String expr) {
        Type theType = TypeFactory.valueOf(type);
        Matcher matcher = INLINE_PROPERTY_PATTERN.matcher(expr);
        if (matcher.matches()) {
            Property.Builder builder = new Property.Builder(theType, matcher.group(1));
            if (matcher.group(2) != null) {
                builder.getter(matcher.group(2));
            }
            if (matcher.group(3) != null) {
                builder.setter(matcher.group(3));
            }
            builder.type(matcher.group(4));
            return builder.build(this);
        }
        throw new IllegalArgumentException("'" + expr + "' is not a valid dynamic property expression");
    }

    protected abstract void collectProperties(Class<?> var1, Type<?> var2, Map<String, Property> var3);
}

