/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.util.Set;
import java.util.SortedMap;
import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.impl.DefaultConcreteTypeMap;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public class MultiOccurrenceVariableRef
extends VariableRef {
    private String iteratorName;
    private boolean iteratorDeclared;

    public static MultiOccurrenceVariableRef from(VariableRef r) {
        if (r.property() != null) {
            return new MultiOccurrenceVariableRef(r.property(), r.name);
        }
        return new MultiOccurrenceVariableRef(r.type(), r.name);
    }

    public MultiOccurrenceVariableRef(Property property, String name) {
        super(property, name);
    }

    public MultiOccurrenceVariableRef(Type<?> type, String name) {
        super(type, name);
    }

    public String declareIterator() {
        if (this.iteratorDeclared) {
            throw new IllegalStateException("Iterator has already been declared");
        }
        String iterator = this.isArray() ? "int " + this.getIteratorName() + " = -1" : (this.isMap() ? new EntrySetRef(this, this.name()).declareIterator() : "java.util.Iterator " + this.getIteratorName() + " = " + this.getter() + ".iterator()");
        this.iteratorDeclared = true;
        return iterator;
    }

    public String nextElement() {
        if (!this.iteratorDeclared) {
            throw new IllegalStateException("Iterator has not been declared");
        }
        String next = this.isArray() ? this.getter() + "[++" + this.getIteratorName() + "]" : this.getIteratorName() + ".next()";
        return next;
    }

    public VariableRef nextElementRef() {
        return new VariableRef(this.elementType(), this.nextElement());
    }

    public String iteratorHasNext() {
        if (!this.iteratorDeclared) {
            throw new IllegalStateException("Iterator has not been declared");
        }
        String hasNext = this.isArray() ? this.getIteratorName() + " < (" + this.getter() + ".length - 1)" : this.getIteratorName() + ".hasNext()";
        return hasNext;
    }

    public String notEmpty() {
        if (this.isArray()) {
            return this.getter() + ".length > 0";
        }
        return "!" + this.getter() + ".isEmpty()";
    }

    public String add(String value) {
        if (this.isArray()) {
            if (!this.iteratorDeclared) {
                throw new IllegalStateException("Iterator must be declared in order to add elements to destination array");
            }
            return this.getter() + "[++" + this.getIteratorName() + "] = " + value;
        }
        if (this.isMap()) {
            return this.getter() + ".put(" + value + ".getKey(), " + value + ".getValue())";
        }
        if (this.isCollection()) {
            return this.getter() + ".add(" + MultiOccurrenceVariableRef.cast(value, this.type().getNestedType(0)) + ")";
        }
        throw new IllegalArgumentException(this.type() + " does not support adding of elements");
    }

    public String add(VariableRef value) {
        if (this.isArray()) {
            if (!this.iteratorDeclared) {
                throw new IllegalStateException("Iterator must be declared in order to add elements to destination array");
            }
            return this.getter() + "[++" + this.getIteratorName() + "] = " + value;
        }
        if (this.isMap() && value.isMapEntry()) {
            return this.getter() + ".put(" + value + ".getKey(), " + value + ".getValue())";
        }
        if (this.isCollection()) {
            return this.getter() + ".add(" + MultiOccurrenceVariableRef.cast(value, this.type().getNestedType(0)) + ")";
        }
        throw new IllegalArgumentException(this.type() + " does not support adding elements of type " + value.type());
    }

    public String addAll(VariableRef value) {
        String assignment = this.addAllByAssign(value);
        return assignment != null ? assignment : this.addAllButNoAssign(value);
    }

    public String addAllButNoAssign(VariableRef value) {
        if (this.isMap() && value.isList()) {
            return String.format("listToMap(%s, %s)", value, this);
        }
        if (this.isCollection() && value.isArray()) {
            if (value.type().getComponentType().isPrimitive()) {
                return this.getter() + ".addAll(asList(" + value + "))";
            }
            return this.getter() + ".addAll(java.util.Arrays.asList(" + value + ")";
        }
        if (this.isMap() && value.isMap()) {
            return this.getter() + ".putAll(" + value + ")";
        }
        return this.getter() + ".addAll(" + value + ")";
    }

    public String collectionType() {
        String collection;
        if (this.isList()) {
            collection = "List";
        } else if (this.isSet()) {
            collection = "Set";
        } else if (this.isCollection()) {
            collection = "List";
        } else {
            throw new IllegalStateException(this.type() + " is not a collection type");
        }
        return collection;
    }

    public String newCollection() {
        return this.newInstance("");
    }

    public String newInstance(String sizeExpr) {
        if (this.isArray()) {
            return "new " + this.rawType().getComponentType().getCanonicalName() + "[" + sizeExpr + "]";
        }
        if (this.type().isConcrete()) {
            return this.newInstance((Class<?>)this.type().getRawType());
        }
        return this.newInstance(DefaultConcreteTypeMap.get(this.type().getRawType()));
    }

    public String newMap() {
        if (SortedMap.class.isAssignableFrom(this.rawType())) {
            return "new java.util.TreeMap()";
        }
        return "new java.util.LinkedHashMap()";
    }

    @Override
    public String size() {
        return this.getter() + "." + (this.rawType().isArray() ? "length" : "size()");
    }

    private String addAllByAssign(VariableRef value) {
        if (this.isArray() && value.isCollection()) {
            if (this.type().getComponentType().isPrimitive()) {
                return this.assign("%sArray(%s)", this.type().getComponentType().getCanonicalName(), value);
            }
            return this.assign("listToArray(%s, %s.class)", value, this.type().getCanonicalName());
        }
        if (this.isMap() && value.isList() && this.isAssignable()) {
            return this.assign("listToMap(%s, java.util.LinkedHashMap.class)", value);
        }
        return null;
    }

    private String getIteratorName() {
        if (this.iteratorName == null) {
            String prefix = this.name();
            if (this.property() != null && this.property().getName().matches("[\\w$]+")) {
                prefix = this.property().getName();
            }
            if ("".equals(prefix) && !"".equals(this.name)) {
                prefix = this.name;
            }
            this.iteratorName = this.isArray() ? prefix + "_$_index" : prefix + "_$_iter";
        }
        return this.iteratorName;
    }

    private String newInstance(Class<?> type) {
        try {
            if (type.getConstructor(new Class[0]) != null) {
                return "new " + type.getCanonicalName() + "()";
            }
            throw new IllegalStateException(type + " constructor is null");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(type + " has no default constructor");
        }
        catch (SecurityException e) {
            throw new IllegalStateException(type + " cannot be instanced");
        }
    }

    private static class EntrySetRef
    extends MultiOccurrenceVariableRef {
        private String name;

        public EntrySetRef(VariableRef sourceMap, String variableName) {
            super(EntrySetRef.getSourceEntryType(sourceMap), sourceMap + ".entrySet()");
            this.name = variableName;
        }

        private static Type<?> getSourceEntryType(VariableRef sourceMap) {
            return TypeFactory.valueOf(Set.class, MapEntry.entryType(sourceMap.type()));
        }

        @Override
        public String name() {
            if (this.name != null) {
                return this.name;
            }
            return super.name();
        }
    }
}

