/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.TreeMap;
import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.impl.generator.MultiOccurrenceVariableRef;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.util.StringUtil;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public class Node {
    public final Node parent;
    private final boolean isSource;
    public final Property property;
    public final FieldMap value;
    public final NodeList children;
    public MultiOccurrenceVariableRef multiOccurrenceVar;
    public MultiOccurrenceVariableRef newDestination;
    public VariableRef elementRef;
    public VariableRef nullCheckFlag;
    public VariableRef shouldAddToCollectorFlag;
    public boolean addedToCollector;

    private Node(Property property, FieldMap fieldMap, Node parent, NodeList nodes, boolean isSource, int uniqueIndex) {
        this.isSource = isSource;
        String name = isSource ? "source" : "destination";
        String propertySuffix = StringUtil.capitalize(property.getName());
        this.value = fieldMap;
        this.parent = parent;
        this.property = property;
        if (property.isMultiOccurrence()) {
            Type<?> elementType = this.buildElementType(property, isSource);
            Type<?> destinationType = this.buildDestinationType(property, elementType);
            this.newDestination = new MultiOccurrenceVariableRef(destinationType, "new_" + name + propertySuffix + uniqueIndex);
            String multiOccurrenceName = parent != null ? this.name(parent.elementRef.name(), name + propertySuffix) : name;
            this.multiOccurrenceVar = new MultiOccurrenceVariableRef(property, multiOccurrenceName);
            this.elementRef = new VariableRef(elementType, property.getName() + "_" + name + uniqueIndex + "Element");
            if (elementType != null && elementType.isPrimitive()) {
                this.nullCheckFlag = new VariableRef(TypeFactory.valueOf(Boolean.TYPE), property.getName() + "_" + name + uniqueIndex + "ElementIsNull");
            }
            this.shouldAddToCollectorFlag = new VariableRef(TypeFactory.valueOf(Boolean.TYPE), property.getName() + "_" + name + uniqueIndex + "ElementShouldBeAddedToCollector");
        }
        if (nodes != null) {
            nodes.add(this);
            this.children = new NodeList(nodes);
        } else if (parent != null) {
            parent.children.add(this);
            this.children = new NodeList(parent.children);
        } else {
            this.children = new NodeList();
        }
    }

    private Type<?> primitiveSafeListType(Type<?> type) {
        if (type.isPrimitive()) {
            return type.getWrapperType();
        }
        return type;
    }

    private Node(Property property, Node parent, boolean isSource, int uniqueIndex) {
        this(property, null, parent, null, isSource, uniqueIndex);
    }

    private Node(Property property, FieldMap fieldMap, Node parent, boolean isSource, int uniqueIndex) {
        this(property, fieldMap, parent, null, isSource, uniqueIndex);
    }

    private Node(Property property, FieldMap fieldMap, NodeList nodes, boolean isSource, int uniqueIndex) {
        this(property, fieldMap, null, nodes, isSource, uniqueIndex);
    }

    private String name(String value1, String defaultValue) {
        if (value1 != null && !"".equals(value1)) {
            return value1;
        }
        return defaultValue;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public FieldMap getMap() {
        TreeMap<Integer, FieldMap> nodes = new TreeMap<Integer, FieldMap>();
        for (Node child : this.children) {
            Property prop;
            if (child.value == null) continue;
            int depth = 0;
            FieldMap value = child.value;
            Property property = prop = this.isSource ? value.getSource() : value.getDestination();
            while (prop.getContainer() != null) {
                ++depth;
                prop = prop.getContainer();
            }
            if (nodes.containsKey(depth)) continue;
            nodes.put(depth, value);
        }
        if (!nodes.isEmpty()) {
            return (FieldMap)nodes.get(nodes.firstKey());
        }
        return null;
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String indent) {
        StringBuilder out = new StringBuilder();
        out.append(indent + this.property.toString());
        if (!this.children.isEmpty()) {
            out.append(" {");
            for (Node child : this.children) {
                out.append("\n" + child.toString("  " + indent));
            }
            out.append("\n" + indent + "}");
        }
        return out.toString();
    }

    public static Node findFieldMap(FieldMap map, NodeList nodes, boolean useSource) {
        Property container;
        LinkedList<Property> path = new LinkedList<Property>();
        Property property = container = useSource ? map.getSource() : map.getDestination();
        while (container.getContainer() != null) {
            path.addFirst(container.getContainer());
            container = container.getContainer();
        }
        Node currentNode = null;
        NodeList children = nodes;
        for (Property pathElement : path) {
            currentNode = null;
            for (Node node : children) {
                if (!node.property.equals(pathElement)) continue;
                currentNode = node;
                children = currentNode.children;
                break;
            }
            if (currentNode != null) continue;
            return null;
        }
        for (Node node : children) {
            if (!map.equals(node.value)) continue;
            return node;
        }
        return null;
    }

    private Type<?> buildElementType(Property property, boolean isSource) {
        Type<Object> elementType = null;
        if (property.isMap()) {
            if (isSource) {
                Type entryType = MapEntry.entryType(property.getType());
                elementType = entryType;
            } else {
                Type entryType = MapEntry.concreteEntryType(property.getType());
                elementType = entryType;
            }
        } else if (property.isCollection()) {
            elementType = property.getElementType();
        } else if (property.isArray()) {
            elementType = property.getType().getComponentType();
        }
        return elementType;
    }

    private Type<?> buildDestinationType(Property property, Type<?> elementType) {
        if (property.getType().isArray()) {
            return TypeFactory.valueOf(ArrayList.class, this.primitiveSafeListType(property.getType().getComponentType()));
        }
        if (property.getType().isMap()) {
            return TypeFactory.valueOf(ArrayList.class, elementType);
        }
        return property.getType();
    }

    public static class NodeList
    extends ArrayList<Node> {
        private static final long serialVersionUID = 1L;
        private int totalNodes = 0;
        private final NodeList parent;

        public NodeList() {
            this.parent = null;
        }

        private NodeList(NodeList parent) {
            this.parent = parent;
        }

        public Node addFieldMap(FieldMap map, boolean useSource) {
            Property root;
            LinkedList<Property> path = new LinkedList<Property>();
            Property container = root = useSource ? map.getSource() : map.getDestination();
            while (container.getContainer() != null) {
                path.addFirst(container.getContainer());
                container = container.getContainer();
            }
            Node currentNode = null;
            Node parentNode = null;
            NodeList children = this;
            int len = path.size();
            for (int p = 0; p < len; ++p) {
                Property pathElement = (Property)path.get(p);
                for (Node node : children) {
                    if (!node.property.equals(pathElement)) continue;
                    currentNode = node;
                    children = currentNode.children;
                    break;
                }
                if (currentNode == null) {
                    currentNode = new Node(pathElement, parentNode, useSource, this.totalNodes);
                    if (parentNode == null) {
                        children.add(currentNode);
                    }
                    parentNode = currentNode;
                    ++p;
                    while (p < len) {
                        parentNode = currentNode = new Node((Property)path.get(p), parentNode, useSource, this.totalNodes);
                        ++p;
                    }
                    continue;
                }
                parentNode = currentNode;
                currentNode = null;
            }
            if (parentNode == null) {
                root = this.innermostElement(root);
                currentNode = new Node(root, map, this, useSource, this.totalNodes);
            } else {
                root = this.innermostElement(root);
                currentNode = new Node(root, map, parentNode, useSource, this.totalNodes);
            }
            return currentNode;
        }

        private Property innermostElement(Property p) {
            Property result = p;
            while (result.getElement() != null) {
                result = result.getElement();
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("{");
            if (!this.isEmpty()) {
                for (Node node : this) {
                    out.append("\n" + node.toString("  "));
                }
                out.append("\n}");
            } else {
                out.append("}");
            }
            return out.toString();
        }

        private void incrementTotalNodes() {
            if (this.parent != null) {
                this.parent.incrementTotalNodes();
            }
            ++this.totalNodes;
        }

        @Override
        public boolean add(Node node) {
            this.incrementTotalNodes();
            return super.add(node);
        }
    }
}

