/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.ClassMapBuilderFactory;
import ma.glasnost.orika.metadata.MappingDirection;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.property.PropertyResolverStrategy;

public class CaseInsensitiveClassMapBuilder<A, B>
extends ClassMapBuilder<A, B> {
    private Map<String, String> lowercasePropertiesForA = new LinkedHashMap<String, String>();
    private Map<String, String> lowercasePropertiesForB;
    private boolean initialized;

    protected CaseInsensitiveClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults) {
        super(aType, bType, mapperFactory, propertyResolver, defaults);
        for (String prop : this.getPropertyExpressions(this.getAType()).keySet()) {
            this.lowercasePropertiesForA.put(prop.toLowerCase(), prop);
        }
        this.lowercasePropertiesForB = new LinkedHashMap<String, String>();
        for (String prop : this.getPropertyExpressions(this.getBType()).keySet()) {
            this.lowercasePropertiesForB.put(prop.toLowerCase(), prop);
        }
        this.initialized = true;
    }

    @Override
    public ClassMapBuilder<A, B> byDefault(MappingDirection direction, DefaultFieldMapper ... withDefaults) {
        super.byDefault(direction, withDefaults);
        DefaultFieldMapper[] defaults = withDefaults.length == 0 ? this.getDefaultFieldMappers() : withDefaults;
        for (Map.Entry<String, String> entry : this.lowercasePropertiesForA.entrySet()) {
            String propertyNameA = entry.getValue();
            String lowercaseName = entry.getKey();
            if (this.getMappedPropertiesForTypeA().contains(propertyNameA)) continue;
            if (this.lowercasePropertiesForB.containsKey(lowercaseName)) {
                String propertyNameB = this.lowercasePropertiesForB.get(lowercaseName);
                if (this.getMappedPropertiesForTypeB().contains(propertyNameB) || propertyNameA.equals("class")) continue;
                this.fieldMap(propertyNameA, propertyNameB, true).direction(direction).add();
                continue;
            }
            Property prop = this.resolvePropertyForA(propertyNameA);
            for (DefaultFieldMapper defaulter : defaults) {
                String suggestion = defaulter.suggestMappedField(propertyNameA, prop.getType());
                if (suggestion == null || !this.getPropertiesForTypeB().contains(suggestion) || this.getMappedPropertiesForTypeB().contains(suggestion)) continue;
                this.fieldMap(propertyNameA, suggestion, true).direction(direction).add();
            }
        }
        return this;
    }

    @Override
    protected Property resolveProperty(java.lang.reflect.Type type, String expr) {
        Map<String, String> lowercaseProps;
        String resolvedExpression;
        String expression = expr;
        if (this.initialized && (resolvedExpression = (lowercaseProps = type.equals(this.getAType()) ? this.lowercasePropertiesForA : this.lowercasePropertiesForB).get(expr.toLowerCase())) != null) {
            expression = resolvedExpression;
        }
        return super.resolveProperty(type, expression);
    }

    public static class Factory
    extends ClassMapBuilderFactory {
        @Override
        protected <A, B> ClassMapBuilder<A, B> newClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults) {
            return new CaseInsensitiveClassMapBuilder<A, B>(aType, bType, mapperFactory, propertyResolver, defaults);
        }
    }
}

