/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.time;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public abstract class AbstractTemporalAccessorParsingProcessor<T extends TemporalAccessor>
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final DateTimeFormatter formatter;

    public AbstractTemporalAccessorParsingProcessor() {
        this.formatter = null;
    }

    public AbstractTemporalAccessorParsingProcessor(CellProcessor next) {
        super(next);
        this.formatter = null;
    }

    public AbstractTemporalAccessorParsingProcessor(DateTimeFormatter formatter) {
        AbstractTemporalAccessorParsingProcessor.checkPreconditions(formatter);
        this.formatter = formatter;
    }

    public AbstractTemporalAccessorParsingProcessor(DateTimeFormatter formatter, CellProcessor next) {
        super(next);
        AbstractTemporalAccessorParsingProcessor.checkPreconditions(formatter);
        this.formatter = formatter;
    }

    private static void checkPreconditions(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter should not be null");
    }

    public Object execute(Object value, CsvContext context) {
        T result;
        this.validateInputNotNull(value, context);
        if (!(value instanceof String)) {
            throw new SuperCsvCellProcessorException(String.class, value, context, (CellProcessor)this);
        }
        String string = (String)value;
        try {
            result = this.formatter != null ? this.parse(string, this.formatter) : this.parse(string);
        }
        catch (DateTimeParseException e) {
            throw new SuperCsvCellProcessorException("Failed to parse value", context, (CellProcessor)this, (Throwable)e);
        }
        return this.next.execute(result, context);
    }

    protected abstract T parse(String var1);

    protected abstract T parse(String var1, DateTimeFormatter var2);
}

