/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.entry.ServerSearchResult;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.util.EmptyEnumeration;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEntryUtils {
    public static Attribute toBasicAttribute(ServerAttribute entryAttribute) {
        AttributeType attributeType = entryAttribute.getAttributeType();
        BasicAttribute attribute = new BasicAttribute(attributeType.getName());
        Iterator i$ = entryAttribute.iterator();
        while (i$.hasNext()) {
            Value value = (Value)i$.next();
            attribute.add(value.get());
        }
        return attribute;
    }

    public static Attributes toBasicAttributes(ServerEntry entry) {
        if (entry == null) {
            return null;
        }
        BasicAttributes attributes = new BasicAttributes(true);
        for (AttributeType attributeType : entry.getAttributeTypes()) {
            EntryAttribute attr = entry.get(attributeType);
            if (attributeType.getOid().equals("2.5.4.0") && attr.size() == 0) continue;
            attributes.put(ServerEntryUtils.toBasicAttribute((ServerAttribute)attr));
        }
        return attributes;
    }

    public static ServerAttribute toServerAttribute(Attribute attribute, AttributeType attributeType) {
        if (attribute == null) {
            return null;
        }
        try {
            DefaultServerAttribute serverAttribute = new DefaultServerAttribute(attributeType);
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                if (value == null) continue;
                if (serverAttribute.isHR()) {
                    if (value instanceof String) {
                        serverAttribute.add(new String[]{(String)value});
                        continue;
                    }
                    if (value instanceof byte[]) {
                        serverAttribute.add(new String[]{StringTools.utf8ToString((byte[])((byte[])value))});
                        continue;
                    }
                    return null;
                }
                if (value instanceof String) {
                    serverAttribute.add(new byte[][]{StringTools.getBytesUtf8((String)((String)value))});
                    continue;
                }
                if (value instanceof byte[]) {
                    serverAttribute.add(new byte[][]{(byte[])value});
                    continue;
                }
                return null;
            }
            return serverAttribute;
        }
        catch (NamingException ne) {
            return null;
        }
    }

    public static ServerEntry toServerEntry(Attributes attributes, LdapDN dn, Registries registries) throws InvalidAttributeIdentifierException {
        if (attributes instanceof BasicAttributes) {
            try {
                DefaultServerEntry entry = new DefaultServerEntry(registries, dn);
                NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
                while (attrs.hasMoreElements()) {
                    Attribute attr = (Attribute)attrs.nextElement();
                    String attributeId = attr.getID();
                    String id = SchemaUtils.stripOptions((String)attributeId);
                    Set options = SchemaUtils.getOptions((String)attributeId);
                    AttributeType attributeType = registries.getAttributeTypeRegistry().lookup(id);
                    ServerAttribute serverAttribute = ServerEntryUtils.toServerAttribute(attr, attributeType);
                    if (serverAttribute == null) continue;
                    entry.put(new EntryAttribute[]{serverAttribute});
                }
                return entry;
            }
            catch (NamingException ne) {
                throw new InvalidAttributeIdentifierException(ne.getMessage());
            }
        }
        return null;
    }

    public static ServerEntry getTargetEntry(Modification mod, ServerEntry entry, Registries registries) throws NamingException {
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        ModificationOperation modOp = mod.getOperation();
        String id = mod.getAttribute().getId();
        AttributeType attributeType = registries.getAttributeTypeRegistry().lookup(id);
        switch (modOp) {
            case REPLACE_ATTRIBUTE: {
                targetEntry.put(new EntryAttribute[]{(ServerAttribute)mod.getAttribute()});
                break;
            }
            case REMOVE_ATTRIBUTE: {
                ServerAttribute toBeRemoved = (ServerAttribute)mod.getAttribute();
                if (toBeRemoved.size() == 0) {
                    targetEntry.removeAttributes(new String[]{id});
                    break;
                }
                EntryAttribute existing = targetEntry.get(id);
                if (existing == null) break;
                Iterator i$ = toBeRemoved.iterator();
                while (i$.hasNext()) {
                    Value value = (Value)i$.next();
                    existing.remove(new Value[]{value});
                }
                break;
            }
            case ADD_ATTRIBUTE: {
                DefaultServerAttribute combined = new DefaultServerAttribute(id, attributeType);
                ServerAttribute toBeAdded = (ServerAttribute)mod.getAttribute();
                EntryAttribute existing = entry.get(id);
                if (existing != null) {
                    for (Value value : existing) {
                        combined.add(new Value[]{value});
                    }
                }
                Iterator i$ = toBeAdded.iterator();
                while (i$.hasNext()) {
                    Value value;
                    value = (Value)i$.next();
                    combined.add(new Value[]{value});
                }
                targetEntry.put(new EntryAttribute[]{combined});
                break;
            }
            default: {
                throw new IllegalStateException("undefined modification type: " + modOp);
            }
        }
        return targetEntry;
    }

    public static ServerAttribute getUnion(ServerAttribute attr0, ServerAttribute attr1) {
        if (attr0 == null && attr1 == null) {
            throw new IllegalArgumentException("Cannot figure out attribute ID if both args are null");
        }
        if (attr0 == null) {
            return (ServerAttribute)attr1.clone();
        }
        if (attr1 == null) {
            return (ServerAttribute)attr0.clone();
        }
        if (!attr0.getAttributeType().equals(attr1.getAttributeType())) {
            throw new IllegalArgumentException("Cannot take union of attributes with different IDs!");
        }
        ServerAttribute attr = (ServerAttribute)attr0.clone();
        Iterator i$ = attr1.iterator();
        while (i$.hasNext()) {
            Value value = (Value)i$.next();
            attr.add(new Value[]{value});
        }
        return attr;
    }

    private static Modification toServerModification(ModificationItem modificationImpl, AttributeType attributeType) {
        ModificationOperation operation;
        switch (modificationImpl.getModificationOp()) {
            case 3: {
                operation = ModificationOperation.REMOVE_ATTRIBUTE;
                break;
            }
            case 2: {
                operation = ModificationOperation.REPLACE_ATTRIBUTE;
                break;
            }
            default: {
                operation = ModificationOperation.ADD_ATTRIBUTE;
            }
        }
        ServerModification modification = new ServerModification(operation, (EntryAttribute)ServerEntryUtils.toServerAttribute(modificationImpl.getAttribute(), attributeType));
        return modification;
    }

    public static List<Modification> convertToServerModification(List<ModificationItem> modificationItems, AttributeTypeRegistry atRegistry) throws NamingException {
        if (modificationItems != null) {
            ArrayList<Modification> modifications = new ArrayList<Modification>(modificationItems.size());
            for (ModificationItem modificationItem : modificationItems) {
                AttributeType attributeType = atRegistry.lookup(modificationItem.getAttribute().getID());
                modifications.add(ServerEntryUtils.toServerModification(modificationItem, attributeType));
            }
            return modifications;
        }
        return null;
    }

    private static Modification toServerModification(Modification modification, AttributeType attributeType) {
        if (modification instanceof ServerModification) {
            return modification;
        }
        ServerModification serverModification = new ServerModification(modification.getOperation(), (EntryAttribute)new DefaultServerAttribute(attributeType, modification.getAttribute()));
        return serverModification;
    }

    public static List<Modification> toServerModification(Modification[] modifications, AttributeTypeRegistry atRegistry) throws NamingException {
        if (modifications != null) {
            ArrayList<Modification> modificationsList = new ArrayList<Modification>();
            for (Modification modification : modifications) {
                String attributeId = modification.getAttribute().getId();
                String id = ServerEntryUtils.stripOptions(attributeId);
                modification.getAttribute().setId(id);
                Set<String> options = ServerEntryUtils.getOptions(attributeId);
                if (!atRegistry.hasAttributeType(id) && modification.getAttribute().size() == 0 && modification.getOperation() == ModificationOperation.REPLACE_ATTRIBUTE) continue;
                AttributeType attributeType = atRegistry.lookup(id);
                modificationsList.add(ServerEntryUtils.toServerModification(modification, attributeType));
            }
            return modificationsList;
        }
        return null;
    }

    public static List<Modification> toServerModification(ModificationItem[] modifications, AttributeTypeRegistry atRegistry) throws NamingException {
        if (modifications != null) {
            ArrayList<Modification> modificationsList = new ArrayList<Modification>();
            for (ModificationItem modification : modifications) {
                String attributeId = modification.getAttribute().getID();
                String id = ServerEntryUtils.stripOptions(attributeId);
                Set<String> options = ServerEntryUtils.getOptions(attributeId);
                if (!atRegistry.hasAttributeType(id) && modification.getAttribute().size() == 0 && modification.getModificationOp() == 2) continue;
                AttributeType attributeType = atRegistry.lookup(id);
                modificationsList.add(ServerEntryUtils.toServerModification(modification, attributeType));
            }
            return modificationsList;
        }
        return null;
    }

    public static final Modification getModificationItem(List<Modification> mods, AttributeType type) {
        for (Modification modification : mods) {
            ServerAttribute attribute = (ServerAttribute)modification.getAttribute();
            if (attribute.getAttributeType() != type) continue;
            return modification;
        }
        return null;
    }

    public static ServerAttribute getAttribute(List<Modification> mods, AttributeType type) {
        Modification mod = ServerEntryUtils.getModificationItem(mods, type);
        if (mod != null) {
            return (ServerAttribute)mod.getAttribute();
        }
        return null;
    }

    public static NamingEnumeration<SearchResult> toSearchResultEnum(final NamingEnumeration<ServerSearchResult> result) {
        if (result instanceof EmptyEnumeration) {
            return new EmptyEnumeration();
        }
        return new NamingEnumeration<SearchResult>(){

            @Override
            public void close() throws NamingException {
                result.close();
            }

            @Override
            public boolean hasMore() throws NamingException {
                return result.hasMore();
            }

            @Override
            public SearchResult next() throws NamingException {
                ServerSearchResult rec = (ServerSearchResult)result.next();
                SearchResult searchResult = new SearchResult(rec.getDn().getUpName(), rec.getObject(), ServerEntryUtils.toBasicAttributes(rec.getServerEntry()), rec.isRelative());
                return searchResult;
            }

            @Override
            public boolean hasMoreElements() {
                return result.hasMoreElements();
            }

            @Override
            public SearchResult nextElement() {
                try {
                    ServerSearchResult rec = (ServerSearchResult)result.next();
                    SearchResult searchResult = new SearchResult(rec.getDn().getUpName(), rec.getObject(), ServerEntryUtils.toBasicAttributes(rec.getServerEntry()), rec.isRelative());
                    return searchResult;
                }
                catch (NamingException ne) {
                    NoSuchElementException nsee = new NoSuchElementException("Encountered NamingException on underlying enumeration.");
                    nsee.initCause(ne);
                    throw nsee;
                }
            }
        };
    }

    private static String stripOptions(String attributeId) {
        int optionsPos = attributeId.indexOf(";");
        if (optionsPos != -1) {
            return attributeId.substring(0, optionsPos);
        }
        return attributeId;
    }

    private static Set<String> getOptions(String attributeId) {
        int optionsPos = attributeId.indexOf(";");
        if (optionsPos != -1) {
            String[] res;
            HashSet<String> options = new HashSet<String>();
            for (String option : res = attributeId.substring(optionsPos + 1).split(";")) {
                if (StringTools.isEmpty((String)option)) continue;
                options.add(option);
            }
            return options;
        }
        return null;
    }
}

