/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.matcher;

import java.util.Iterator;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;

public class CollectionElementMatcher<T>
extends ElementMatcher.Junction.AbstractBase<Iterable<? extends T>> {
    private final int index;
    private final ElementMatcher<? super T> matcher;

    public CollectionElementMatcher(int index, ElementMatcher<? super T> matcher) {
        this.index = index;
        this.matcher = matcher;
    }

    @Override
    public boolean matches(Iterable<? extends T> target) {
        Iterator<T> iterator = target.iterator();
        for (int index = 0; index < this.index; ++index) {
            if (!iterator.hasNext()) {
                return false;
            }
            iterator.next();
        }
        return iterator.hasNext() && this.matcher.matches(iterator.next());
    }

    public String toString() {
        return "with(" + this.index + " matches " + this.matcher + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionElementMatcher)) {
            return false;
        }
        CollectionElementMatcher other = (CollectionElementMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        ElementMatcher<T> this$matcher = this.matcher;
        ElementMatcher<? super T> other$matcher = other.matcher;
        return !(this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionElementMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.index;
        ElementMatcher<T> $matcher = this.matcher;
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        return result;
    }
}

