/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.factory.list.MutableListFactory;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.list.mutable.MultiReaderFastList;

public enum MultiReaderMutableListFactory implements MutableListFactory
{
    INSTANCE;


    public <T> MutableList<T> empty() {
        return MultiReaderFastList.newList();
    }

    public <T> MutableList<T> with(T ... items) {
        return MultiReaderFastList.newListWith(items);
    }

    public <T> MutableList<T> withInitialCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        return MultiReaderFastList.newList(capacity);
    }

    public <T> MutableList<T> withAll(Iterable<? extends T> iterable) {
        return MultiReaderFastList.newList(iterable);
    }

    public <T> MutableList<T> fromStream(Stream<? extends T> stream) {
        return stream.collect(Collectors.toCollection(MultiReaderFastList::newList));
    }

    public <T> MutableList<T> withNValues(int size, Function0<? extends T> factory) {
        MultiReaderFastList<Object> newFastList = MultiReaderFastList.newList(size);
        for (int i = 0; i < size; ++i) {
            newFastList.add(factory.value());
        }
        return newFastList;
    }
}

