/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.block.factory.primitive.IntPredicates;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.lazy.primitive.CollectIntToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseIntIterable;
import org.eclipse.collections.impl.lazy.primitive.SelectIntIterable;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;

public final class IntInterval
implements ImmutableIntList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int from;
    private final int to;
    private final int step;

    private IntInterval(int from, int to, int step) {
        this.from = from;
        this.to = to;
        this.step = step;
    }

    public static IntInterval from(int newFrom) {
        return IntInterval.fromToBy(newFrom, newFrom, 1);
    }

    public IntInterval to(int newTo) {
        return IntInterval.fromToBy(this.from, newTo, this.step);
    }

    public IntInterval by(int newStep) {
        return IntInterval.fromToBy(this.from, this.to, newStep);
    }

    public static IntInterval zero() {
        return IntInterval.from(0);
    }

    public static IntInterval oneTo(int count) {
        return IntInterval.oneToBy(count, 1);
    }

    public static IntInterval oneToBy(int count, int step) {
        if (count < 1) {
            throw new IllegalArgumentException("Only positive ranges allowed using oneToBy");
        }
        return IntInterval.fromToBy(1, count, step);
    }

    public static IntInterval zeroTo(int count) {
        return IntInterval.zeroToBy(count, 1);
    }

    public static IntInterval zeroToBy(int count, int step) {
        return IntInterval.fromToBy(0, count, step);
    }

    public static IntInterval fromTo(int from, int to) {
        if (from <= to) {
            return IntInterval.fromToBy(from, to, 1);
        }
        return IntInterval.fromToBy(from, to, -1);
    }

    public static IntInterval evensFromTo(int from, int to) {
        if (from % 2 != 0) {
            from = from < to ? ++from : --from;
        }
        if (to % 2 != 0) {
            to = to > from ? --to : ++to;
        }
        return IntInterval.fromToBy(from, to, to > from ? 2 : -2);
    }

    public static IntInterval oddsFromTo(int from, int to) {
        if (from % 2 == 0) {
            from = from < to ? ++from : --from;
        }
        if (to % 2 == 0) {
            to = to > from ? --to : ++to;
        }
        return IntInterval.fromToBy(from, to, to > from ? 2 : -2);
    }

    public static IntInterval fromToBy(int from, int to, int stepBy) {
        if (stepBy == 0) {
            throw new IllegalArgumentException("Cannot use a step by of 0");
        }
        if (from > to && stepBy > 0 || from < to && stepBy < 0) {
            throw new IllegalArgumentException("Step by is incorrect for the range");
        }
        return new IntInterval(from, to, stepBy);
    }

    public boolean containsAll(int ... values) {
        for (int value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsNone(int ... values) {
        for (int value : values) {
            if (!this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int value) {
        return this.isWithinBoundaries(value) && (value - this.from) % this.step == 0;
    }

    private boolean isWithinBoundaries(int value) {
        return this.step > 0 && this.from <= value && value <= this.to || this.step < 0 && this.to <= value && value <= this.from;
    }

    public void forEachWithIndex(IntIntProcedure procedure) {
        int index = 0;
        if (this.from <= this.to) {
            for (int i = this.from; i <= this.to; i += this.step) {
                procedure.value(i, index++);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                procedure.value(i, index++);
            }
        }
    }

    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    public void each(IntProcedure procedure) {
        if (this.from <= this.to) {
            for (int i = this.from; i <= this.to; i += this.step) {
                procedure.value(i);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                procedure.value(i);
            }
        }
    }

    public int count(IntPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!predicate.accept(this.get(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.size(); ++i) {
            if (!predicate.accept(this.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.size(); ++i) {
            if (predicate.accept(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        for (int i = 0; i < this.size(); ++i) {
            if (!predicate.accept(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof IntList)) {
            return false;
        }
        IntList list = (IntList)otherList;
        if (this.size() != list.size()) {
            return false;
        }
        if (this.from == this.to) {
            return this.from == list.get(0);
        }
        if (this.from < this.to) {
            int listIndex = 0;
            for (int i = this.from; i <= this.to; i += this.step) {
                if (i == list.get(listIndex++)) continue;
                return false;
            }
        } else {
            int listIndex = 0;
            for (int i = this.from; i >= this.to; i += this.step) {
                if (i == list.get(listIndex++)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        if (this.from == this.to) {
            hashCode = 31 + this.from;
        } else if (this.from < this.to) {
            for (int i = this.from; i <= this.to; i += this.step) {
                hashCode = 31 * hashCode + i;
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                hashCode = 31 * hashCode + i;
            }
        }
        return hashCode;
    }

    public IntInterval toReversed() {
        return IntInterval.fromToBy(this.to, this.from, -this.step);
    }

    public ImmutableIntList distinct() {
        return this;
    }

    public ImmutableIntList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    public int size() {
        return (this.to - this.from) / this.step + 1;
    }

    public long dotProduct(IntList list) {
        if (this.size() != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size(); ++i) {
            sum += (long)this.get(i) * (long)list.get(i);
        }
        return sum;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                int value = this.get(i);
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int[] toArray() {
        int[] result = new int[this.size()];
        this.forEachWithIndex((IntIntProcedure & Serializable)(each, index) -> {
            result[index] = each;
        });
        return result;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        if (this.from <= this.to) {
            for (int i = this.from; i <= this.to; i += this.step) {
                result = function.valueOf(result, i);
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                result = function.valueOf(result, i);
            }
        }
        return result;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        int index = 0;
        if (this.from <= this.to) {
            for (int i = this.from; i <= this.to; i += this.step) {
                result = function.valueOf(result, i, index);
                ++index;
            }
        } else {
            for (int i = this.from; i >= this.to; i += this.step) {
                result = function.valueOf(result, i, index);
                ++index;
            }
        }
        return result;
    }

    public RichIterable<IntIterable> chunk(int size) {
        MutableList result;
        block7: {
            if (size <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
            }
            result = Lists.mutable.empty();
            if (!this.notEmpty()) break block7;
            int innerFrom = this.from;
            int lastUpdated = this.from;
            if (this.from <= this.to) {
                while (lastUpdated + this.step <= this.to) {
                    MutableIntList batch = IntLists.mutable.empty();
                    for (int i = innerFrom; i <= this.to && batch.size() < size; i += this.step) {
                        batch.add(i);
                        lastUpdated = i;
                    }
                    result.add((Object)batch);
                    innerFrom = lastUpdated + this.step;
                }
            } else {
                while (lastUpdated + this.step >= this.to) {
                    MutableIntList batch = IntLists.mutable.empty();
                    for (int i = innerFrom; i >= this.to && batch.size() < size; i += this.step) {
                        batch.add(i);
                        lastUpdated = i;
                    }
                    result.add((Object)batch);
                    innerFrom = lastUpdated + this.step;
                }
            }
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public IntIterator intIterator() {
        return new IntIntervalIterator();
    }

    public int getFirst() {
        return this.from;
    }

    public int getLast() {
        return this.locationAfterN(this.size() - 1);
    }

    public int get(int index) {
        this.checkBounds("index", index);
        return this.locationAfterN(index);
    }

    private void checkBounds(String name, int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(name + ": " + index + ' ' + this);
        }
    }

    private int locationAfterN(int index) {
        if (index <= 0) {
            return this.from;
        }
        if (this.step > 0) {
            return (int)Math.min((long)this.from + (long)this.step * (long)index, (long)this.to);
        }
        return (int)Math.max((long)this.from + (long)this.step * (long)index, (long)this.to);
    }

    public int indexOf(int value) {
        if (!this.isWithinBoundaries(value)) {
            return -1;
        }
        int diff = value - this.from;
        if (diff % this.step == 0) {
            return diff / this.step;
        }
        return -1;
    }

    public int lastIndexOf(int value) {
        return this.indexOf(value);
    }

    public ImmutableIntList select(IntPredicate predicate) {
        return IntArrayList.newList((IntIterable)new SelectIntIterable((IntIterable)this, predicate)).toImmutable();
    }

    public ImmutableIntList reject(IntPredicate predicate) {
        return IntArrayList.newList((IntIterable)new SelectIntIterable((IntIterable)this, IntPredicates.not(predicate))).toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return new SelectIntIterable((IntIterable)this, predicate).detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableList<V> collect(IntToObjectFunction<? extends V> function) {
        return new CollectIntToObjectIterable<V>((IntIterable)this, function).toList().toImmutable();
    }

    public LazyIntIterable asReversed() {
        return ReverseIntIterable.adapt((IntList)this);
    }

    public long sum() {
        long sum = 0L;
        IntIterator intIterator = this.intIterator();
        while (intIterator.hasNext()) {
            sum += (long)intIterator.next();
        }
        return sum;
    }

    public int max() {
        if (this.from >= this.to) {
            return this.getFirst();
        }
        return this.getLast();
    }

    public int min() {
        if (this.from <= this.to) {
            return this.getFirst();
        }
        return this.getLast();
    }

    public int minIfEmpty(int defaultValue) {
        return this.min();
    }

    public int maxIfEmpty(int defaultValue) {
        return this.max();
    }

    public double average() {
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public int binarySearch(int value) {
        if (this.step > 0 && this.from > value || this.step < 0 && this.from < value) {
            return -1;
        }
        if (this.step > 0 && this.to < value || this.step < 0 && this.to > value) {
            return -1 - this.size();
        }
        int diff = value - this.from;
        int index = diff / this.step;
        return diff % this.step == 0 ? index : (index + 2) * -1;
    }

    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableIntList toImmutable() {
        return this;
    }

    public ImmutableIntList newWith(int element) {
        return IntArrayList.newList((IntIterable)this).with(element).toImmutable();
    }

    public ImmutableIntList newWithout(int element) {
        return IntArrayList.newList((IntIterable)this).without(element).toImmutable();
    }

    public ImmutableIntList newWithAll(IntIterable elements) {
        return IntArrayList.newList((IntIterable)this).withAll(elements).toImmutable();
    }

    public ImmutableIntList newWithoutAll(IntIterable elements) {
        return IntArrayList.newList((IntIterable)this).withoutAll(elements).toImmutable();
    }

    public ImmutableList<IntIntPair> zipInt(IntIterable iterable) {
        int size = this.size();
        int othersize = iterable.size();
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, othersize));
        IntIterator iterator = this.intIterator();
        IntIterator otherIterator = iterable.intIterator();
        for (int i = 0; i < size && otherIterator.hasNext(); ++i) {
            target.add((Object)PrimitiveTuples.pair(iterator.next(), otherIterator.next()));
        }
        return target.toImmutable();
    }

    public <T> ImmutableList<IntObjectPair<T>> zip(Iterable<T> iterable) {
        int size = this.size();
        int othersize = Iterate.sizeOf(iterable);
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, othersize));
        IntIterator iterator = this.intIterator();
        Iterator<T> otherIterator = iterable.iterator();
        for (int i = 0; i < size && otherIterator.hasNext(); ++i) {
            target.add(PrimitiveTuples.pair(iterator.next(), otherIterator.next()));
        }
        return target.toImmutable();
    }

    public Spliterator.OfInt spliterator() {
        return new IntIntervalSpliterator(this.from, this.to, this.step);
    }

    private static final class IntIntervalSpliterator
    implements Spliterator.OfInt {
        private int current;
        private final int to;
        private final int step;
        private final boolean isAscending;

        private IntIntervalSpliterator(int from, int to, int step) {
            this.current = from;
            this.to = to;
            this.step = step;
            this.isAscending = from <= to;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.isAscending) {
                return Comparator.naturalOrder();
            }
            return Comparator.reverseOrder();
        }

        @Override
        public Spliterator.OfInt trySplit() {
            IntIntervalSpliterator leftSpliterator = null;
            int numberOfStepsToMid = (int)(this.estimateSize() / 2L);
            int mid = this.current + this.step * numberOfStepsToMid;
            if (this.isAscending) {
                if (this.current < mid) {
                    leftSpliterator = new IntIntervalSpliterator(this.current, mid - 1, this.step);
                    this.current = mid;
                }
            } else if (this.current > mid) {
                leftSpliterator = new IntIntervalSpliterator(this.current, mid + 1, this.step);
                this.current = mid;
            }
            return leftSpliterator;
        }

        @Override
        public long estimateSize() {
            return (this.to - this.current) / this.step + 1;
        }

        @Override
        public int characteristics() {
            return 1365;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            action.accept(this.current);
            this.current += this.step;
            if (this.isAscending) {
                return this.current <= this.to;
            }
            return this.current >= this.to;
        }
    }

    private class IntIntervalIterator
    implements IntIterator {
        private int current;

        private IntIntervalIterator() {
            this.current = IntInterval.this.from;
        }

        public boolean hasNext() {
            if (IntInterval.this.from <= IntInterval.this.to) {
                return this.current <= IntInterval.this.to;
            }
            return this.current >= IntInterval.this.to;
        }

        public int next() {
            if (this.hasNext()) {
                int result = this.current;
                this.current += IntInterval.this.step;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

