/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction0;
import org.eclipse.collections.api.block.function.primitive.ByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteBytePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ByteByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.map.primitive.ByteByteMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteByteMap;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteBytePair;
import org.eclipse.collections.impl.factory.primitive.ByteByteMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyByteIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableByteKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableByteValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableByteByteMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableByteKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedByteByteMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableByteByteMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteByteHashMap
extends AbstractMutableByteValuesMap
implements MutableByteByteMap,
Externalizable,
MutableByteKeysMap {
    private static final byte EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_KEY = 0;
    private static final byte REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 1;
    private static final int INITIAL_LINEAR_PROBE = 32;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private byte[] keysValues;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableByteValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public ByteByteHashMap() {
        this.allocateTable(16);
    }

    public ByteByteHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public ByteByteHashMap(ByteByteMap map) {
        if (map instanceof ByteByteHashMap && ((ByteByteHashMap)map).occupiedWithSentinels == 0) {
            ByteByteHashMap hashMap = (ByteByteHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keysValues = Arrays.copyOf(hashMap.keysValues, hashMap.keysValues.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static ByteByteHashMap newWithKeysValues(byte key1, byte value1) {
        return new ByteByteHashMap(1).withKeyValue(key1, value1);
    }

    public static ByteByteHashMap newWithKeysValues(byte key1, byte value1, byte key2, byte value2) {
        return new ByteByteHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ByteByteHashMap newWithKeysValues(byte key1, byte value1, byte key2, byte value2, byte key3, byte value3) {
        return new ByteByteHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ByteByteHashMap newWithKeysValues(byte key1, byte value1, byte key2, byte value2, byte key3, byte value3, byte key4, byte value4) {
        return new ByteByteHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableByteValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected byte getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.keysValues.length / 2;
    }

    @Override
    protected byte getValueAtIndex(int index) {
        return this.keysValues[index * 2 + 1];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteByteMap)) {
            return false;
        }
        ByteByteMap other = (ByteByteMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((byte)0) || other.containsKey((byte)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((byte)0) || this.sentinelValues.zeroValue != other.getOrThrow((byte)0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((byte)1) || this.sentinelValues.oneValue != other.getOrThrow((byte)1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            byte key = this.keysValues[i];
            if (!ByteByteHashMap.isNonSentinel(key) || other.containsKey(key) && this.keysValues[i + 1] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ByteByteHashMap.isNonSentinel(this.keysValues[i])) continue;
            result += this.keysValues[i] ^ this.keysValues[i + 1];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            byte key = this.keysValues[i];
            if (!ByteByteHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.keysValues[i + 1]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectByteToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ByteByteHashMap.isNonSentinel(this.keysValues[i])) continue;
            result = function.valueOf(result, this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keysValues, (byte)0);
    }

    public void put(byte key, byte value) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (ByteByteHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        byte keyAtIndex = this.keysValues[index];
        if (keyAtIndex == key) {
            this.keysValues[index + 1] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(byte value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(byte value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(ByteByteMap map) {
        map.forEachKeyValue(new ByteByteProcedure(){

            public void value(byte key, byte value) {
                ByteByteHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public void removeKey(byte key) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (ByteByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(byte key) {
        this.removeKey(key);
    }

    public byte removeKeyIfAbsent(byte key, byte value) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (ByteByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            byte oldValue = this.keysValues[index + 1];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public byte getIfAbsentPut(byte key, byte value) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte getIfAbsentPut(byte key, ByteFunction0 function) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.value();
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.value();
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        byte value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> byte getIfAbsentPutWith(byte key, ByteFunction<? super P> function, P parameter) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.byteValueOf(parameter);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.byteValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.byteValueOf(parameter);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.byteValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        byte value = function.byteValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte getIfAbsentPutWithKey(byte key, ByteToByteFunction function) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ByteByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        byte value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte addToValue(byte key, byte toBeAdded) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (byte)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (byte)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            int n = index + 1;
            this.keysValues[n] = (byte)(this.keysValues[n] + toBeAdded);
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(byte key, byte value, int index) {
        if (this.keysValues[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = key;
        this.keysValues[index + 1] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = 1;
        this.keysValues[index + 1] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        byte[] copy = new byte[this.keysValues.length];
        System.arraycopy(this.keysValues, 0, copy, 0, this.keysValues.length);
        this.keysValues = copy;
        this.copyKeysOnWrite = false;
    }

    public byte updateValue(byte key, byte initialValueIfAbsent, ByteToByteFunction function) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            this.keysValues[index + 1] = function.valueOf(this.keysValues[index + 1]);
            return this.keysValues[index + 1];
        }
        byte value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public ByteByteHashMap withKeyValue(byte key1, byte value1) {
        this.put(key1, value1);
        return this;
    }

    public ByteByteHashMap withKeysValues(byte key1, byte value1, byte key2, byte value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ByteByteHashMap withKeysValues(byte key1, byte value1, byte key2, byte value2, byte key3, byte value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ByteByteHashMap withKeysValues(byte key1, byte value1, byte key2, byte value2, byte key3, byte value3, byte key4, byte value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ByteByteHashMap withoutKey(byte key) {
        this.removeKey(key);
        return this;
    }

    public ByteByteHashMap withoutAllKeys(ByteIterable keys) {
        keys.forEach(new ByteProcedure(){

            public void value(byte key) {
                ByteByteHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableByteByteMap asUnmodifiable() {
        return new UnmodifiableByteByteMap(this);
    }

    public MutableByteByteMap asSynchronized() {
        return new SynchronizedByteByteMap(this);
    }

    public ImmutableByteByteMap toImmutable() {
        return ByteByteMaps.immutable.ofAll((ByteByteMap)this);
    }

    public byte get(byte key) {
        return this.getIfAbsent(key, (byte)0);
    }

    public byte getIfAbsent(byte key, byte ifAbsent) {
        if (ByteByteHashMap.isEmptyKey(key) || ByteByteHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private byte getForSentinel(byte key, byte ifAbsent) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private byte slowGetIfAbsent(byte key, byte ifAbsent) {
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        return ifAbsent;
    }

    public byte getOrThrow(byte key) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ByteByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ByteByteHashMap.isNonSentinel(this.keysValues[index])) {
            return this.keysValues[index + 1];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(byte key) {
        if (ByteByteHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ByteByteHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keysValues[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ByteByteHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i]);
        }
    }

    public void forEachKeyValue(ByteByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ByteByteHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i], this.keysValues[i + 1]);
        }
    }

    public LazyByteIterable keysView() {
        return new KeysView();
    }

    public RichIterable<ByteBytePair> keyValuesView() {
        return new KeyValuesView();
    }

    public ByteByteHashMap select(ByteBytePredicate predicate) {
        ByteByteHashMap result = new ByteByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ByteByteHashMap.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    public ByteByteHashMap reject(ByteBytePredicate predicate) {
        ByteByteHashMap result = new ByteByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((byte)0, this.sentinelValues.zeroValue)) {
                result.put((byte)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((byte)1, this.sentinelValues.oneValue)) {
                result.put((byte)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ByteByteHashMap.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeByte(0);
                out.writeByte(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeByte(1);
                out.writeByte(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ByteByteHashMap.isNonSentinel(this.keysValues[i])) continue;
            out.writeByte(this.keysValues[i]);
            out.writeByte(this.keysValues[i + 1]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readByte(), in.readByte());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keysValues.length);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keysValues.length;
        byte[] old = this.keysValues;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; i += 2) {
            if (!ByteByteHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], old[i + 1]);
        }
    }

    int probe(byte element) {
        int index = this.spreadAndMask(element) << 1;
        byte keyAtIndex = this.keysValues[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 34;
        while (true) {
            nextIndex += probe;
            probe += 34;
            if (this.keysValues[nextIndex &= this.keysValues.length - 1] == element) {
                return nextIndex;
            }
            if (this.keysValues[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keysValues[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spreadAndMask(byte element) {
        return this.mask(element);
    }

    private int mask(int spread) {
        return spread & (this.keysValues.length >> 1) - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keysValues = new byte[sizeToAllocate << 1];
    }

    private static boolean isEmptyKey(byte key) {
        return key == 0;
    }

    private static boolean isRemovedKey(byte key) {
        return key == 1;
    }

    private static boolean isNonSentinel(byte key) {
        return !ByteByteHashMap.isEmptyKey(key) && !ByteByteHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !ByteByteHashMap.isEmptyKey(this.keysValues[index * 2]) && !ByteByteHashMap.isRemovedKey(this.keysValues[index * 2]);
    }

    private int maxOccupiedWithData() {
        return this.keysValues.length >> 2;
    }

    private int maxOccupiedWithSentinels() {
        return this.keysValues.length >> 3;
    }

    public MutableByteSet keySet() {
        return new KeySet();
    }

    public MutableByteCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ byte[] access$302(ByteByteHashMap x0, byte[] x1) {
        x0.keysValues = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<ByteBytePair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super ByteBytePair> procedure) {
            if (ByteByteHashMap.this.sentinelValues != null) {
                if (((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)0, ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.zeroValue));
                }
                if (((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)1, ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < ByteByteHashMap.this.keysValues.length; i += 2) {
                if (!ByteByteHashMap.isNonSentinel(ByteByteHashMap.this.keysValues[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ByteByteHashMap.this.keysValues[i], ByteByteHashMap.this.keysValues[i + 1]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ByteBytePair> objectIntProcedure) {
            int index = 0;
            if (ByteByteHashMap.this.sentinelValues != null) {
                if (((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((byte)0, ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((byte)1, ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < ByteByteHashMap.this.keysValues.length; i += 2) {
                if (!ByteByteHashMap.isNonSentinel(ByteByteHashMap.this.keysValues[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(ByteByteHashMap.this.keysValues[i], ByteByteHashMap.this.keysValues[i + 1]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ByteBytePair, ? super P> procedure, P parameter) {
            if (ByteByteHashMap.this.sentinelValues != null) {
                if (((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)0, ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((byte)1, ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < ByteByteHashMap.this.keysValues.length; i += 2) {
                if (!ByteByteHashMap.isNonSentinel(ByteByteHashMap.this.keysValues[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ByteByteHashMap.this.keysValues[i], ByteByteHashMap.this.keysValues[i + 1]), parameter);
            }
        }

        public Iterator<ByteBytePair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<ByteBytePair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public ByteBytePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (ByteByteHashMap.this.containsKey((byte)0)) {
                        return PrimitiveTuples.pair((byte)0, ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (ByteByteHashMap.this.containsKey((byte)1)) {
                        return PrimitiveTuples.pair((byte)1, ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.oneValue);
                    }
                }
                byte[] keys = ByteByteHashMap.this.keysValues;
                while (!ByteByteHashMap.isNonSentinel(keys[this.position])) {
                    this.position += 2;
                }
                ByteBytePair result = PrimitiveTuples.pair(keys[this.position], ByteByteHashMap.this.keysValues[this.position + 1]);
                this.position += 2;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ByteByteHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableByteValuesMap.AbstractByteValuesCollection {
        private ValuesCollection() {
        }

        public MutableByteIterator byteIterator() {
            return ByteByteHashMap.this.byteIterator();
        }

        public boolean remove(byte item) {
            int oldSize = ByteByteHashMap.this.size();
            if (ByteByteHashMap.this.sentinelValues != null) {
                if (((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.containsZeroKey && item == ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.zeroValue) {
                    ByteByteHashMap.this.removeKey((byte)0);
                }
                if (((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.containsOneKey && item == ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.oneValue) {
                    ByteByteHashMap.this.removeKey((byte)1);
                }
            }
            for (int i = 0; i < ByteByteHashMap.this.keysValues.length; i += 2) {
                if (!ByteByteHashMap.isNonSentinel(ByteByteHashMap.this.keysValues[i]) || item != ByteByteHashMap.this.keysValues[i + 1]) continue;
                ByteByteHashMap.this.removeKey(ByteByteHashMap.this.keysValues[i]);
            }
            return oldSize != ByteByteHashMap.this.size();
        }

        public boolean retainAll(ByteIterable source) {
            int oldSize = ByteByteHashMap.this.size();
            Object sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            ByteByteHashMap retained = ByteByteHashMap.this.select(new ByteBytePredicate((ByteSet)sourceSet){
                final /* synthetic */ ByteSet val$sourceSet;
                {
                    this.val$sourceSet = byteSet;
                }

                public boolean accept(byte key, byte value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                ByteByteHashMap.access$302(ByteByteHashMap.this, retained.keysValues);
                ByteByteHashMap.this.sentinelValues = retained.sentinelValues;
                ByteByteHashMap.this.occupiedWithData = retained.occupiedWithData;
                ByteByteHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }
    }

    private class KeySet
    extends AbstractMutableByteKeySet {
        private KeySet() {
        }

        protected MutableByteKeysMap getOuter() {
            return ByteByteHashMap.this;
        }

        protected AbstractMutableByteValuesMap.SentinelValues getSentinelValues() {
            return ByteByteHashMap.this.sentinelValues;
        }

        protected byte getKeyAtIndex(int index) {
            return ByteByteHashMap.this.keysValues[index * 2];
        }

        protected int getTableSize() {
            return ByteByteHashMap.this.keysValues.length / 2;
        }

        public MutableByteIterator byteIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(ByteIterable source) {
            int oldSize = ByteByteHashMap.this.size();
            Object sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            ByteByteHashMap retained = ByteByteHashMap.this.select(new ByteBytePredicate((ByteSet)sourceSet){
                final /* synthetic */ ByteSet val$sourceSet;
                {
                    this.val$sourceSet = byteSet;
                }

                public boolean accept(byte key, byte value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                ByteByteHashMap.access$302(ByteByteHashMap.this, retained.keysValues);
                ByteByteHashMap.this.sentinelValues = retained.sentinelValues;
                ByteByteHashMap.this.occupiedWithData = retained.occupiedWithData;
                ByteByteHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(byte ... source) {
            return this.retainAll((ByteIterable)ByteHashSet.newSetWith(source));
        }

        public ByteSet freeze() {
            ByteByteHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (ByteByteHashMap.this.sentinelValues != null) {
                containsZeroKey = ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((ByteByteHashMap)ByteByteHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableByteByteMapKeySet(ByteByteHashMap.this.keysValues, ByteByteHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }
    }

    private class KeySetIterator
    implements MutableByteIterator {
        private int count;
        private int position;
        private byte lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteByteHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteByteHashMap.this.containsKey((byte)0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteByteHashMap.this.containsKey((byte)1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            byte[] keys = ByteByteHashMap.this.keysValues;
            while (!ByteByteHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            this.position += 2;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ByteByteHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyByteIterable {
        private KeysView() {
        }

        public ByteIterator byteIterator() {
            return new UnmodifiableByteIterator((ByteIterator)new KeySetIterator());
        }

        public void each(ByteProcedure procedure) {
            ByteByteHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalByteIterator
    implements MutableByteIterator {
        private int count;
        private int position;
        private byte lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalByteIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteByteHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ByteByteHashMap.this.containsKey((byte)0)) {
                    this.lastKey = 0;
                    return ByteByteHashMap.this.get((byte)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ByteByteHashMap.this.containsKey((byte)1)) {
                    this.lastKey = 1;
                    return ByteByteHashMap.this.get((byte)1);
                }
            }
            byte[] keys = ByteByteHashMap.this.keysValues;
            while (!ByteByteHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            byte result = ByteByteHashMap.this.keysValues[this.position + 1];
            this.position += 2;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ByteByteHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

