/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.AggregationOptions;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.jongo.ResultHandler;
import org.jongo.ResultHandlerFactory;
import org.jongo.marshall.Unmarshaller;
import org.jongo.query.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregate {
    private final Unmarshaller unmarshaller;
    private final QueryFactory queryFactory;
    private final List<DBObject> pipeline;
    private final AtomicReference<AggregationOptions> options;
    private final DBCollection collection;

    Aggregate(DBCollection collection, Unmarshaller unmarshaller, QueryFactory queryFactory) {
        this.unmarshaller = unmarshaller;
        this.queryFactory = queryFactory;
        this.pipeline = new ArrayList<DBObject>();
        this.options = new AtomicReference();
        this.collection = collection;
    }

    public Aggregate and(String pipelineOperator, Object ... parameters) {
        DBObject dbQuery = this.queryFactory.createQuery(pipelineOperator, parameters).toDBObject();
        this.pipeline.add(dbQuery);
        return this;
    }

    public <T> ResultsIterator<T> as(Class<T> clazz) {
        return this.map(ResultHandlerFactory.newResultHandler(clazz, this.unmarshaller));
    }

    public Aggregate options(AggregationOptions options) {
        this.options.set(options);
        return this;
    }

    public <T> ResultsIterator<T> map(ResultHandler<T> resultHandler) {
        AggregationOptions options = this.options.get();
        Object results = options != null ? this.collection.aggregate(this.pipeline, options) : this.collection.aggregate(this.pipeline).results().iterator();
        return new ResultsIterator((Iterator)results, resultHandler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResultsIterator<E>
    implements Iterator<E>,
    Iterable<E> {
        private Iterator<DBObject> results;
        private ResultHandler<E> resultHandler;

        private ResultsIterator(Iterator<DBObject> results, ResultHandler<E> resultHandler) {
            this.resultHandler = resultHandler;
            this.results = results;
        }

        @Override
        public Iterator<E> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.results.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            DBObject dbObject = this.results.next();
            return this.resultHandler.map(dbObject);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() method is not supported");
        }
    }
}

