/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.jongo.ResultHandler;
import org.jongo.ResultHandlerFactory;
import org.jongo.marshall.Unmarshaller;
import org.jongo.query.Query;
import org.jongo.query.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Distinct {
    private final DBCollection dbCollection;
    private final Unmarshaller unmarshaller;
    private final String key;
    private Query query;
    private final QueryFactory queryFactory;

    Distinct(DBCollection dbCollection, Unmarshaller unmarshaller, QueryFactory queryFactory, String key) {
        this.dbCollection = dbCollection;
        this.unmarshaller = unmarshaller;
        this.key = key;
        this.queryFactory = queryFactory;
        this.query = this.queryFactory.createQuery("{}", new Object[0]);
    }

    public Distinct query(String query) {
        this.query = this.queryFactory.createQuery(query, new Object[0]);
        return this;
    }

    public Distinct query(String query, Object ... parameters) {
        this.query = this.queryFactory.createQuery(query, parameters);
        return this;
    }

    public <T> List<T> as(Class<T> clazz) {
        DBObject ref = this.query.toDBObject();
        List distinct = this.dbCollection.distinct(this.key, ref);
        if (distinct.isEmpty() || this.resultsAreBSONPrimitive(distinct)) {
            return distinct;
        }
        return this.typedList(distinct, ResultHandlerFactory.newResultHandler(clazz, this.unmarshaller));
    }

    public <T> List<T> map(ResultHandler<T> resultHandler) {
        DBObject ref = this.query.toDBObject();
        List distinct = this.dbCollection.distinct(this.key, ref);
        if (distinct.isEmpty() || this.resultsAreBSONPrimitive(distinct)) {
            return this.typedList(this.asDBObjectList(distinct), resultHandler);
        }
        return this.typedList(distinct, resultHandler);
    }

    private List<DBObject> asDBObjectList(List<?> distinct) {
        ArrayList<DBObject> objects = new ArrayList<DBObject>();
        for (Object object : distinct) {
            objects.add((DBObject)new BasicDBObject(this.key, object));
        }
        return objects;
    }

    private boolean resultsAreBSONPrimitive(List<?> distinct) {
        return !(distinct.get(0) instanceof DBObject);
    }

    private <T> List<T> typedList(List<DBObject> distinct, ResultHandler<T> handler) {
        ArrayList<T> results = new ArrayList<T>();
        for (DBObject dbObject : distinct) {
            results.add(handler.map(dbObject));
        }
        return results;
    }
}

