/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import java.util.ArrayList;
import java.util.List;
import org.jongo.MongoCursor;
import org.jongo.QueryModifier;
import org.jongo.ResultHandler;
import org.jongo.ResultHandlerFactory;
import org.jongo.marshall.Unmarshaller;
import org.jongo.query.Query;
import org.jongo.query.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Find {
    private final DBCollection collection;
    private final ReadPreference readPreference;
    private final Unmarshaller unmarshaller;
    private final QueryFactory queryFactory;
    private final Query query;
    private final List<QueryModifier> modifiers;
    private Query fields;

    Find(DBCollection collection, ReadPreference readPreference, Unmarshaller unmarshaller, QueryFactory queryFactory, String query, Object ... parameters) {
        this.readPreference = readPreference;
        this.unmarshaller = unmarshaller;
        this.collection = collection;
        this.queryFactory = queryFactory;
        this.query = this.queryFactory.createQuery(query, parameters);
        this.modifiers = new ArrayList<QueryModifier>();
    }

    public <T> MongoCursor<T> as(Class<T> clazz) {
        return this.map(ResultHandlerFactory.newResultHandler(clazz, this.unmarshaller));
    }

    public <T> MongoCursor<T> map(ResultHandler<T> resultHandler) {
        DBCursor cursor = new DBCursor(this.collection, this.query.toDBObject(), this.getFieldsAsDBObject(), this.readPreference);
        for (QueryModifier modifier : this.modifiers) {
            modifier.modify(cursor);
        }
        return new MongoCursor<T>(cursor, resultHandler);
    }

    public Find projection(String fields) {
        this.fields = this.queryFactory.createQuery(fields, new Object[0]);
        return this;
    }

    public Find projection(String fields, Object ... parameters) {
        this.fields = this.queryFactory.createQuery(fields, parameters);
        return this;
    }

    public Find limit(final int limit) {
        this.modifiers.add(new QueryModifier(){

            public void modify(DBCursor cursor) {
                cursor.limit(limit);
            }
        });
        return this;
    }

    public Find skip(final int skip) {
        this.modifiers.add(new QueryModifier(){

            public void modify(DBCursor cursor) {
                cursor.skip(skip);
            }
        });
        return this;
    }

    public Find sort(String sort) {
        final DBObject sortDBObject = this.queryFactory.createQuery(sort, new Object[0]).toDBObject();
        this.modifiers.add(new QueryModifier(){

            public void modify(DBCursor cursor) {
                cursor.sort(sortDBObject);
            }
        });
        return this;
    }

    public Find hint(String hint) {
        final DBObject hintDBObject = this.queryFactory.createQuery(hint, new Object[0]).toDBObject();
        this.modifiers.add(new QueryModifier(){

            public void modify(DBCursor cursor) {
                cursor.hint(hintDBObject);
            }
        });
        return this;
    }

    public Find with(QueryModifier queryModifier) {
        this.modifiers.add(queryModifier);
        return this;
    }

    private DBObject getFieldsAsDBObject() {
        return this.fields == null ? null : this.fields.toDBObject();
    }
}

