/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import org.jongo.ResultHandler;
import org.jongo.ResultHandlerFactory;
import org.jongo.marshall.Unmarshaller;
import org.jongo.query.Query;
import org.jongo.query.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindAndModify {
    private final DBCollection collection;
    private final Unmarshaller unmarshaller;
    private final QueryFactory queryFactory;
    private final Query query;
    private Query fields;
    private Query sort;
    private Query modifier;
    private boolean remove = false;
    private boolean returnNew = false;
    private boolean upsert = false;

    FindAndModify(DBCollection collection, Unmarshaller unmarshaller, QueryFactory queryFactory, String query, Object ... parameters) {
        this.unmarshaller = unmarshaller;
        this.collection = collection;
        this.queryFactory = queryFactory;
        this.query = this.queryFactory.createQuery(query, parameters);
    }

    public FindAndModify with(String modifier, Object ... parameters) {
        if (modifier == null) {
            throw new IllegalArgumentException("Modifier may not be null");
        }
        this.modifier = this.queryFactory.createQuery(modifier, parameters);
        return this;
    }

    public <T> T as(Class<T> clazz) {
        return this.map(ResultHandlerFactory.newResultHandler(clazz, this.unmarshaller));
    }

    public <T> T map(ResultHandler<T> resultHandler) {
        DBObject result = this.collection.findAndModify(this.query.toDBObject(), this.getAsDBObject(this.fields), this.getAsDBObject(this.sort), this.remove, this.getAsDBObject(this.modifier), this.returnNew, this.upsert);
        return result == null ? null : (T)resultHandler.map(result);
    }

    public FindAndModify projection(String fields) {
        this.fields = this.queryFactory.createQuery(fields, new Object[0]);
        return this;
    }

    public FindAndModify projection(String fields, Object ... parameters) {
        this.fields = this.queryFactory.createQuery(fields, parameters);
        return this;
    }

    public FindAndModify sort(String sort) {
        this.sort = this.queryFactory.createQuery(sort, new Object[0]);
        return this;
    }

    public FindAndModify remove() {
        this.remove = true;
        return this;
    }

    public FindAndModify returnNew() {
        this.returnNew = true;
        return this;
    }

    public FindAndModify upsert() {
        this.upsert = true;
        return this;
    }

    private DBObject getAsDBObject(Query query) {
        return query == null ? null : query.toDBObject();
    }
}

