/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import org.bson.types.ObjectId;
import org.jongo.Aggregate;
import org.jongo.Distinct;
import org.jongo.Find;
import org.jongo.FindAndModify;
import org.jongo.FindOne;
import org.jongo.Insert;
import org.jongo.Mapper;
import org.jongo.Update;
import org.jongo.query.Query;

public class MongoCollection {
    public static final String MONGO_DOCUMENT_ID_NAME = "_id";
    public static final String MONGO_QUERY_OID = "$oid";
    private static final Object[] NO_PARAMETERS = new Object[0];
    private static final String ALL = "{}";
    private final DBCollection collection;
    private final WriteConcern writeConcern;
    private final ReadPreference readPreference;
    private final Mapper mapper;

    public MongoCollection(DBCollection dbCollection, Mapper mapper) {
        this(dbCollection, mapper, dbCollection.getWriteConcern(), dbCollection.getReadPreference());
    }

    private MongoCollection(DBCollection dbCollection, Mapper mapper, WriteConcern writeConcern, ReadPreference readPreference) {
        this.collection = dbCollection;
        this.writeConcern = writeConcern;
        this.readPreference = readPreference;
        this.mapper = mapper;
    }

    public MongoCollection withWriteConcern(WriteConcern concern) {
        return new MongoCollection(this.collection, this.mapper, concern, this.readPreference);
    }

    public MongoCollection withReadPreference(ReadPreference readPreference) {
        return new MongoCollection(this.collection, this.mapper, this.writeConcern, readPreference);
    }

    public FindOne findOne(ObjectId id) {
        if (id == null) {
            throw new IllegalArgumentException("Object id must not be null");
        }
        return new FindOne(this.collection, this.readPreference, this.mapper.getUnmarshaller(), this.mapper.getQueryFactory(), "{_id:#}", id);
    }

    public FindOne findOne() {
        return this.findOne(ALL);
    }

    public FindOne findOne(String query) {
        return this.findOne(query, NO_PARAMETERS);
    }

    public FindOne findOne(String query, Object ... parameters) {
        return new FindOne(this.collection, this.readPreference, this.mapper.getUnmarshaller(), this.mapper.getQueryFactory(), query, parameters);
    }

    public Find find() {
        return this.find(ALL);
    }

    public Find find(String query) {
        return this.find(query, NO_PARAMETERS);
    }

    public Find find(String query, Object ... parameters) {
        return new Find(this.collection, this.readPreference, this.mapper.getUnmarshaller(), this.mapper.getQueryFactory(), query, parameters);
    }

    public FindAndModify findAndModify() {
        return this.findAndModify(ALL);
    }

    public FindAndModify findAndModify(String query) {
        return this.findAndModify(query, NO_PARAMETERS);
    }

    public FindAndModify findAndModify(String query, Object ... parameters) {
        return new FindAndModify(this.collection, this.mapper.getUnmarshaller(), this.mapper.getQueryFactory(), query, parameters);
    }

    public long count() {
        return this.collection.getCount(this.readPreference);
    }

    public long count(String query) {
        return this.count(query, NO_PARAMETERS);
    }

    public long count(String query, Object ... parameters) {
        DBObject dbQuery = this.createQuery(query, parameters).toDBObject();
        return this.collection.getCount(dbQuery, null, this.readPreference);
    }

    public Update update(String query) {
        return this.update(query, NO_PARAMETERS);
    }

    public Update update(ObjectId id) {
        if (id == null) {
            throw new IllegalArgumentException("Object id must not be null");
        }
        return this.update("{_id:#}", id);
    }

    public Update update(String query, Object ... parameters) {
        return new Update(this.collection, this.writeConcern, this.mapper.getQueryFactory(), query, parameters);
    }

    public WriteResult save(Object pojo) {
        return new Insert(this.collection, this.writeConcern, this.mapper.getMarshaller(), this.mapper.getObjectIdUpdater(), this.mapper.getQueryFactory()).save(pojo);
    }

    public WriteResult insert(Object pojo) {
        return this.insert(new Object[]{pojo});
    }

    public WriteResult insert(String query) {
        return this.insert(query, NO_PARAMETERS);
    }

    public WriteResult insert(Object ... pojos) {
        return new Insert(this.collection, this.writeConcern, this.mapper.getMarshaller(), this.mapper.getObjectIdUpdater(), this.mapper.getQueryFactory()).insert(pojos);
    }

    public WriteResult insert(String query, Object ... parameters) {
        return new Insert(this.collection, this.writeConcern, this.mapper.getMarshaller(), this.mapper.getObjectIdUpdater(), this.mapper.getQueryFactory()).insert(query, parameters);
    }

    public WriteResult remove(ObjectId id) {
        return this.remove("{_id:#}", id);
    }

    public WriteResult remove() {
        return this.remove(ALL);
    }

    public WriteResult remove(String query) {
        return this.remove(query, NO_PARAMETERS);
    }

    public WriteResult remove(String query, Object ... parameters) {
        return this.collection.remove(this.createQuery(query, parameters).toDBObject(), this.writeConcern);
    }

    public Distinct distinct(String key) {
        return new Distinct(this.collection, this.mapper.getUnmarshaller(), this.mapper.getQueryFactory(), key);
    }

    public Aggregate aggregate(String pipelineOperator) {
        return this.aggregate(pipelineOperator, NO_PARAMETERS);
    }

    public Aggregate aggregate(String pipelineOperator, Object ... parameters) {
        return new Aggregate(this.collection, this.mapper.getUnmarshaller(), this.mapper.getQueryFactory()).and(pipelineOperator, parameters);
    }

    public void drop() {
        this.collection.drop();
    }

    public void dropIndex(String keys) {
        this.collection.dropIndex(this.createQuery(keys, new Object[0]).toDBObject());
    }

    public void dropIndexes() {
        this.collection.dropIndexes();
    }

    public void ensureIndex(String keys) {
        this.collection.createIndex(this.createQuery(keys, new Object[0]).toDBObject());
    }

    public void ensureIndex(String keys, String options) {
        this.collection.createIndex(this.createQuery(keys, new Object[0]).toDBObject(), this.createQuery(options, new Object[0]).toDBObject());
    }

    public String getName() {
        return this.collection.getName();
    }

    public DBCollection getDBCollection() {
        return this.collection;
    }

    private Query createQuery(String query, Object ... parameters) {
        return this.mapper.getQueryFactory().createQuery(query, parameters);
    }

    public String toString() {
        if (this.collection != null) {
            return "collection {name: '" + this.collection.getName() + "', db: '" + this.collection.getDB().getName() + "'}";
        }
        return super.toString();
    }
}

