/*
 * Decompiled with CFR 0.152.
 */
package org.jongo;

import com.mongodb.DBObject;
import org.jongo.ResultHandler;
import org.jongo.bson.Bson;
import org.jongo.bson.BsonDocument;
import org.jongo.marshall.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultHandlerFactory {
    public static <T> ResultHandler<T> newResultHandler(Class<T> clazz, Unmarshaller unmarshaller) {
        return new UnmarshallingResultHandler<T>(unmarshaller, clazz);
    }

    private ResultHandlerFactory() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmarshallingResultHandler<T>
    implements ResultHandler<T> {
        private final Unmarshaller unmarshaller;
        private final Class<T> clazz;

        public UnmarshallingResultHandler(Unmarshaller unmarshaller, Class<T> clazz) {
            this.unmarshaller = unmarshaller;
            this.clazz = clazz;
        }

        @Override
        public T map(DBObject result) {
            BsonDocument bsonDocument = Bson.createDocument(result);
            return this.unmarshaller.unmarshall(bsonDocument, this.clazz);
        }
    }
}

