/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.bson;

import com.mongodb.DBCallback;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.LazyDBCallback;
import com.mongodb.LazyDBDecoder;
import com.mongodb.gridfs.GridFSDBFile;
import java.util.Iterator;
import org.jongo.bson.BsonDBObject;

public class BsonDBDecoder
extends LazyDBDecoder
implements DBDecoder {
    public static final DBDecoderFactory FACTORY = new BsonDBDecoderFactory();

    private BsonDBDecoder() {
    }

    public DBCallback getDBCallback(DBCollection collection) {
        return new CollectionDBCallback(collection);
    }

    private static class CollectionDBCallback
    extends LazyDBCallback {
        private final DBCollection collection;

        public CollectionDBCallback(DBCollection collection) {
            super(collection);
            this.collection = collection;
        }

        public Object createObject(byte[] data, int offset) {
            if (this.isGridFSCollection()) {
                return DefaultDBDecoder.FACTORY.create().decode(data, this.collection);
            }
            BsonDBObject dbo = new BsonDBObject(data, offset);
            if (this.isDBRef((DBObject)dbo)) {
                return new DBRef((String)dbo.get("$ref"), dbo.get("$id"));
            }
            return dbo;
        }

        private boolean isGridFSCollection() {
            return GridFSDBFile.class.equals((Object)this.collection.getObjectClass());
        }

        private boolean isDBRef(DBObject dbo) {
            Iterator iterator = dbo.keySet().iterator();
            return iterator.hasNext() && ((String)iterator.next()).equals("$ref") && iterator.hasNext() && ((String)iterator.next()).equals("$id");
        }
    }

    private static class BsonDBDecoderFactory
    implements DBDecoderFactory {
        private BsonDBDecoderFactory() {
        }

        public DBDecoder create() {
            return new BsonDBDecoder();
        }
    }
}

