/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.bson;

import com.mongodb.DBEncoder;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.LazyDBObject;
import com.mongodb.MongoException;
import java.io.IOException;
import java.io.OutputStream;
import org.bson.BSONObject;
import org.bson.io.OutputBuffer;

public class BsonDBEncoder
implements DBEncoder {
    public static final DBEncoderFactory FACTORY = new BsonDBEncoderFactory();

    private BsonDBEncoder() {
    }

    public int writeObject(OutputBuffer buf, BSONObject o) {
        if (!(o instanceof LazyDBObject)) {
            return DefaultDBEncoder.FACTORY.create().writeObject(buf, o);
        }
        try {
            return ((LazyDBObject)o).pipe((OutputStream)buf);
        }
        catch (IOException e) {
            throw new MongoException("Exception serializing a LazyDBObject", (Throwable)e);
        }
    }

    private static class BsonDBEncoderFactory
    implements DBEncoderFactory {
        private BsonDBEncoderFactory() {
        }

        public DBEncoder create() {
            return new BsonDBEncoder();
        }
    }
}

