/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.bson;

import com.mongodb.DBObject;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jongo.bson.BsonDBObject;
import org.jongo.bson.BsonDocument;

class LazyBsonDocument
implements BsonDocument {
    private final byte[] bytes;

    LazyBsonDocument(byte[] bytes) {
        this.bytes = bytes;
    }

    public int getSize() {
        return ByteBuffer.wrap(this.bytes).order(ByteOrder.LITTLE_ENDIAN).getInt(0);
    }

    public byte[] toByteArray() {
        return this.bytes;
    }

    public DBObject toDBObject() {
        return new BsonDBObject(this.bytes, 0);
    }

    public String toString() {
        return this.toDBObject().toString();
    }
}

