/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jongo.bson.Bson;
import org.jongo.bson.BsonDocument;
import org.jongo.marshall.Marshaller;
import org.jongo.marshall.MarshallingException;
import org.jongo.marshall.Unmarshaller;
import org.jongo.marshall.jackson.configuration.Mapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonEngine
implements Unmarshaller,
Marshaller {
    private final Mapping mapping;

    public JacksonEngine(Mapping mapping) {
        this.mapping = mapping;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapping.getObjectMapper();
    }

    @Override
    public <T> T unmarshall(BsonDocument document, Class<T> clazz) throws MarshallingException {
        try {
            return (T)this.mapping.getReader(clazz).readValue(document.toByteArray(), 0, document.getSize());
        }
        catch (IOException e) {
            String message = String.format("Unable to unmarshall result to %s from content %s", clazz, document.toString());
            throw new MarshallingException(message, e);
        }
    }

    @Override
    public BsonDocument marshall(Object pojo) throws MarshallingException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.mapping.getWriter(pojo).writeValue((OutputStream)output, pojo);
        }
        catch (IOException e) {
            throw new MarshallingException("Unable to marshall " + pojo + " into bson", e);
        }
        return Bson.createDocument(output.toByteArray());
    }
}

