/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import org.jongo.ObjectIdUpdater;
import org.jongo.marshall.jackson.oid.Id;
import org.jongo.marshall.jackson.oid.MongoId;
import org.jongo.marshall.jackson.oid.MongoObjectId;
import org.jongo.marshall.jackson.oid.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonObjectIdUpdater
implements ObjectIdUpdater {
    private final ObjectMapper mapper;

    public JacksonObjectIdUpdater(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean mustGenerateObjectId(Object pojo) {
        for (BeanPropertyDefinition def : this.beanDescription(pojo.getClass()).findProperties()) {
            if (!JacksonObjectIdUpdater.isIdProperty(def)) continue;
            AnnotatedMember accessor = def.getAccessor();
            accessor.fixAccess();
            return JacksonObjectIdUpdater.isObjectId(def) && accessor.getValue(pojo) == null;
        }
        return false;
    }

    @Override
    public Object getId(Object pojo) {
        BasicBeanDescription beanDescription = this.beanDescription(pojo.getClass());
        for (BeanPropertyDefinition def : beanDescription.findProperties()) {
            if (!JacksonObjectIdUpdater.isIdProperty(def)) continue;
            AnnotatedMember accessor = def.getAccessor();
            accessor.fixAccess();
            Object id = accessor.getValue(pojo);
            if (id instanceof String && JacksonObjectIdUpdater.isObjectId(def)) {
                return new org.bson.types.ObjectId(id.toString());
            }
            return id;
        }
        return null;
    }

    @Override
    public void setObjectId(Object target, org.bson.types.ObjectId id) {
        for (BeanPropertyDefinition def : this.beanDescription(target.getClass()).findProperties()) {
            if (!JacksonObjectIdUpdater.isIdProperty(def)) continue;
            AnnotatedMember accessor = def.getAccessor();
            accessor.fixAccess();
            if (accessor.getValue(target) != null) {
                throw new IllegalArgumentException("Unable to set objectid on class: " + target.getClass());
            }
            AnnotatedField field = def.getField();
            field.fixAccess();
            Class type = field.getRawType();
            if (org.bson.types.ObjectId.class.isAssignableFrom(type)) {
                field.setValue(target, (Object)id);
            } else if (type.equals(String.class) && JacksonObjectIdUpdater.isObjectId(def)) {
                field.setValue(target, (Object)id.toString());
            }
            return;
        }
    }

    private static boolean isIdProperty(BeanPropertyDefinition property) {
        return JacksonObjectIdUpdater.hasIdName(property) || JacksonObjectIdUpdater.hasIdAnnotation(property);
    }

    private static boolean isObjectId(BeanPropertyDefinition property) {
        return property.getPrimaryMember().getAnnotation(ObjectId.class) != null || property.getPrimaryMember().getAnnotation(MongoObjectId.class) != null || org.bson.types.ObjectId.class.isAssignableFrom(property.getAccessor().getRawType());
    }

    private static boolean hasIdName(BeanPropertyDefinition property) {
        return "_id".equals(property.getName());
    }

    private static boolean hasIdAnnotation(BeanPropertyDefinition property) {
        if (property == null) {
            return false;
        }
        AnnotatedMember accessor = property.getPrimaryMember();
        return accessor != null && (accessor.getAnnotation(MongoId.class) != null || accessor.getAnnotation(Id.class) != null);
    }

    private BasicBeanDescription beanDescription(Class<?> cls) {
        BasicClassIntrospector bci = new BasicClassIntrospector();
        return bci.forSerialization(this.mapper.getSerializationConfig(), this.mapper.constructType(cls), (ClassIntrospector.MixInResolver)this.mapper.getSerializationConfig());
    }
}

