/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import org.jongo.marshall.jackson.oid.Id;
import org.jongo.marshall.jackson.oid.MongoId;
import org.jongo.marshall.jackson.oid.MongoObjectId;
import org.jongo.marshall.jackson.oid.ObjectId;
import org.jongo.marshall.jackson.oid.ObjectIdDeserializer;
import org.jongo.marshall.jackson.oid.ObjectIdSerializer;

public class JongoAnnotationIntrospector
extends NopAnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    public JsonInclude.Include findSerializationInclusion(Annotated a, JsonInclude.Include defValue) {
        return JongoAnnotationIntrospector.hasMongoObjectId(a) ? JsonInclude.Include.NON_NULL : defValue;
    }

    public Object findSerializer(Annotated a) {
        return JongoAnnotationIntrospector.hasMongoObjectId(a) ? ObjectIdSerializer.class : super.findSerializer(a);
    }

    public Object findDeserializer(Annotated a) {
        return JongoAnnotationIntrospector.hasMongoObjectId(a) ? ObjectIdDeserializer.class : super.findDeserializer(a);
    }

    public PropertyName findNameForSerialization(Annotated a) {
        return JongoAnnotationIntrospector.hasMongoId(a) ? new PropertyName("_id") : super.findNameForSerialization(a);
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        return JongoAnnotationIntrospector.hasMongoId(a) ? new PropertyName("_id") : super.findNameForDeserialization(a);
    }

    private static boolean hasMongoId(Annotated a) {
        return a.hasAnnotation(MongoId.class) || a.hasAnnotation(Id.class);
    }

    private static boolean hasMongoObjectId(Annotated a) {
        return a.hasAnnotation(MongoObjectId.class) || a.hasAnnotation(ObjectId.class);
    }
}

