/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson.bson4jackson;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.util.Date;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

class BsonDeserializers
extends SimpleDeserializers {
    public BsonDeserializers() {
        this.addDeserializer(Date.class, new DateDeserializer());
        this.addDeserializer(MinKey.class, new MinKeyDeserializer());
        this.addDeserializer(MaxKey.class, new MaxKeyDeserializer());
        this.addDeserializer(Binary.class, new BinaryDeserializer());
        this.addDeserializer(DBObject.class, new NativeDeserializer());
        this.addDeserializer(ObjectId.class, new ObjectIdDeserializer());
        this.addDeserializer(BSONTimestamp.class, new BSONTimestampDeserializer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BSONTimestampDeserializer
    extends JsonDeserializer<BSONTimestamp> {
        private BSONTimestampDeserializer() {
        }

        public BSONTimestamp deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode timestamp = tree.get("$timestamp");
                int time = ((ValueNode)timestamp.get("t")).asInt();
                int inc = ((ValueNode)timestamp.get("i")).asInt();
                return new BSONTimestamp(time, inc);
            }
            if (tree instanceof POJONode) {
                return (BSONTimestamp)((POJONode)tree).getPojo();
            }
            throw ctxt.mappingException(BSONTimestamp.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectIdDeserializer
    extends JsonDeserializer<ObjectId> {
        private ObjectIdDeserializer() {
        }

        public ObjectId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                String hexString = ((ValueNode)tree.get("$oid")).asText();
                return new ObjectId(hexString);
            }
            if (tree instanceof POJONode) {
                return (ObjectId)((POJONode)tree).getPojo();
            }
            throw ctxt.mappingException(ObjectId.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryDeserializer
    extends JsonDeserializer<Binary> {
        private BinaryDeserializer() {
        }

        public Binary deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                byte[] binary = Base64Variants.MIME_NO_LINEFEEDS.decode(((ValueNode)tree.get("$binary")).asText());
                byte type = Integer.valueOf(((ValueNode)tree.get("$type")).asText().toLowerCase(), 16).byteValue();
                return new Binary(type, binary);
            }
            if (tree instanceof POJONode) {
                return (Binary)((POJONode)tree).getPojo();
            }
            if (tree instanceof BinaryNode) {
                return new Binary(((BinaryNode)tree).binaryValue());
            }
            throw ctxt.mappingException(ObjectId.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NativeDeserializer<T>
    extends JsonDeserializer<T> {
        private NativeDeserializer() {
        }

        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String asString = jp.readValueAsTree().toString();
            return (T)JSON.parse((String)asString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MaxKeyDeserializer
    extends JsonDeserializer<MaxKey> {
        private MaxKeyDeserializer() {
        }

        public MaxKey deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                int value = ((ValueNode)tree.get("$maxKey")).asInt();
                if (value == 1) {
                    return new MaxKey();
                }
                throw ctxt.mappingException(MaxKey.class);
            }
            if (tree instanceof POJONode) {
                return (MaxKey)((POJONode)tree).getPojo();
            }
            if (tree instanceof TextNode) {
                return new MaxKey();
            }
            throw ctxt.mappingException(MaxKey.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinKeyDeserializer
    extends JsonDeserializer<MinKey> {
        private MinKeyDeserializer() {
        }

        public MinKey deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            TreeNode tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                int value = ((ValueNode)tree.get("$minKey")).asInt();
                if (value == 1) {
                    return new MinKey();
                }
                throw ctxt.mappingException(MinKey.class);
            }
            if (tree instanceof POJONode) {
                return (MinKey)((POJONode)tree).getPojo();
            }
            if (tree instanceof TextNode) {
                return new MinKey();
            }
            throw ctxt.mappingException(MinKey.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateDeserializer
    extends JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object deserialized = jp.getEmbeddedObject();
            if (deserialized instanceof Long) {
                return this.getDateFromBackwardFormat((Long)deserialized);
            }
            return (Date)deserialized;
        }

        private Date getDateFromBackwardFormat(Long deserialized) {
            return new Date(deserialized);
        }
    }
}

