/*
 * Decompiled with CFR 0.152.
 */
package org.jongo.marshall.jackson.bson4jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import java.io.IOException;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.jongo.marshall.jackson.bson4jackson.MongoBsonGenerator;

class BsonSerializers
extends SimpleSerializers {
    public BsonSerializers() {
        this.addSerializer(ObjectId.class, new BsonObjectIdSerializer());
        this.addSerializer(BSONTimestamp.class, new BSONTimestampSerializer());
        this.addSerializer(MinKey.class, new MinKeySerializer());
        this.addSerializer(MaxKey.class, new MaxKeySerializer());
        this.addSerializer(Binary.class, new BinarySerializer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BinarySerializer
    extends JsonSerializer<Binary> {
        BinarySerializer() {
        }

        public void serialize(Binary obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (jsonGenerator instanceof MongoBsonGenerator) {
                ((MongoBsonGenerator)jsonGenerator).writeBinary(obj);
            } else {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeBinaryField("$binary", obj.getData());
                jsonGenerator.writeStringField("$type", Integer.toHexString(obj.getType()).toUpperCase());
                jsonGenerator.writeEndObject();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BsonObjectIdSerializer
    extends JsonSerializer<ObjectId> {
        BsonObjectIdSerializer() {
        }

        public void serialize(ObjectId obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (jsonGenerator instanceof MongoBsonGenerator) {
                ((MongoBsonGenerator)jsonGenerator).writeNativeObjectId(obj);
            } else {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("$oid", obj.toHexString());
                jsonGenerator.writeEndObject();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BSONTimestampSerializer
    extends JsonSerializer<BSONTimestamp> {
        BSONTimestampSerializer() {
        }

        public void serialize(BSONTimestamp obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (jsonGenerator instanceof MongoBsonGenerator) {
                ((MongoBsonGenerator)jsonGenerator).writeBSONTimestamp(obj);
            } else {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeFieldName("$timestamp");
                jsonGenerator.writeStartObject();
                jsonGenerator.writeNumberField("t", obj.getTime());
                jsonGenerator.writeNumberField("i", obj.getInc());
                jsonGenerator.writeEndObject();
                jsonGenerator.writeEndObject();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MinKeySerializer
    extends JsonSerializer<MinKey> {
        MinKeySerializer() {
        }

        public void serialize(MinKey obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (jsonGenerator instanceof MongoBsonGenerator) {
                ((MongoBsonGenerator)jsonGenerator).writeMinKey(obj);
            } else {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeNumberField("$minKey", 1);
                jsonGenerator.writeEndObject();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MaxKeySerializer
    extends JsonSerializer<MaxKey> {
        MaxKeySerializer() {
        }

        public void serialize(MaxKey obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (jsonGenerator instanceof MongoBsonGenerator) {
                ((MongoBsonGenerator)jsonGenerator).writeMaxKey(obj);
            } else {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeNumberField("$maxKey", 1);
                jsonGenerator.writeEndObject();
            }
        }
    }
}

